/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptcmodule;

import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.windows.MainWindowComponent;
import org.jphototagger.api.windows.MainWindowComponentProvider;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.TabInEditWindowDisplayedEvent;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.iptcmodule.IptcPanel;
import org.jphototagger.iptcmodule.ModuleInstaller;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CollectionUtil;
import org.openide.util.Lookup;

public final class IptcMetaDataDisplayer
implements MainWindowComponentProvider {
    private final IptcPanel iptcPanel = new IptcPanel();
    private File selectedFile;
    private boolean iptcPanelDisplayed;

    public IptcMetaDataDisplayer() {
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    private static boolean isDisplayIptcPreferred() {
        Preferences preferences = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return preferences.containsKey("UserSettings.DisplayIptc") ? preferences.getBoolean("UserSettings.DisplayIptc") : false;
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        List selectedFiles = evt.getSelectedFiles();
        if (selectedFiles.size() == 1) {
            this.selectedFile = (File)CollectionUtil.getFirstElement((Collection)selectedFiles);
            this.displaySelectedFile();
        } else {
            this.selectedFile = null;
            this.iptcPanel.removeAllRows();
        }
    }

    @EventSubscriber(eventClass=TabInEditWindowDisplayedEvent.class)
    public void tabInEditWindowDisplayed(TabInEditWindowDisplayedEvent evt) {
        boolean isDisplayIptc;
        Component selectedTabComponent = evt.getSelectedTabComponent();
        this.iptcPanelDisplayed = selectedTabComponent == this.iptcPanel;
        boolean bl = isDisplayIptc = this.iptcPanelDisplayed && this.selectedFile != null;
        if (isDisplayIptc) {
            this.displaySelectedFile();
        }
    }

    private void displaySelectedFile() {
        if (this.selectedFile == null || !this.iptcPanelDisplayed) {
            return;
        }
        DisplayIptcMetaData displayIptcMetaData = new DisplayIptcMetaData(this.selectedFile, this.iptcPanel);
        EventQueueUtil.invokeInDispatchThread((Runnable)displayIptcMetaData);
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        if (this.selectedFile == null) {
            return;
        }
        String key = evt.getKey();
        if ("UserSettings.DisplayIptc".equals(key)) {
            boolean isDisplay = (Boolean)evt.getNewValue();
            if (isDisplay) {
                this.displaySelectedFile();
            } else {
                this.iptcPanel.removeAllRows();
            }
        } else if ("UserSettings.IptcCharset".equals(key)) {
            this.displaySelectedFile();
        }
    }

    public Collection<? extends MainWindowComponent> getMainWindowSelectionComponents() {
        return Collections.emptyList();
    }

    public Collection<? extends MainWindowComponent> getMainWindowEditComponents() {
        return Arrays.asList(new MainWindowComponent(){

            public Component getComponent() {
                return IptcMetaDataDisplayer.this.iptcPanel;
            }

            public Icon getSmallIcon() {
                return IconUtil.getImageIcon(ModuleInstaller.class, (String)"iptc.png");
            }

            public Icon getLargeIcon() {
                return null;
            }

            public int getPosition() {
                return 1;
            }

            public String getTitle() {
                return Bundle.getString(ModuleInstaller.class, (String)"IptcPanel.WindowTitle", (Object[])new Object[0]);
            }

            public String getTooltipText() {
                return null;
            }

            public KeyStroke getOptionalSelectionAccelaratorKey() {
                return null;
            }
        });
    }

    public static class DisplayIptcMetaData
    implements Runnable {
        private final File file;
        private final IptcPanel iptcPanel;
        private static final Logger LOGGER = Logger.getLogger(DisplayIptcMetaData.class.getName());

        public DisplayIptcMetaData(File file, IptcPanel iptcPanel) {
            this.file = file;
            this.iptcPanel = iptcPanel;
        }

        @Override
        public void run() {
            if (this.file == null) {
                return;
            }
            if (this.isDisplayIptc()) {
                LOGGER.log(Level.FINEST, "Updating IPTC metadata of image file ''{0}'' in GUI table", this.file);
                WaitDisplayer waitDisplayer = (WaitDisplayer)Lookup.getDefault().lookup(WaitDisplayer.class);
                waitDisplayer.show();
                this.iptcPanel.setFile(this.file);
                waitDisplayer.hide();
            }
        }

        private boolean isDisplayIptc() {
            MainWindowManager windowManager = (MainWindowManager)Lookup.getDefault().lookup(MainWindowManager.class);
            boolean iptcPanelSelected = windowManager.isEditComponentSelected((Component)this.iptcPanel);
            return iptcPanelSelected && IptcMetaDataDisplayer.isDisplayIptcPreferred();
        }
    }
}

