/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptcmodule;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.iptcmodule.IptcToXmpDialog;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;

public final class ExportIptcToXmpOfSelectedFilesAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final List<File> selectedFiles = new ArrayList<File>();

    public ExportIptcToXmpOfSelectedFilesAction() {
        super(Bundle.getString(ExportIptcToXmpOfSelectedFilesAction.class, (String)"ExportIptcToXmpOfSelectedFilesAction.Name", (Object[])new Object[0]));
        this.putValue("SmallIcon", IconUtil.getImageIcon(ExportIptcToXmpOfSelectedFilesAction.class, (String)"iptc.png"));
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.processSelectedFiles();
    }

    private void processSelectedFiles() {
        if (this.selectedFiles.size() > 0) {
            IptcToXmpDialog dlg = new IptcToXmpDialog();
            dlg.setFiles(this.selectedFiles);
            dlg.setVisible(true);
        }
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        this.selectedFiles.clear();
        this.selectedFiles.addAll(evt.getSelectedFiles());
        this.setEnabled(!this.selectedFiles.isEmpty());
    }
}

