/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.iptcmodule;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.metadata.iptc.Iptc;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.domain.repository.SaveToOrUpdateFilesInRepository;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.iptc.IptcMetadata;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.xmp.XmpMetadata;
import org.openide.util.Lookup;

public final class ConvertIptcToXmp
implements Runnable,
Cancelable {
    private final List<ProgressListener> progressListeners = new ArrayList<ProgressListener>();
    private final List<File> files;
    private boolean cancel;
    private static final Logger LOGGER = Logger.getLogger(ConvertIptcToXmp.class.getName());
    private final XmpSidecarFileResolver xmpSidecarFileResolver = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);

    public ConvertIptcToXmp(Collection<? extends File> imageFiles) {
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        this.files = new ArrayList<File>(imageFiles);
    }

    public synchronized void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.progressListeners.add(listener);
    }

    public void cancel() {
        this.cancel = true;
    }

    @Override
    public void run() {
        int index;
        this.notifyStart();
        int size = this.files.size();
        for (index = 0; !this.cancel && index < size; ++index) {
            File file = this.files.get(index);
            File xmpFile = this.xmpSidecarFileResolver.suggestXmpSidecarFile(file);
            Iptc iptc = null;
            if (!this.isUserDefinedFileType(file)) {
                iptc = IptcMetadata.getIptc((File)file);
            }
            if (iptc != null) {
                Xmp xmp = null;
                try {
                    xmp = XmpMetadata.getXmpFromSidecarFileOf((File)file);
                }
                catch (IOException ex) {
                    Logger.getLogger(ConvertIptcToXmp.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (xmp == null) {
                    xmp = new Xmp();
                }
                xmp.setIptc(iptc, Xmp.SetIptc.DONT_CHANGE_EXISTING_VALUES);
                this.logWriteXmpFile(file);
                if (XmpMetadata.writeXmpToSidecarFile((Xmp)xmp, (File)xmpFile)) {
                    this.updateRepository(file);
                }
            }
            this.notifyPerformed(index);
        }
        this.notifyEnd(index);
    }

    private boolean isUserDefinedFileType(File file) {
        String suffix = FileUtil.getSuffix((File)file);
        UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
        return repo.existsUserDefinedFileTypeWithSuffix(suffix);
    }

    private void updateRepository(File imageFile) {
        SaveToOrUpdateFilesInRepository updater = ((SaveToOrUpdateFilesInRepository)Lookup.getDefault().lookup(SaveToOrUpdateFilesInRepository.class)).createInstance(Arrays.asList(imageFile), new SaveOrUpdate[]{SaveOrUpdate.XMP});
        updater.saveOrUpdateWaitForTermination();
    }

    private void checkCancel(ProgressEvent event) {
        if (event.isCancel()) {
            this.cancel();
        }
    }

    private void logWriteXmpFile(File imageFile) {
        LOGGER.log(Level.INFO, "Write XMP sidecar file from IPTC in file ''{0}''", imageFile);
    }

    private synchronized void notifyStart() {
        int count = this.files.size();
        String info = this.files.size() > 0 ? (Serializable)this.files.get(0) : "";
        ProgressEvent event = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(count).value(0).info((Object)info).build();
        for (ProgressListener progressListener : this.progressListeners) {
            progressListener.progressStarted(event);
            this.checkCancel(event);
        }
    }

    private synchronized void notifyPerformed(int index) {
        ProgressEvent event = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(this.files.size()).value(index + 1).info((Object)this.files.get(index)).build();
        for (ProgressListener progressListener : this.progressListeners) {
            progressListener.progressPerformed(event);
            this.checkCancel(event);
        }
    }

    private synchronized void notifyEnd(int index) {
        ProgressEvent event = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(this.files.size()).value(index + 1).info((Object)"").build();
        for (ProgressListener progressListener : this.progressListeners) {
            progressListener.progressEnded(event);
        }
    }
}

