/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.domain.repository.WordsetsRepository;
import org.jphototagger.domain.wordsets.Wordset;
import org.jphototagger.eximport.jpt.exporter.WordsetsExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.openide.util.Lookup;

public final class WordsetsImporter
implements RepositoryDataImporter {
    private final WordsetsRepository repo = (WordsetsRepository)Lookup.getDefault().lookup(WordsetsRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            WordsetsExporter.CollectionWrapper wrapper = (WordsetsExporter.CollectionWrapper)XmlObjectImporter.importObject((File)file, WordsetsExporter.CollectionWrapper.class);
            for (Wordset wordset : wrapper.getCollection()) {
                if (this.repo.existsWordset(wordset.getName())) continue;
                this.repo.insert(wordset);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(WordsetsImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return WordsetsExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return WordsetsExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptWordsets.xml";
    }

    public int getPosition() {
        return 130;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

