/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.eximport.jpt.exporter.UserDefinedFileTypesExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.openide.util.Lookup;

public final class UserDefinedFileTpyesImporter
implements RepositoryDataImporter {
    private final UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            UserDefinedFileTypesExporter.CollectionWrapper wrapper = (UserDefinedFileTypesExporter.CollectionWrapper)XmlObjectImporter.importObject((File)file, UserDefinedFileTypesExporter.CollectionWrapper.class);
            for (UserDefinedFileType fileType : wrapper.getCollection()) {
                if (this.repo.existsUserDefinedFileTypeWithSuffix(fileType.getSuffix())) continue;
                this.repo.saveUserDefinedFileType(fileType);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(UserDefinedFileTpyesImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return UserDefinedFileTypesExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return UserDefinedFileTypesExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptUserDefinedFileTypes.xml";
    }

    public int getPosition() {
        return 120;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

