/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.jphototagger.domain.filefilter.UserDefinedFileFilter;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.domain.repository.UserDefinedFileFiltersRepository;
import org.jphototagger.eximport.jpt.exporter.UserDefinedFileFilterExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.openide.util.Lookup;

public final class UserDefinedFileFilterImporter
implements RepositoryDataImporter {
    private final UserDefinedFileFiltersRepository repo = (UserDefinedFileFiltersRepository)Lookup.getDefault().lookup(UserDefinedFileFiltersRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            UserDefinedFileFilterExporter.CollectionWrapper wrapper = (UserDefinedFileFilterExporter.CollectionWrapper)XmlObjectImporter.importObject((File)file, UserDefinedFileFilterExporter.CollectionWrapper.class);
            for (UserDefinedFileFilter filter : wrapper.getCollection()) {
                if (this.repo.existsUserDefinedFileFilter(filter.getName())) continue;
                this.repo.saveUserDefinedFileFilter(filter);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(UserDefinedFileFilterImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return UserDefinedFileFilterExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return UserDefinedFileFilterExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptFileFilters.xml";
    }

    public int getPosition() {
        return 110;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

