/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.domain.repository.SynonymsRepository;
import org.jphototagger.eximport.jpt.exporter.SynonymsExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SynonymsImporter
implements RepositoryDataImporter,
EntityResolver {
    private static final long serialVersionUID = 1L;
    private final SynonymsRepository repo = (SynonymsRepository)Lookup.getDefault().lookup(SynonymsRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(this);
            Document doc = docBuilder.parse(file);
            this.importSynonyms(doc);
        }
        catch (Throwable t) {
            Logger.getLogger(SynonymsImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private void importSynonyms(Document doc) {
        NodeList entries = doc.getElementsByTagName("entry");
        int entryCount = entries.getLength();
        for (int i = 0; i < entryCount; ++i) {
            Node entryNode = entries.item(i);
            NodeList entryElts = entryNode.getChildNodes();
            int eltCount = entryElts.getLength();
            assert (eltCount >= 2) : eltCount;
            if (eltCount < 2) continue;
            ArrayList<String> synonyms = new ArrayList<String>();
            String word = "";
            for (int j = 0; j < eltCount; ++j) {
                Node node = entryElts.item(j);
                String text = node.getTextContent();
                if (text != null && node.getNodeName().equals("word")) {
                    word = text.trim();
                    continue;
                }
                if (text == null || !node.getNodeName().equals("synonym")) continue;
                synonyms.add(text.trim());
            }
            for (String synonym : synonyms) {
                this.repo.saveSynonym(word, synonym);
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId == null) {
            throw new NullPointerException("systemId == null");
        }
        InputStream stream = null;
        String dtd = "synonyms.dtd";
        if (systemId.endsWith(dtd)) {
            String name = "/org/jphototagger/program/resource/dtd/" + dtd;
            stream = EntityResolver.class.getResourceAsStream(name);
            assert (stream != null) : name;
        }
        return stream == null ? null : new InputSource(new InputStreamReader(stream));
    }

    public FileFilter getFileFilter() {
        return SynonymsExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return SynonymsExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptSynonyms.xml";
    }

    public int getPosition() {
        return 20;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

