/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.jphototagger.domain.metadata.search.SavedSearch;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.domain.repository.SavedSearchesRepository;
import org.jphototagger.eximport.jpt.exporter.SavedSearchesExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.openide.util.Lookup;

public final class SavedSearchesImporter
implements RepositoryDataImporter {
    private final SavedSearchesRepository repo = (SavedSearchesRepository)Lookup.getDefault().lookup(SavedSearchesRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            SavedSearchesExporter.CollectionWrapper wrapper = (SavedSearchesExporter.CollectionWrapper)XmlObjectImporter.importObject((File)file, SavedSearchesExporter.CollectionWrapper.class);
            for (SavedSearch savedSearch : wrapper.getCollection()) {
                if (!savedSearch.isValid() || this.repo.existsSavedSearch(savedSearch.getName())) continue;
                this.repo.saveSavedSearch(savedSearch);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(SavedSearchesImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return SavedSearchesExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return SavedSearchesExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptSavedSearches.xml";
    }

    public int getPosition() {
        return 40;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

