/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.jphototagger.domain.repository.RenameTemplatesRepository;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.domain.templates.RenameTemplate;
import org.jphototagger.eximport.jpt.exporter.RenameTemplatesExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.openide.util.Lookup;

public final class RenameTemplatesImporter
implements RepositoryDataImporter {
    private final RenameTemplatesRepository repo = (RenameTemplatesRepository)Lookup.getDefault().lookup(RenameTemplatesRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            RenameTemplatesExporter.CollectionWrapper wrapper = (RenameTemplatesExporter.CollectionWrapper)XmlObjectImporter.importObject((File)file, RenameTemplatesExporter.CollectionWrapper.class);
            for (RenameTemplate template : wrapper.getCollection()) {
                if (this.repo.existsRenameTemplate(template.getName())) continue;
                this.repo.saveRenameTemplate(template);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(RenameTemplatesImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return RenameTemplatesExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return RenameTemplatesExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptRenameTemplates.xml";
    }

    public int getPosition() {
        return 30;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

