/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.eximport.jpt.exporter.ProgramsExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.openide.util.Lookup;

public final class ProgramsImporter
implements RepositoryDataImporter {
    private final ProgramsRepository repo = (ProgramsRepository)Lookup.getDefault().lookup(ProgramsRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            ProgramsExporter.CollectionWrapper wrapper = (ProgramsExporter.CollectionWrapper)XmlObjectImporter.importObject((File)file, ProgramsExporter.CollectionWrapper.class);
            for (Program program : wrapper.getCollection()) {
                if (this.repo.existsProgram(program)) continue;
                this.repo.saveProgram(program);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(ProgramsImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return ProgramsExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return ProgramsExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptPrograms.xml";
    }

    public int getPosition() {
        return 70;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

