/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.repository.MetadataTemplatesRepository;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.eximport.jpt.exporter.MetadataTemplatesExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.xmp.EditableMetaDataValues;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MetadataTemplatesImporter
implements RepositoryDataImporter,
EntityResolver {
    private static final long serialVersionUID = 1L;
    private static final Map<String, MetaDataValue> META_DATA_VALUE_OF_CLASSNAME = new HashMap<String, MetaDataValue>();
    private final MetadataTemplatesRepository repo = (MetadataTemplatesRepository)Lookup.getDefault().lookup(MetadataTemplatesRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(this);
            Document doc = docBuilder.parse(file);
            this.importTemplates(doc);
        }
        catch (Throwable t) {
            Logger.getLogger(MetadataTemplatesImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private void importTemplates(Document doc) {
        NodeList templates = doc.getElementsByTagName("template");
        int templateCount = templates.getLength();
        for (int i = 0; i < templateCount; ++i) {
            Node templateNode = templates.item(i);
            if (!templateNode.getNodeName().equals("template")) continue;
            NodeList entryNodeList = templateNode.getChildNodes();
            int entryCount = entryNodeList.getLength();
            MetadataTemplate template = new MetadataTemplate();
            template.setName(templateNode.getAttributes().getNamedItem("name").getNodeValue().trim());
            for (int j = 0; j < entryCount; ++j) {
                NamedNodeMap attrMap;
                String valueStr;
                Node entryNode = entryNodeList.item(j);
                if (!entryNode.getNodeName().equals("entry") || (valueStr = (attrMap = entryNode.getAttributes()).getNamedItem("value").getNodeValue().trim()).isEmpty() || valueStr.equals("null")) continue;
                String mdClassName = attrMap.getNamedItem("column").getNodeValue().trim();
                String valueType = attrMap.getNamedItem("valuetype").getNodeValue().trim();
                this.insert(mdClassName, valueType, valueStr, template);
            }
            if (template.getName() == null || this.repo.existsMetadataTemplate(template.getName())) continue;
            this.repo.saveOrUpdateMetadataTemplate(template);
        }
    }

    private void insert(String mdClassName, String valueType, String valueStr, MetadataTemplate template) {
        MetaDataValue mdValue = META_DATA_VALUE_OF_CLASSNAME.get(mdClassName);
        assert (mdValue != null);
        template.setMetaDataValue(mdValue, this.getValue(valueType, valueStr));
    }

    private Object getValue(String valueType, String valueStr) {
        if (valueType.equals("java.lang.String")) {
            return valueStr;
        }
        if (valueType.equals("java.util.Collection")) {
            StringTokenizer st = new StringTokenizer(valueStr, "|");
            ArrayList<String> collection = new ArrayList<String>(st.countTokens());
            while (st.hasMoreTokens()) {
                collection.add(st.nextToken());
            }
            if (!collection.isEmpty()) {
                return collection;
            }
        } else assert (false) : valueType;
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId == null) {
            throw new NullPointerException("systemId == null");
        }
        InputStream stream = null;
        String dtd = "metadatatemplates.dtd";
        if (systemId.endsWith(dtd)) {
            String name = "/org/jphototagger/program/resource/dtd/" + dtd;
            stream = EntityResolver.class.getResourceAsStream(name);
            assert (stream != null) : name;
        }
        return stream == null ? null : new InputSource(new InputStreamReader(stream));
    }

    public FileFilter getFileFilter() {
        return MetadataTemplatesExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return MetadataTemplatesExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptMetadataTemplates.xml";
    }

    public int getPosition() {
        return 60;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }

    static {
        for (MetaDataValue mdValue : EditableMetaDataValues.get()) {
            META_DATA_VALUE_OF_CLASSNAME.put(mdValue.getClass().getName(), mdValue);
        }
    }
}

