/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.jphototagger.domain.repository.FileExcludePatternsRepository;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.eximport.jpt.exporter.FileExcludePatternsExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.lib.xml.bind.StringWrapper;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.openide.util.Lookup;

public final class FileExcludePatternsImporter
implements RepositoryDataImporter {
    private final FileExcludePatternsRepository repo = (FileExcludePatternsRepository)Lookup.getDefault().lookup(FileExcludePatternsRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            FileExcludePatternsExporter.CollectionWrapper wrapper = (FileExcludePatternsExporter.CollectionWrapper)XmlObjectImporter.importObject((File)file, FileExcludePatternsExporter.CollectionWrapper.class);
            for (StringWrapper stringWrapper : wrapper.getCollection()) {
                if (this.repo.existsFileExcludePattern(stringWrapper.getString())) continue;
                this.repo.saveFileExcludePattern(stringWrapper.getString());
            }
        }
        catch (Throwable t) {
            Logger.getLogger(FileExcludePatternsImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return FileExcludePatternsExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return FileExcludePatternsExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptFileExludePatterns.xml";
    }

    public int getPosition() {
        return 100;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

