/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.domain.repository.FavoritesRepository;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.eximport.jpt.exporter.FavoritesExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.openide.util.Lookup;

public final class FavoritesImporter
implements RepositoryDataImporter {
    private final FavoritesRepository repo = (FavoritesRepository)Lookup.getDefault().lookup(FavoritesRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            FavoritesExporter.CollectionWrapper wrapper = (FavoritesExporter.CollectionWrapper)XmlObjectImporter.importObject((File)file, FavoritesExporter.CollectionWrapper.class);
            for (Favorite favorite : wrapper.getCollection()) {
                if (this.repo.existsFavorite(favorite.getName())) continue;
                this.repo.saveOrUpdateFavorite(favorite);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(FavoritesImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return FavoritesExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return FavoritesExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptFavorites.xml";
    }

    public int getPosition() {
        return 80;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

