/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.jphototagger.domain.repository.AutoscanDirectoriesRepository;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.eximport.jpt.exporter.AutoscanDirectoriesExporter;
import org.jphototagger.eximport.jpt.importer.ImportPreferences;
import org.jphototagger.lib.xml.bind.StringWrapper;
import org.jphototagger.lib.xml.bind.XmlObjectImporter;
import org.openide.util.Lookup;

public final class AutoscanDirectoriesImporter
implements RepositoryDataImporter {
    private final AutoscanDirectoriesRepository repo = (AutoscanDirectoriesRepository)Lookup.getDefault().lookup(AutoscanDirectoriesRepository.class);

    public void importFromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            AutoscanDirectoriesExporter.CollectionWrapper wrapper = (AutoscanDirectoriesExporter.CollectionWrapper)XmlObjectImporter.importObject((File)file, AutoscanDirectoriesExporter.CollectionWrapper.class);
            for (StringWrapper stringWrapper : wrapper.getCollection()) {
                if (this.repo.existsAutoscanDirectory(new File(stringWrapper.getString()))) continue;
                this.repo.saveAutoscanDirectory(new File(stringWrapper.getString()));
            }
        }
        catch (Throwable t) {
            Logger.getLogger(AutoscanDirectoriesImporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return AutoscanDirectoriesExporter.FILE_FILTER;
    }

    public String getDisplayName() {
        return AutoscanDirectoriesExporter.DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ImportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return "JptAutoscanDirectories.xml";
    }

    public int getPosition() {
        return 90;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }
}

