/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.exporter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.repository.RepositoryDataExporter;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.eximport.jpt.exporter.ExportPreferences;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.xml.bind.XmlObjectExporter;
import org.openide.util.Lookup;

public final class UserDefinedFileTypesExporter
implements RepositoryDataExporter {
    public static final String DEFAULT_FILENAME = "JptUserDefinedFileTypes.xml";
    public static final String DISPLAY_NAME = Bundle.getString(UserDefinedFileTypesExporter.class, (String)"UserDefinedFileTypesExporter.DisplayName", (Object[])new Object[0]);
    private static final String FILE_FILTER_DESCRIPTION = Bundle.getString(UserDefinedFileTypesExporter.class, (String)"UserDefinedFileTypesExporter.FileFilterDescription", (Object[])new Object[0]);
    private static final String FILE_FILTER_SUFFIX = "xml";
    public static final FileFilter FILE_FILTER = new FileNameExtensionFilter(FILE_FILTER_DESCRIPTION, "xml");
    public static final int POSITION = 120;
    private final UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);

    public void exportToFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        File xmpFile = FileUtil.ensureSuffix((File)file, (String)".xml");
        try {
            List filter = this.repo.findAllUserDefinedFileTypes();
            XmlObjectExporter.export((Object)new CollectionWrapper(filter), (File)xmpFile);
        }
        catch (Throwable t) {
            Logger.getLogger(UserDefinedFileTypesExporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return FILE_FILTER;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ExportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return DEFAULT_FILENAME;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }

    public int getPosition() {
        return 120;
    }

    @XmlRootElement
    public static class CollectionWrapper {
        @XmlElementWrapper(name="FileType")
        @XmlElement(type=UserDefinedFileType.class)
        private final ArrayList<UserDefinedFileType> collection = new ArrayList();

        public CollectionWrapper() {
        }

        public CollectionWrapper(Collection<UserDefinedFileType> collection) {
            this.collection.addAll(collection);
        }

        public List<UserDefinedFileType> getCollection() {
            return new ArrayList<UserDefinedFileType>(this.collection);
        }
    }
}

