/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.exporter;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jphototagger.domain.repository.RepositoryDataExporter;
import org.jphototagger.domain.repository.SynonymsRepository;
import org.jphototagger.eximport.jpt.exporter.ExportPreferences;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SynonymsExporter
implements RepositoryDataExporter {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_FILENAME = "JptSynonyms.xml";
    public static final String DISPLAY_NAME = Bundle.getString(SynonymsExporter.class, (String)"SynonymsExporter.DisplayName", (Object[])new Object[0]);
    public static final int POSITION = 20;
    private static final String FILE_FILTER_DESCRIPTION = Bundle.getString(SynonymsExporter.class, (String)"SynonymsExporter.FileFilterDescription", (Object[])new Object[0]);
    private static final String FILE_FILTER_SUFFIX = "xml";
    public static final FileFilter FILE_FILTER = new FileNameExtensionFilter(FILE_FILTER_DESCRIPTION, "xml");
    public static final String DTD = "synonyms.dtd";
    public static final String TAGNAME_ROOT = "synonyms";
    public static final String TAGNAME_ENTRY = "entry";
    public static final String TAGNAME_WORD = "word";
    public static final String TAGNAME_SYNONYM = "synonym";
    private final SynonymsRepository repo = (SynonymsRepository)Lookup.getDefault().lookup(SynonymsRepository.class);

    public void exportToFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try {
            Document doc = this.getDoc();
            DOMSource ds = new DOMSource(doc);
            StreamResult sr = new StreamResult(file);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            this.insertSynonyms(doc);
            this.initTransformer(trans);
            trans.transform(ds, sr);
        }
        catch (Throwable t) {
            Logger.getLogger(SynonymsExporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private void insertSynonyms(Document doc) {
        Element rootElement = doc.createElement(TAGNAME_ROOT);
        doc.appendChild(rootElement);
        for (String word : this.repo.findAllWords()) {
            Element entryElement = doc.createElement(TAGNAME_ENTRY);
            Element wordElement = doc.createElement(TAGNAME_WORD);
            wordElement.setTextContent(word);
            entryElement.appendChild(wordElement);
            for (String synonym : this.repo.findSynonymsOfWord(word)) {
                Element synonymElement = doc.createElement(TAGNAME_SYNONYM);
                synonymElement.setTextContent(synonym);
                entryElement.appendChild(synonymElement);
            }
            rootElement.appendChild(entryElement);
        }
    }

    private Document getDoc() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        Document doc = impl.createDocument(null, null, null);
        return doc;
    }

    private void initTransformer(Transformer trans) throws IllegalArgumentException {
        trans.setOutputProperty("method", FILE_FILTER_SUFFIX);
        trans.setOutputProperty("encoding", "UTF8");
        trans.setOutputProperty("doctype-system", DTD);
        trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("standalone", "no");
    }

    public FileFilter getFileFilter() {
        return FILE_FILTER;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ExportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return DEFAULT_FILENAME;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }

    public int getPosition() {
        return 20;
    }
}

