/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.exporter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.domain.repository.FavoritesRepository;
import org.jphototagger.domain.repository.RepositoryDataExporter;
import org.jphototagger.eximport.jpt.exporter.ExportPreferences;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.xml.bind.XmlObjectExporter;
import org.openide.util.Lookup;

public final class FavoritesExporter
implements RepositoryDataExporter {
    public static final String DEFAULT_FILENAME = "JptFavorites.xml";
    public static final String DISPLAY_NAME = Bundle.getString(FavoritesExporter.class, (String)"FavoritesExporter.DisplayName", (Object[])new Object[0]);
    private static final String FILE_FILTER_DESCRIPTION = Bundle.getString(FavoritesExporter.class, (String)"FavoritesExporter.FileFilterDescription", (Object[])new Object[0]);
    private static final String FILE_FILTER_SUFFIX = "xml";
    public static final FileFilter FILE_FILTER = new FileNameExtensionFilter(FILE_FILTER_DESCRIPTION, "xml");
    public static final int POSITION = 80;
    private final FavoritesRepository repo = (FavoritesRepository)Lookup.getDefault().lookup(FavoritesRepository.class);

    public void exportToFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        File xmlFile = FileUtil.ensureSuffix((File)file, (String)".xml");
        try {
            List templates = this.repo.findAllFavorites();
            XmlObjectExporter.export((Object)new CollectionWrapper(templates), (File)xmlFile);
        }
        catch (Throwable t) {
            Logger.getLogger(FavoritesExporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return FILE_FILTER;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ExportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return DEFAULT_FILENAME;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }

    public int getPosition() {
        return 80;
    }

    @XmlRootElement
    public static class CollectionWrapper {
        @XmlElementWrapper(name="Favorites")
        @XmlElement(type=Favorite.class)
        private final ArrayList<Favorite> collection = new ArrayList();

        public CollectionWrapper() {
        }

        public CollectionWrapper(Collection<Favorite> collection) {
            this.collection.addAll(collection);
        }

        public List<Favorite> getCollection() {
            return new ArrayList<Favorite>(this.collection);
        }
    }
}

