/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.eximport.jpt.exporter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jphototagger.domain.repository.AutoscanDirectoriesRepository;
import org.jphototagger.domain.repository.RepositoryDataExporter;
import org.jphototagger.eximport.jpt.exporter.ExportPreferences;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.xml.bind.StringWrapper;
import org.jphototagger.lib.xml.bind.XmlObjectExporter;
import org.openide.util.Lookup;

public final class AutoscanDirectoriesExporter
implements RepositoryDataExporter {
    public static final String DEFAULT_FILENAME = "JptAutoscanDirectories.xml";
    public static final String DISPLAY_NAME = Bundle.getString(AutoscanDirectoriesExporter.class, (String)"AutoscanDirectoriesExporter.DisplayName", (Object[])new Object[0]);
    private static final String FILE_FILTER_DESCRIPTION = Bundle.getString(AutoscanDirectoriesExporter.class, (String)"AutoscanDirectoriesExporter.FileFilterDescription", (Object[])new Object[0]);
    private static final String FILE_FILTER_SUFFIX = "xml";
    public static final FileFilter FILE_FILTER = new FileNameExtensionFilter(FILE_FILTER_DESCRIPTION, "xml");
    public static final int POSITION = 90;
    private final AutoscanDirectoriesRepository repo = (AutoscanDirectoriesRepository)Lookup.getDefault().lookup(AutoscanDirectoriesRepository.class);

    public void exportToFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        File xmlFile = FileUtil.ensureSuffix((File)file, (String)".xml");
        try {
            List directories = FileUtil.getAbsolutePathnames((Collection)this.repo.findAllAutoscanDirectories());
            XmlObjectExporter.export((Object)new CollectionWrapper(StringWrapper.getWrappedStrings((Collection)directories)), (File)xmlFile);
        }
        catch (Throwable t) {
            Logger.getLogger(AutoscanDirectoriesExporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public FileFilter getFileFilter() {
        return FILE_FILTER;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public Icon getIcon() {
        return ExportPreferences.ICON;
    }

    public String getDefaultFilename() {
        return DEFAULT_FILENAME;
    }

    public boolean isJPhotoTaggerData() {
        return true;
    }

    public int getPosition() {
        return 90;
    }

    @XmlRootElement
    public static class CollectionWrapper {
        @XmlElementWrapper(name="AutoscanDirectories")
        @XmlElement(type=StringWrapper.class)
        private final ArrayList<StringWrapper> collection = new ArrayList();

        public CollectionWrapper() {
        }

        public CollectionWrapper(Collection<StringWrapper> collection) {
            this.collection.addAll(collection);
        }

        public List<StringWrapper> getCollection() {
            return new ArrayList<StringWrapper>(this.collection);
        }
    }
}

