/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.htmlreports;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.plugin.htmlreports.DefaultMetaDataValues;
import org.jphototagger.plugin.htmlreports.MetaDataValueSelectionPanel;

public class MetaDataValueSelectionPanels
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private boolean setValues;
    private JPanel fillPanel;
    private MetaDataValueSelectionPanel firstSelectionPanel;
    private JPanel panels;
    private JScrollPane scrollPane;

    public MetaDataValueSelectionPanels() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.addFillPanel();
        this.firstSelectionPanel.addPropertyChangeListener(this);
        this.setValues(DefaultMetaDataValues.INSTANCE.getValues());
    }

    private void addFillPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.fill = 3;
        this.panels.add((Component)this.fillPanel, gbc);
    }

    private void addPanel(MetaDataValueSelectionPanel selectionPanel) {
        selectionPanel.enableRemove();
        selectionPanel.addPropertyChangeListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 0, 0, 0);
        this.panels.remove(this.fillPanel);
        this.panels.add((Component)selectionPanel, gbc);
        this.addFillPanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("add".equals(propertyName)) {
            this.addPanel(new MetaDataValueSelectionPanel());
            this.repaintPanels();
        } else if ("remove".equals(propertyName)) {
            Object source = evt.getSource();
            if (!this.firstSelectionPanel.equals(source)) {
                this.panels.remove((Component)source);
                this.persistSelectedValues();
                this.repaintPanels();
            }
        } else if ("metaDataValue".equals(propertyName)) {
            this.persistSelectedValues();
        }
    }

    private void repaintPanels() {
        ComponentUtil.forceRepaint((Component)this.panels);
        Container parent = this.getParent();
        if (parent != null) {
            ComponentUtil.forceRepaint((Component)parent);
        }
    }

    private void persistSelectedValues() {
        if (!this.setValues) {
            DefaultMetaDataValues.INSTANCE.setValues(this.getSelectedValues());
        }
    }

    public Collection<MetaDataValue> getSelectedValues() {
        LinkedList<MetaDataValue> selectedValues = new LinkedList<MetaDataValue>();
        for (Component component : this.panels.getComponents()) {
            MetaDataValueSelectionPanel selectionPanel;
            MetaDataValue selectedValue;
            if (!(component instanceof MetaDataValueSelectionPanel) || (selectedValue = (selectionPanel = (MetaDataValueSelectionPanel)component).getSelectedMetaDataValue()) == null) continue;
            selectedValues.add(selectedValue);
        }
        return selectedValues;
    }

    void setValues(Collection<MetaDataValue> metaDataValues) {
        this.setValues = true;
        this.removeAllPanels();
        this.firstSelectionPanel.selectNone();
        boolean firstPanelSet = false;
        for (MetaDataValue metaDataValue : metaDataValues) {
            MetaDataValueSelectionPanel selectionPanel = firstPanelSet ? new MetaDataValueSelectionPanel() : this.firstSelectionPanel;
            selectionPanel.select(metaDataValue);
            if (firstPanelSet) {
                this.addPanel(selectionPanel);
            }
            firstPanelSet = true;
        }
        this.setValues = false;
    }

    private void removeAllPanels() {
        Component[] components = this.getComponents();
        ArrayList<MetaDataValueSelectionPanel> panelsToRemove = new ArrayList<MetaDataValueSelectionPanel>(components.length);
        for (Component component : components) {
            MetaDataValueSelectionPanel panel;
            if (!(component instanceof MetaDataValueSelectionPanel) || (panel = (MetaDataValueSelectionPanel)component) == this.firstSelectionPanel) continue;
            panelsToRemove.add(panel);
        }
        for (MetaDataValueSelectionPanel panel : panelsToRemove) {
            this.panels.remove(panel);
        }
    }

    private void initComponents() {
        this.fillPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.panels = new JPanel();
        this.firstSelectionPanel = new MetaDataValueSelectionPanel();
        this.fillPanel.setName("fillPanel");
        GroupLayout fillPanelLayout = new GroupLayout(this.fillPanel);
        this.fillPanel.setLayout(fillPanelLayout);
        fillPanelLayout.setHorizontalGroup(fillPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        fillPanelLayout.setVerticalGroup(fillPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.scrollPane.setName("scrollPane");
        this.panels.setName("panels");
        this.panels.setLayout(new GridBagLayout());
        this.firstSelectionPanel.setName("firstSelectionPanel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panels.add((Component)this.firstSelectionPanel, gridBagConstraints);
        this.scrollPane.setViewportView(this.panels);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
    }
}

