/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.htmlreports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.MetaDataValueProvider;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public class MetaDataValueSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ComboBoxModel<Object> comboBoxModel = new MetaDataValuesComboBoxModel();
    private final ListCellRenderer<Object> listCellRenderer = new MetaDataValuesListCellRenderer();
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JComboBox<Object> metaDataValuesComboBox;

    public MetaDataValueSelectionPanel() {
        this.initComponents();
    }

    private void addMetaDataValueSelectionPanel() {
        this.firePropertyChange("add", null, null);
    }

    private void removeMetaDataValueSelectionPanel() {
        this.firePropertyChange("remove", null, null);
    }

    private void valueChanged() {
        Object selectedItem = this.comboBoxModel.getSelectedItem();
        this.firePropertyChange("metaDataValue", null, selectedItem);
        if (MetaDataValuesComboBoxModel.NONE.equals(selectedItem)) {
            this.firePropertyChange("remove", null, null);
        }
    }

    MetaDataValue getSelectedMetaDataValue() {
        Object selectedItem = this.comboBoxModel.getSelectedItem();
        return selectedItem instanceof MetaDataValue ? (MetaDataValue)selectedItem : null;
    }

    void enableRemove() {
        this.buttonRemove.setEnabled(true);
    }

    void select(MetaDataValue metaDataValue) {
        this.metaDataValuesComboBox.setSelectedItem(metaDataValue);
    }

    void selectNone() {
        this.metaDataValuesComboBox.setSelectedItem(MetaDataValuesComboBoxModel.NONE);
    }

    private void initComponents() {
        this.metaDataValuesComboBox = new JComboBox();
        this.buttonAdd = new JButton();
        this.buttonRemove = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.metaDataValuesComboBox.setModel(this.comboBoxModel);
        this.metaDataValuesComboBox.setName("metaDataValuesComboBox");
        this.metaDataValuesComboBox.setRenderer(this.listCellRenderer);
        this.metaDataValuesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaDataValueSelectionPanel.this.metaDataValuesComboBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add(this.metaDataValuesComboBox, gridBagConstraints);
        this.buttonAdd.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/plugin/htmlreports/add.png")));
        this.buttonAdd.setMargin(new Insets(0, 0, 0, 0));
        this.buttonAdd.setName("buttonAdd");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaDataValueSelectionPanel.this.buttonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.buttonAdd, gridBagConstraints);
        this.buttonRemove.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/plugin/htmlreports/remove.png")));
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRemove.setName("buttonRemove");
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetaDataValueSelectionPanel.this.buttonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.buttonRemove, gridBagConstraints);
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        this.addMetaDataValueSelectionPanel();
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        this.removeMetaDataValueSelectionPanel();
    }

    private void metaDataValuesComboBoxActionPerformed(ActionEvent evt) {
        this.valueChanged();
    }

    private static class MetaDataValuesComboBoxModel
    extends DefaultComboBoxModel<Object> {
        private static final long serialVersionUID = 1L;
        private static final Collection<? extends MetaDataValueProvider> META_DATA_VALUE_PROVIDERS;
        private static final String NONE;

        private MetaDataValuesComboBoxModel() {
            this.addElements();
        }

        private void addElements() {
            this.addElement(NONE);
            for (MetaDataValueProvider metaDataValueProvider : META_DATA_VALUE_PROVIDERS) {
                Collection providedMetaDataValues = metaDataValueProvider.getProvidedValues();
                for (MetaDataValue providedMetaDataValue : providedMetaDataValues) {
                    this.addElement(providedMetaDataValue);
                }
            }
        }

        static {
            NONE = Bundle.getString(MetaDataValuesComboBoxModel.class, (String)"MetaDataValuesComboBoxModel.NoneElement", (Object[])new Object[0]);
            ArrayList<? extends MetaDataValueProvider> sortedMetaDataValueProviders = new ArrayList<MetaDataValueProvider>(Lookup.getDefault().lookupAll(MetaDataValueProvider.class));
            Collections.sort(sortedMetaDataValueProviders, PositionProviderAscendingComparator.INSTANCE);
            META_DATA_VALUE_PROVIDERS = sortedMetaDataValueProviders;
        }
    }

    private static class MetaDataValuesListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private MetaDataValuesListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof MetaDataValue) {
                MetaDataValue metaDataValue = (MetaDataValue)value;
                label.setIcon(metaDataValue.getCategoryIcon());
                label.setText(metaDataValue.getDescription());
            }
            return label;
        }
    }
}

