/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.htmlreports;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileSystemView;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.help.HelpUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CollectionUtil;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.plugin.htmlreports.HtmlReports;
import org.jphototagger.plugin.htmlreports.MetaDataValueSelectionPanels;
import org.openide.util.Lookup;

public class HtmlReportsSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton buttonChooseDirectory;
    private JButton buttonHelp;
    private JCheckBox checkBoxInputFilename;
    private JCheckBox checkBoxOpenReport;
    private JCheckBox checkBoxShowSettings;
    private JLabel labelDefaultValues;
    private JLabel labelDirectory;
    private JLabel labelDirectoryPrompt;
    private JLabel labelVersion;
    private MetaDataValueSelectionPanels panelColumns;
    private JPanel panelDirectory;
    private JPanel panelVersion;

    public HtmlReportsSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics((Container)this);
        this.setPersistedValues();
    }

    private void setPersistedValues() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            this.checkBoxInputFilename.setSelected(prefs.getBoolean("HtmlReports.InputFilename"));
            this.checkBoxOpenReport.setSelected(prefs.getBoolean("HtmlReports.OpenReportAfterCreation"));
            this.checkBoxShowSettings.setSelected(prefs.getBoolean("HtmlReports.DisplaySettingsDialogBeforeCreation"));
            this.setReportsDirectory();
        }
    }

    private void setReportsDirectory() {
        File dir;
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        String dirPathname = prefs.getString("HtmlReports.Directory");
        if (StringUtil.hasContent((String)dirPathname)) {
            dir = new File(dirPathname);
        } else {
            dir = new File(HtmlReports.getDefaultReportsDirectoryName());
            try {
                FileUtil.ensureDirectoryExists((File)dir);
            }
            catch (IOException ex) {
                Logger.getLogger(HtmlReportsSettingsPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.setReportsDirectory(dir);
    }

    private void setReportsDirectory(File dir) {
        this.labelDirectory.setText(dir.getAbsolutePath());
        if (dir.isDirectory()) {
            this.labelDirectory.setIcon(FileSystemView.getFileSystemView().getSystemIcon(dir));
            this.labelDirectory.setToolTipText(dir.getAbsolutePath());
        } else {
            this.labelDirectory.setIcon(IconUtil.getImageIcon(HtmlReportsSettingsPanel.class, (String)"error.png"));
            this.labelDirectory.setToolTipText(Bundle.getString(HtmlReportsSettingsPanel.class, (String)"HtmlReportsSettingsPanel.Error.DirectoryDoesNotExist", (Object[])new Object[0]));
        }
    }

    private void chooseDirectory() {
        List selectedDirectories;
        File startDir = new File(this.labelDirectory.getText());
        Frame parent = ComponentUtil.findFrameWithIcon();
        DirectoryChooser dirChooser = new DirectoryChooser(parent, startDir, new DirectoryChooser.Option[]{DirectoryChooser.Option.NO_OPTION});
        dirChooser.setVisible(true);
        ComponentUtil.parentWindowToFront((Component)this);
        if (dirChooser.isAccepted() && !(selectedDirectories = dirChooser.getSelectedDirectories()).isEmpty()) {
            File selectedDir = (File)CollectionUtil.getFirstElement((Collection)selectedDirectories);
            this.setReportsDirectory(selectedDir);
            Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
            prefs.setString("HtmlReports.Directory", selectedDir.getAbsolutePath());
        }
    }

    private void setBooleanPreferences(String key, boolean value) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean(key, value);
    }

    private void showHelp() {
        HelpUtil.showHelp((String)"/org/jphototagger/plugin/htmlreports/help/index.html");
    }

    private void initComponents() {
        this.labelDefaultValues = new JLabel();
        this.panelColumns = new MetaDataValueSelectionPanels();
        this.panelDirectory = new JPanel();
        this.labelDirectoryPrompt = new JLabel();
        this.labelDirectory = new JLabel();
        this.buttonChooseDirectory = new JButton();
        this.checkBoxShowSettings = new JCheckBox();
        this.checkBoxInputFilename = new JCheckBox();
        this.checkBoxOpenReport = new JCheckBox();
        this.panelVersion = new JPanel();
        this.labelVersion = new JLabel();
        this.buttonHelp = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.labelDefaultValues.setLabelFor(this.panelColumns);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/plugin/htmlreports/Bundle");
        this.labelDefaultValues.setText(bundle.getString("HtmlReportsSettingsPanel.labelDefaultValues.text"));
        this.labelDefaultValues.setName("labelDefaultValues");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.labelDefaultValues, gridBagConstraints);
        this.panelColumns.setName("panelColumns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.panelColumns, gridBagConstraints);
        this.panelDirectory.setName("panelDirectory");
        this.panelDirectory.setLayout(new GridBagLayout());
        this.labelDirectoryPrompt.setText(bundle.getString("HtmlReportsSettingsPanel.labelDirectoryPrompt.text"));
        this.labelDirectoryPrompt.setName("labelDirectoryPrompt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelDirectory.add((Component)this.labelDirectoryPrompt, gridBagConstraints);
        this.labelDirectory.setText(" ");
        this.labelDirectory.setBorder(BorderFactory.createEtchedBorder());
        this.labelDirectory.setName("labelDirectory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelDirectory.add((Component)this.labelDirectory, gridBagConstraints);
        this.buttonChooseDirectory.setText(bundle.getString("HtmlReportsSettingsPanel.buttonChooseDirectory.text"));
        this.buttonChooseDirectory.setName("buttonChooseDirectory");
        this.buttonChooseDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlReportsSettingsPanel.this.buttonChooseDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.panelDirectory.add((Component)this.buttonChooseDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.panelDirectory, gridBagConstraints);
        this.checkBoxShowSettings.setText(bundle.getString("HtmlReportsSettingsPanel.checkBoxShowSettings.text"));
        this.checkBoxShowSettings.setName("checkBoxShowSettings");
        this.checkBoxShowSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlReportsSettingsPanel.this.checkBoxShowSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.checkBoxShowSettings, gridBagConstraints);
        this.checkBoxInputFilename.setText(bundle.getString("HtmlReportsSettingsPanel.checkBoxInputFilename.text"));
        this.checkBoxInputFilename.setName("checkBoxInputFilename");
        this.checkBoxInputFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlReportsSettingsPanel.this.checkBoxInputFilenameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.checkBoxInputFilename, gridBagConstraints);
        this.checkBoxOpenReport.setText(bundle.getString("HtmlReportsSettingsPanel.checkBoxOpenReport.text"));
        this.checkBoxOpenReport.setName("checkBoxOpenReport");
        this.checkBoxOpenReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlReportsSettingsPanel.this.checkBoxOpenReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.checkBoxOpenReport, gridBagConstraints);
        this.panelVersion.setName("panelVersion");
        this.panelVersion.setLayout(new GridBagLayout());
        this.labelVersion.setText(bundle.getString("HtmlReportsSettingsPanel.labelVersion.text"));
        this.labelVersion.setName("labelVersion");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelVersion.add((Component)this.labelVersion, gridBagConstraints);
        this.buttonHelp.setText(bundle.getString("HtmlReportsSettingsPanel.buttonHelp.text"));
        this.buttonHelp.setName("buttonHelp");
        this.buttonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlReportsSettingsPanel.this.buttonHelpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelVersion.add((Component)this.buttonHelp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.panelVersion, gridBagConstraints);
    }

    private void buttonChooseDirectoryActionPerformed(ActionEvent evt) {
        this.chooseDirectory();
    }

    private void checkBoxInputFilenameActionPerformed(ActionEvent evt) {
        this.setBooleanPreferences("HtmlReports.InputFilename", this.checkBoxInputFilename.isSelected());
    }

    private void checkBoxOpenReportActionPerformed(ActionEvent evt) {
        this.setBooleanPreferences("HtmlReports.OpenReportAfterCreation", this.checkBoxOpenReport.isSelected());
    }

    private void checkBoxShowSettingsActionPerformed(ActionEvent evt) {
        this.setBooleanPreferences("HtmlReports.DisplaySettingsDialogBeforeCreation", this.checkBoxShowSettings.isSelected());
    }

    private void buttonHelpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }
}

