/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.htmlreports;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.plugin.fileprocessor.FileProcessedEvent;
import org.jphototagger.api.plugin.fileprocessor.FileProcessingFinishedEvent;
import org.jphototagger.api.plugin.fileprocessor.FileProcessingStartedEvent;
import org.jphototagger.api.plugin.fileprocessor.FileProcessorPlugin;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.PreferencesDirectoryProvider;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.MetaDataValueData;
import org.jphototagger.domain.metadata.MetaDataValueProviderSupport;
import org.jphototagger.domain.metadata.file.FilesFilenameMetaDataValue;
import org.jphototagger.domain.metadata.thumbnails.ThumbnailsThumbnailMetaDataValue;
import org.jphototagger.image.util.ImageUtil;
import org.jphototagger.lib.awt.DesktopUtil;
import org.jphototagger.lib.help.HelpContentProvider;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.IoUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.HtmlUtil;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.lib.util.SystemProperties;
import org.jphototagger.plugin.htmlreports.DefaultMetaDataValues;
import org.jphototagger.plugin.htmlreports.HtmlReportsSettingsDialog;
import org.jphototagger.plugin.htmlreports.HtmlReportsSettingsPanel;
import org.openide.util.Lookup;

public final class HtmlReports
implements FileProcessorPlugin,
HelpContentProvider {
    private static final String THUMBNAILS_DIR_NAME = "thumbnails";
    private static final String CSS_FILE_NAME = "report.css";
    private static final String CSS_TEMPLATE_RESOURCE = "/org/jphototagger/plugin/htmlreports/templates/report.css";
    private static final String HTML_FILE_NAME = "report.html";
    private static final String HTML_TEMPLATE_RESOURCE = "/org/jphototagger/plugin/htmlreports/templates/DefaultReport.html";
    private static final String HTML_TEMPLATE_REPLACE_PATTERN_TITLE = "<!--TITLE-->";
    private static final String HTML_TEMPLATE_REPLACE_PATTERN_TABLE = "<!--TABLE-->";
    private static final String LINE_SEPARATOR = SystemProperties.getLineSeparator();
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
    private final NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private String filenameSuggestion = "report.html";
    private MetaDataValueProviderSupport metaDataValueProviderSupport;
    private File reportDirectory;
    private File thumbnailsDirectory;
    private File htmlFile;
    private String title;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFiles(Collection<? extends File> files) {
        boolean success = false;
        try {
            EventBus.publish((Object)new FileProcessingStartedEvent((Object)this));
            this.createMetaDataValueProviderSupport();
            this.ensureDirectoriesExisting();
            this.ensureFilesExisting();
            this.showSettingsDialog();
            this.setTitle();
            this.setHtmlFile();
            this.writeHtmlFile(files);
            this.openReport();
            success = true;
        }
        catch (Throwable t) {
            this.handleErrorProcessingFiles(files, t);
        }
        finally {
            EventBus.publish((Object)new FileProcessingFinishedEvent((Object)this, success));
        }
    }

    private void writeHtmlFile(Collection<? extends File> files) throws IOException {
        String template = IoUtil.getTextResource((String)HTML_TEMPLATE_RESOURCE);
        template = template.replace(HTML_TEMPLATE_REPLACE_PATTERN_TITLE, this.title);
        StringBuilder table = new StringBuilder(this.createTableHeading());
        for (File file : files) {
            table.append(LINE_SEPARATOR);
            table.append(this.createTableRow(file));
            EventBus.publish((Object)new FileProcessedEvent((Object)this, file, false));
        }
        template = template.replace(HTML_TEMPLATE_REPLACE_PATTERN_TABLE, table.toString());
        FileUtil.writeStringAsFile((String)template, (String)"UTF-8", (File)this.htmlFile);
    }

    private String createTableHeading() {
        StringBuilder sb = new StringBuilder("<tr>");
        for (MetaDataValue value : DefaultMetaDataValues.INSTANCE.getValues()) {
            sb.append("<th ").append(this.createHtmlClassAttribute(value)).append(">");
            sb.append(HtmlUtil.escapeHTML((String)value.getDescription()));
            sb.append("</th>");
        }
        sb.append("</tr>");
        return sb.toString();
    }

    private String createTableRow(File file) {
        StringBuilder sb = new StringBuilder("<tr>");
        for (MetaDataValue value : DefaultMetaDataValues.INSTANCE.getValues()) {
            sb.append("<td ").append(this.createHtmlClassAttribute(value)).append(">");
            sb.append(this.createCellValue(value, file));
            sb.append("</td>");
        }
        sb.append("</tr>");
        return sb.toString();
    }

    private String createCellValue(MetaDataValue value, File file) {
        Collection valueDataCollection = this.metaDataValueProviderSupport.lookupMetaDataForFile(file, value);
        StringBuilder sb = new StringBuilder();
        for (MetaDataValueData valueData : valueDataCollection) {
            String formattedData = this.isThumbnail(valueData) ? this.formatThumbnail(file, valueData.getData()) : (this.isFilename(valueData) ? this.formatFilename(file, valueData.getData()) : HtmlUtil.escapeHTML((String)this.format(valueData)));
            sb.append(formattedData);
        }
        return sb.toString();
    }

    private boolean isFilename(MetaDataValueData valueData) {
        MetaDataValue metaDataValue = valueData.getMetaDataValue();
        return metaDataValue == FilesFilenameMetaDataValue.INSTANCE;
    }

    private String formatFilename(File file, Object valueData) {
        if (!(valueData instanceof String)) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder("<a href=\"").append(file.toURI().toURL()).append("\">");
            sb.append((String)valueData);
            sb.append("</a>");
            return sb.toString();
        }
        catch (Throwable t) {
            Logger.getLogger(HtmlReports.class.getName()).log(Level.SEVERE, "Error creating thumbnail file for " + file, t);
            return "";
        }
    }

    private boolean isThumbnail(MetaDataValueData valueData) {
        MetaDataValue metaDataValue = valueData.getMetaDataValue();
        return metaDataValue == ThumbnailsThumbnailMetaDataValue.INSTANCE;
    }

    private String formatThumbnail(File file, Object valueData) {
        if (!(valueData instanceof Image)) {
            return "";
        }
        try {
            String thumbnailFilenameBase = FileUtil.getMd5FilenameOfAbsolutePath((File)file) + ".jpg";
            this.createThumbnail(thumbnailFilenameBase, (Image)valueData);
            StringBuilder sb = new StringBuilder("<a href=\"").append(file.toURI().toURL()).append("\">");
            sb.append("<img src=\"thumbnails/").append(thumbnailFilenameBase).append("\"/>");
            sb.append("</a>");
            return sb.toString();
        }
        catch (Throwable t) {
            Logger.getLogger(HtmlReports.class.getName()).log(Level.SEVERE, "Error creating thumbnail file for " + file, t);
            return "";
        }
    }

    private void createThumbnail(String thumbnailFilenameBase, Image image) throws IOException {
        File tnFile = new File(this.thumbnailsDirectory.getAbsolutePath() + File.separator + thumbnailFilenameBase);
        ImageUtil.writeJpegImage((Image)image, (File)tnFile);
    }

    private String format(MetaDataValueData valueData) {
        Object data = valueData.getData();
        MetaDataValue.ValueType valueType = valueData.getMetaDataValue().getValueType();
        if (data instanceof Collection) {
            Collection collection = (Collection)data;
            StringBuilder sb = new StringBuilder();
            boolean isFirstElement = true;
            for (Object element : collection) {
                sb.append(isFirstElement ? "" : ", ");
                sb.append(this.format(valueType, element));
                isFirstElement = false;
            }
            return sb.toString();
        }
        return this.format(valueType, data);
    }

    private String format(MetaDataValue.ValueType valueType, Object value) {
        if (value == null) {
            return "";
        }
        switch (valueType) {
            case STRING: {
                return (String)value;
            }
            case DATE: {
                return this.dateFormat.format((Date)value);
            }
            case SMALLINT: 
            case BIGINT: 
            case INTEGER: 
            case REAL: {
                return this.numberFormat.format(value);
            }
        }
        return "No formatting rule for " + valueType + " (" + value + ")";
    }

    private String createHtmlClassAttribute(MetaDataValue metaDataValue) {
        return "class=\"" + metaDataValue.getValueName() + "\"";
    }

    private void showSettingsDialog() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        boolean isShow = prefs.getBoolean("HtmlReports.DisplaySettingsDialogBeforeCreation");
        if (isShow) {
            HtmlReportsSettingsDialog settingsDialog = new HtmlReportsSettingsDialog();
            settingsDialog.setVisible(true);
        }
    }

    private void setTitle() {
        String message = Bundle.getString(HtmlReports.class, (String)"HtmlReports.GetTitle.Message", (Object[])new Object[0]);
        String input = Bundle.getString(HtmlReports.class, (String)"HtmlReports.GetTitle.Input", (Object[])new Object[0]);
        this.title = MessageDisplayer.input((String)message, (String)input);
        this.title = HtmlUtil.escapeHTML((String)(StringUtil.hasContent((String)this.title) ? this.title : ""));
    }

    private void setHtmlFile() {
        String message;
        String input;
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        boolean isInput = prefs.getBoolean("HtmlReports.InputFilename");
        String filename = HTML_FILE_NAME;
        if (isInput && StringUtil.hasContent((String)(input = MessageDisplayer.input((String)(message = Bundle.getString(HtmlReports.class, (String)"HtmlReports.GetHtmlFile.Message", (Object[])new Object[0])), (String)this.filenameSuggestion)))) {
            filename = input;
            if (!filename.toLowerCase().endsWith(".html")) {
                filename = filename + ".html";
            }
            this.filenameSuggestion = filename;
        }
        if (filename.contains(File.separator)) {
            throw new IllegalStateException("File name '" + filename + "' contains path separator!");
        }
        this.htmlFile = new File(this.reportDirectory.getAbsolutePath() + File.separator + filename);
        this.htmlFile = FileUtil.getNotExistingFile((File)this.htmlFile);
    }

    private void handleErrorProcessingFiles(Collection<? extends File> files, Throwable t) {
        Logger.getLogger(HtmlReports.class.getName()).log(Level.SEVERE, null, t);
        MessageDisplayer.thrown((String)Bundle.getString(HtmlReports.class, (String)"HtmlReports.ProcessFiles.Error", (Object[])new Object[0]), (Throwable)t);
        boolean retry = MessageDisplayer.confirmYesNo((Component)ComponentUtil.findFrameWithIcon(), (String)Bundle.getString(HtmlReports.class, (String)"HtmlReports.ProcessFiles.Confirm.ChangeSettingsAntRetry", (Object[])new Object[0]));
        if (retry) {
            HtmlReportsSettingsDialog settingsDialog = new HtmlReportsSettingsDialog();
            settingsDialog.setVisible(true);
            this.processFiles(files);
        }
    }

    private void ensureDirectoriesExisting() throws IOException {
        File dir;
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        String dirPath = prefs.getString("HtmlReports.Directory");
        if (!StringUtil.hasContent((String)dirPath)) {
            dirPath = HtmlReports.getDefaultReportsDirectoryName();
            FileUtil.ensureDirectoryExists((File)new File(dirPath));
        }
        if ((dir = new File(dirPath)).exists() && !dir.isDirectory()) {
            throw new IllegalStateException("File '" + dir + "' is a file and not a valid dircetory for HTML Reports!");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Error while creating directory'" + dir + "'for HTML Reports!");
        }
        this.reportDirectory = dir;
        this.thumbnailsDirectory = new File(dirPath + File.separator + THUMBNAILS_DIR_NAME);
        if (this.thumbnailsDirectory.isDirectory()) {
            return;
        }
        if (!this.thumbnailsDirectory.mkdir()) {
            throw new IllegalStateException("Error while creating thumbnails directory'" + dir + "'for HTML Reports!");
        }
    }

    static String getDefaultReportsDirectoryName() {
        PreferencesDirectoryProvider provider = (PreferencesDirectoryProvider)Lookup.getDefault().lookup(PreferencesDirectoryProvider.class);
        String parentDirname = provider.getPluginPreferencesDirectory().getAbsolutePath();
        return parentDirname + File.separator + "Html-Reports";
    }

    private void ensureFilesExisting() throws IOException {
        this.ensureCssFileExists();
    }

    private void ensureCssFileExists() throws IOException {
        File cssFile = new File(this.reportDirectory.getAbsolutePath() + File.separator + CSS_FILE_NAME);
        if (!cssFile.exists()) {
            String css = IoUtil.getTextResource((String)CSS_TEMPLATE_RESOURCE);
            FileUtil.writeStringAsFile((String)css, (File)cssFile);
        }
        if (!cssFile.isFile()) {
            throw new IllegalStateException("CSS file '" + cssFile + "' for HTML reports is not a file!");
        }
    }

    private void openReport() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        boolean isOpen = prefs.getBoolean("HtmlReports.OpenReportAfterCreation");
        if (isOpen) {
            DesktopUtil.browse((String)this.htmlFile.toURI().toString(), (String)"HtmlReports.BrowseReport");
        }
    }

    private void createMetaDataValueProviderSupport() {
        if (this.metaDataValueProviderSupport == null) {
            this.metaDataValueProviderSupport = new MetaDataValueProviderSupport();
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public String getDescription() {
        return Bundle.getString(HtmlReports.class, (String)"HtmlReports.Description", (Object[])new Object[0]);
    }

    public String getDisplayName() {
        return Bundle.getString(HtmlReports.class, (String)"HtmlReports.Name", (Object[])new Object[0]);
    }

    public Icon getSmallIcon() {
        return IconUtil.getImageIcon(HtmlReports.class, (String)"html.png");
    }

    public Icon getLargeIcon() {
        return IconUtil.getImageIcon(HtmlReports.class, (String)"html32.png");
    }

    public Component getSettingsComponent() {
        return new HtmlReportsSettingsPanel();
    }

    public String getHelpContentUrl() {
        return "/org/jphototagger/plugin/htmlreports/help/contents.xml";
    }

    public int getPosition() {
        return 300;
    }
}

