/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb.update.tables.v0.obsolete;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.repository.hsqldb.Database;
import org.jphototagger.repository.hsqldb.DatabaseMetadata;

final class UpdateTablesXmpLastModified {
    private static final Logger LOGGER = Logger.getLogger(UpdateTablesXmpLastModified.class.getName());

    UpdateTablesXmpLastModified() {
    }

    void update(Connection con) throws SQLException {
        this.removeColumnXmpLastModifiedFromTableXmp(con);
        this.addColumnXmpLastModifiedToTableFiles(con);
    }

    private void removeColumnXmpLastModifiedFromTableXmp(Connection con) throws SQLException {
        if (DatabaseMetadata.INSTANCE.existsColumn(con, "xmp", "lastmodified")) {
            Database.execute(con, "ALTER TABLE xmp DROP COLUMN lastmodified");
        }
    }

    private void addColumnXmpLastModifiedToTableFiles(Connection con) throws SQLException {
        if (!DatabaseMetadata.INSTANCE.existsColumn(con, "files", "xmp_lastmodified")) {
            Database.execute(con, "ALTER TABLE files ADD COLUMN xmp_lastmodified BIGINT");
            this.copyLastModifiedToXmp(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLastModifiedToXmp(Connection con) throws SQLException {
        PreparedStatement stmtUpdate = null;
        Statement stmtQuery = null;
        ResultSet rsQuery = null;
        try {
            stmtQuery = con.createStatement();
            stmtUpdate = con.prepareStatement("UPDATE files SET xmp_lastmodified = ? WHERE id = ?");
            long lastModified = -1L;
            long idFiles = -1L;
            String sql = "SELECT id, lastmodified FROM files";
            LOGGER.log(Level.FINEST, sql);
            rsQuery = stmtQuery.executeQuery(sql);
            while (rsQuery.next()) {
                idFiles = rsQuery.getLong(1);
                lastModified = rsQuery.getLong(2);
                stmtUpdate.setLong(1, lastModified);
                stmtUpdate.setLong(2, idFiles);
                LOGGER.log(Level.FINER, stmtUpdate.toString());
                stmtUpdate.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            Database.close(rsQuery, stmtQuery);
            Database.close(stmtUpdate);
            throw throwable;
        }
        Database.close(rsQuery, stmtQuery);
        Database.close(stmtUpdate);
    }
}

