/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb.update.tables.v0.obsolete;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.repository.hsqldb.Database;
import org.jphototagger.repository.hsqldb.DatabaseMetadata;
import org.jphototagger.repository.hsqldb.SavedSearchesDatabase;
import org.openide.util.Lookup;

final class UpdateTablesXmpDcSubjects {
    private static final Logger LOGGER = Logger.getLogger(UpdateTablesXmpDcSubjects.class.getName());
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);

    UpdateTablesXmpDcSubjects() {
    }

    void update(Connection con) throws SQLException {
        LOGGER.log(Level.INFO, "Moving keywords into new table");
        if (DatabaseMetadata.INSTANCE.existsTable(con, "xmp_dc_subjects")) {
            this.populateTableDcSubjects(con);
            this.populateLinkTable(con);
            Database.execute(con, "DROP TABLE xmp_dc_subjects");
            SavedSearchesDatabase.INSTANCE.tagSearchesIfStmtContains("xmp_dc_subjects", "!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTableDcSubjects(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con.setAutoCommit(true);
            stmt = con.createStatement();
            String sql = "SELECT DISTINCT subject FROM xmp_dc_subjects";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            String subject = null;
            while (rs.next()) {
                subject = rs.getString(1);
                if (this.repo.existsDcSubject(subject)) continue;
                this.insertSubject(con, subject);
            }
        }
        catch (Throwable throwable) {
            Database.close(rs, stmt);
            throw throwable;
        }
        Database.close(rs, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSubject(Connection con, String subject) throws SQLException {
        String sql = "INSERT INTO dc_subjects (subject) VALUES (?)";
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql);
            stmt.setString(1, subject);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
        }
        finally {
            Database.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateLinkTable(Connection con) throws SQLException {
        String sql = "SELECT id_xmp, subject FROM xmp_dc_subjects";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                long idXmp = rs.getLong(1);
                String dcSubject = rs.getString(2);
                Long idDcSubject = this.repo.findIdDcSubject(dcSubject);
                if (idDcSubject == null || !this.existsIdXmp(con, idXmp) || this.repo.existsXmpDcSubjectsLink(idXmp, idDcSubject.longValue())) continue;
                this.insertIntoLinkTable(con, idXmp, idDcSubject);
            }
        }
        catch (Throwable throwable) {
            Database.close(rs, stmt);
            throw throwable;
        }
        Database.close(rs, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsIdXmp(Connection con, long id) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean exists = false;
        try {
            stmt = con.prepareStatement("SELECT COUNT(*) FROM xmp WHERE id = ?");
            stmt.setLong(1, id);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                exists = rs.getInt(1) > 0;
            }
        }
        catch (Throwable throwable) {
            Database.close(rs, stmt);
            throw throwable;
        }
        Database.close(rs, stmt);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoLinkTable(Connection con, long idXmp, long idDcSubject) throws SQLException {
        if (!this.repo.existsXmpDcSubjectsLink(idXmp, idDcSubject)) {
            String sql = "INSERT INTO xmp_dc_subject (id_xmp, id_dc_subject) VALUES (?, ?)";
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, idXmp);
                stmt.setLong(2, idDcSubject);
                LOGGER.log(Level.FINER, stmt.toString());
                stmt.executeUpdate();
            }
            finally {
                Database.close(stmt);
            }
        }
    }
}

