/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb.update.tables.v0.obsolete;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.repository.hsqldb.Database;
import org.jphototagger.repository.hsqldb.DatabaseMetadata;
import org.jphototagger.repository.hsqldb.update.tables.v0.obsolete.ColumnInfo;
import org.jphototagger.repository.hsqldb.update.tables.v0.obsolete.ColumnRenameInfo;

final class UpdateTablesRenameColumns {
    private static final Collection<ColumnRenameInfo> COLUMN_RENAME_INFOS = new ArrayList<ColumnRenameInfo>();
    private final Collection<ColumnRenameInfo> columnToRenameInfos = new ArrayList<ColumnRenameInfo>();

    UpdateTablesRenameColumns() {
    }

    void update(Connection con) throws SQLException {
        Logger.getLogger(UpdateTablesRenameColumns.class.getName()).log(Level.INFO, "Renaming Columns");
        this.setColumns(con);
        if (this.columnToRenameInfos.size() > 0) {
            this.renameColumns(con);
        }
    }

    private void setColumns(Connection con) throws SQLException {
        DatabaseMetadata dbMeta = DatabaseMetadata.INSTANCE;
        this.columnToRenameInfos.clear();
        for (ColumnRenameInfo columnRenameInfo : COLUMN_RENAME_INFOS) {
            String oldColumnName;
            ColumnInfo oldColumnInfo = columnRenameInfo.getOldColumnInfo();
            String oldTableName = oldColumnInfo.getTableName();
            if (!dbMeta.existsColumn(con, oldTableName, oldColumnName = oldColumnInfo.getColumnName())) continue;
            this.columnToRenameInfos.add(columnRenameInfo);
        }
    }

    private void renameColumns(Connection con) throws SQLException {
        for (ColumnRenameInfo info : this.columnToRenameInfos) {
            this.renameColumn(con, info);
        }
    }

    private void renameColumn(Connection con, ColumnRenameInfo info) throws SQLException {
        String tableName = info.getOldColumnInfo().getTableName();
        String fromColumnName = info.getOldColumnInfo().getColumnName();
        String toColumnName = info.getNewColumnInfo().getColumnName();
        if (DatabaseMetadata.INSTANCE.existsColumn(con, tableName, fromColumnName) && !DatabaseMetadata.INSTANCE.existsColumn(con, tableName, toColumnName)) {
            String sql = "ALTER TABLE " + tableName + " ALTER COLUMN " + fromColumnName + " RENAME TO " + toColumnName;
            Database.execute(con, sql);
            String fromIndexName = "idx_" + tableName + "_" + fromColumnName;
            String toIndexName = "idx_" + tableName + "_" + toColumnName;
            if (DatabaseMetadata.existsIndex(con, fromIndexName, tableName) && !DatabaseMetadata.existsIndex(con, toIndexName, tableName)) {
                sql = "ALTER INDEX " + fromIndexName + " RENAME TO " + toIndexName;
                Database.execute(con, sql);
            }
        }
    }

    static {
        COLUMN_RENAME_INFOS.add(new ColumnRenameInfo(new ColumnInfo("programs", "parameters", null, null), new ColumnInfo(null, "parameters_before_filename", null, null)));
        COLUMN_RENAME_INFOS.add(new ColumnRenameInfo(new ColumnInfo("xmp", "id_files", null, null), new ColumnInfo(null, "id_file", null, null)));
        COLUMN_RENAME_INFOS.add(new ColumnRenameInfo(new ColumnInfo("exif", "id_files", null, null), new ColumnInfo(null, "id_file", null, null)));
        COLUMN_RENAME_INFOS.add(new ColumnRenameInfo(new ColumnInfo("collections", "id_collectionnnames", null, null), new ColumnInfo(null, "id_collectionnname", null, null)));
        COLUMN_RENAME_INFOS.add(new ColumnRenameInfo(new ColumnInfo("collections", "id_files", null, null), new ColumnInfo(null, "id_file", null, null)));
        COLUMN_RENAME_INFOS.add(new ColumnRenameInfo(new ColumnInfo("saved_searches_panels", "id_saved_searches", null, null), new ColumnInfo(null, "id_saved_search", null, null)));
        COLUMN_RENAME_INFOS.add(new ColumnRenameInfo(new ColumnInfo("saved_searches_keywords", "id_saved_searches", null, null), new ColumnInfo(null, "id_saved_search", null, null)));
        COLUMN_RENAME_INFOS.add(new ColumnRenameInfo(new ColumnInfo("actions_after_db_insertion", "id_programs", null, null), new ColumnInfo(null, "id_program", null, null)));
        COLUMN_RENAME_INFOS.add(new ColumnRenameInfo(new ColumnInfo("saved_searches", "sql_string", null, null), new ColumnInfo(null, "custom_sql", null, null)));
    }
}

