/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb.update.tables.v0.obsolete;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.repository.hsqldb.Database;
import org.jphototagger.repository.hsqldb.DatabaseMetadata;
import org.jphototagger.repository.hsqldb.update.tables.v0.obsolete.IndexInfo;
import org.jphototagger.repository.hsqldb.update.tables.v0.obsolete.IndexOfTable;

final class UpdateTablesIndexes {
    private static final Map<IndexOfTable, IndexInfo[]> INDEX_TO_REPLACE = new HashMap<IndexOfTable, IndexInfo[]>();
    private static final Logger LOGGER = Logger.getLogger(UpdateTablesIndexes.class.getName());

    UpdateTablesIndexes() {
    }

    void update(Connection con) throws SQLException {
        LOGGER.log(Level.INFO, "Updating table indices");
        this.replaceIndices(con);
    }

    private void replaceIndices(Connection con) throws SQLException {
        for (IndexOfTable indexOfTable : INDEX_TO_REPLACE.keySet()) {
            String tableName;
            String indexName = indexOfTable.getIndexName();
            if (!DatabaseMetadata.existsIndex(con, indexName, tableName = indexOfTable.getTableName())) continue;
            this.replaceIndex(con, indexName, INDEX_TO_REPLACE.get(indexOfTable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceIndex(Connection con, String indexName, IndexInfo[] indexInfos) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            String sql = "DROP INDEX " + indexName + " IF EXISTS";
            LOGGER.log(Level.FINER, sql);
            stmt.executeUpdate(sql);
            for (IndexInfo indexInfo : indexInfos) {
                LOGGER.log(Level.FINER, indexInfo.sql());
                stmt.executeUpdate(indexInfo.sql());
            }
        }
        finally {
            Database.close(stmt);
        }
    }

    static {
        INDEX_TO_REPLACE.put(new IndexOfTable("idx_collections_id", "collections"), new IndexInfo[]{new IndexInfo(false, "idx_collections_id_collectionnname", "collections", "id_collectionnname", new String[0]), new IndexInfo(false, "idx_collections_id_file", "collections", "id_file", new String[0])});
    }
}

