/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb.update.tables.v0.obsolete;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.repository.hsqldb.Database;
import org.jphototagger.repository.hsqldb.DatabaseMetadata;
import org.jphototagger.repository.hsqldb.update.tables.v0.obsolete.ColumnInfo;
import org.jphototagger.repository.hsqldb.update.tables.v0.obsolete.IndexOfColumn;

final class UpdateTablesAddColumns {
    private static final List<ColumnInfo> COLUMNS = new ArrayList<ColumnInfo>();
    private static final Logger LOGGER = Logger.getLogger(UpdateTablesAddColumns.class.getName());
    private final List<ColumnInfo> missingColumns = new ArrayList<ColumnInfo>();

    UpdateTablesAddColumns() {
    }

    void update(Connection con) throws SQLException {
        LOGGER.log(Level.INFO, "Inserting columns");
        this.fixBugs(con);
        this.setColumns(con);
        if (this.missingColumns.size() > 0) {
            this.addColumns(con);
        }
        this.addSpecialColumns(con);
    }

    private void setColumns(Connection con) throws SQLException {
        DatabaseMetadata dbMeta = DatabaseMetadata.INSTANCE;
        this.missingColumns.clear();
        for (ColumnInfo info : COLUMNS) {
            if (dbMeta.existsColumn(con, info.getTableName(), info.getColumnName())) continue;
            this.missingColumns.add(info);
        }
    }

    private void addColumns(Connection con) throws SQLException {
        for (ColumnInfo info : this.missingColumns) {
            this.addColumn(con, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumn(Connection con, ColumnInfo info) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            String sql = "ALTER TABLE " + info.getTableName() + " ADD COLUMN " + info.getColumnName() + " " + info.getDataType();
            LOGGER.log(Level.FINER, sql);
            stmt.execute(sql);
            if (info.getIndex() != null) {
                sql = info.getIndex().getSql();
                LOGGER.log(Level.FINER, sql);
                stmt.execute(sql);
            }
        }
        finally {
            Database.close(stmt);
        }
    }

    private void fixBugs(Connection con) throws SQLException {
        this.fixBugsMetaDataTemplates(con);
    }

    private void fixBugsMetaDataTemplates(Connection con) throws SQLException {
        boolean hasInfo;
        String tableName = "metadata_edit_templates";
        String columnName = "rating";
        if (!DatabaseMetadata.INSTANCE.existsColumn(con, "metadata_edit_templates", "rating")) {
            return;
        }
        List<DatabaseMetadata.ColumnInfo> infos = DatabaseMetadata.INSTANCE.getColumnInfo(con, "metadata_edit_templates", "rating");
        boolean bl = hasInfo = infos.size() == 1;
        assert (hasInfo) : infos.size();
        if (hasInfo) {
            boolean isOk;
            DatabaseMetadata.ColumnInfo info = infos.get(0);
            boolean typeOk = info.DATA_TYPE == -2;
            boolean indexOk = info.ORDINAL_POSITION == 21;
            boolean bl2 = isOk = typeOk && indexOk;
            if (!isOk) {
                this.dropColumn(con, "metadata_edit_templates", "rating");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropColumn(Connection con, String tableName, String columnName) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            String sql = "ALTER TABLE " + tableName + " DROP " + columnName;
            LOGGER.log(Level.FINER, sql);
            stmt.executeUpdate(sql);
        }
        finally {
            Database.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSpecialColumns(Connection con) throws SQLException {
        if (!DatabaseMetadata.INSTANCE.existsColumn(con, "favorite_directories", "id")) {
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                String sql = "ALTER TABLE favorite_directories ADD COLUMN id BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1) PRIMARY KEY";
                LOGGER.log(Level.FINER, sql);
                stmt.executeUpdate(sql);
            }
            finally {
                Database.close(stmt);
            }
        }
    }

    static {
        COLUMNS.add(new ColumnInfo("programs", "parameters_after_filename", "BINARY", null));
        COLUMNS.add(new ColumnInfo("programs", "action", "BOOLEAN", new IndexOfColumn("programs", "action", "idx_programs_action", false)));
        COLUMNS.add(new ColumnInfo("programs", "input_before_execute", "BOOLEAN", null));
        COLUMNS.add(new ColumnInfo("programs", "input_before_execute_per_file", "BOOLEAN", null));
        COLUMNS.add(new ColumnInfo("programs", "single_file_processing", "BOOLEAN", null));
        COLUMNS.add(new ColumnInfo("programs", "change_file", "BOOLEAN", null));
        COLUMNS.add(new ColumnInfo("programs", "use_pattern", "BOOLEAN", null));
        COLUMNS.add(new ColumnInfo("programs", "pattern", "BINARY", null));
        COLUMNS.add(new ColumnInfo("hierarchical_subjects", "real", "BOOLEAN", new IndexOfColumn("hierarchical_subjects", "real", "idx_hierarchical_subjects_real", false)));
        COLUMNS.add(new ColumnInfo("xmp", "iptc4xmpcore_datecreated", "VARCHAR_IGNORECASE(32)", new IndexOfColumn("xmp", "iptc4xmpcore_datecreated", "idx_iptc4xmpcore_datecreated", false)));
        COLUMNS.add(new ColumnInfo("metadata_edit_templates", "rating", "BINARY", null));
        COLUMNS.add(new ColumnInfo("metadata_edit_templates", "iptc4xmpcore_datecreated", "BINARY", null));
        COLUMNS.add(new ColumnInfo("exif", "exif_lens", "VARCHAR_IGNORECASE(256)", new IndexOfColumn("exif", "exif_lens", "idx_exif_lens", false)));
        COLUMNS.add(new ColumnInfo("saved_searches", "search_type", "SMALLINT", null));
    }
}

