/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb.update.tables.v0;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.applifecycle.AppUpdater;
import org.jphototagger.api.applifecycle.generics.Functor;
import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.domain.repository.ApplicationPropertiesRepository;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.Version;
import org.jphototagger.repository.hsqldb.Database;
import org.jphototagger.repository.hsqldb.DatabaseMetadata;
import org.jphototagger.repository.hsqldb.update.tables.DatabaseUpdateTask;
import org.openide.util.Lookup;

public final class DatabaseUpdateTask02
extends Database
implements DatabaseUpdateTask,
AppUpdater {
    private static final String KEY_UPDATED = "DatabaseUpdateTask02.Updated";
    private static final Logger LOGGER = Logger.getLogger(DatabaseUpdateTask02.class.getName());

    @Override
    public Version getUpdatesToDatabaseVersion() {
        return new Version(0, 9999, 0);
    }

    @Override
    public boolean canUpdateDatabaseVersion(Version version) {
        return true;
    }

    @Override
    public void preCreateTables() {
    }

    @Override
    public void postCreateTables() {
        try {
            this.update();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() throws SQLException {
        Connection con = null;
        try {
            con = this.getConnection();
            this.dropThumbnailColumn(con);
            this.addSizeInBytesColumn(con);
        }
        finally {
            this.free(con);
        }
    }

    private void dropThumbnailColumn(Connection con) throws SQLException {
        if (!DatabaseMetadata.INSTANCE.existsColumn(con, "files", "thumbnail")) {
            return;
        }
        LOGGER.log(Level.INFO, "Deleting column 'thumbnail' from table 'files'");
        Database.execute(con, "ALTER TABLE files DROP COLUMN thumbnail");
    }

    private void addSizeInBytesColumn(Connection con) throws SQLException {
        if (DatabaseMetadata.INSTANCE.existsColumn(con, "files", "size_in_bytes")) {
            return;
        }
        LOGGER.log(Level.INFO, "Adding column 'size_in_bytes' to table 'files'");
        Database.execute(con, "ALTER TABLE files ADD COLUMN size_in_bytes BIGINT");
    }

    public void updateToVersion(int major, int minor1, int minor2) {
        ApplicationPropertiesRepository repo = (ApplicationPropertiesRepository)Lookup.getDefault().lookup(ApplicationPropertiesRepository.class);
        if (repo.existsKey(KEY_UPDATED)) {
            return;
        }
        Logger.getLogger(DatabaseUpdateTask02.class.getName()).log(Level.INFO, "Updating database for all known images with the file size in bytes");
        new SizeInBytesUpdater().start();
    }

    private class SizeInBytesUpdater
    extends Thread {
        private SizeInBytesUpdater() {
            super("JPhotoTagger: Updating DB with file sizes");
        }

        @Override
        public void run() {
            Updater updater = new Updater();
            updater.init();
            ImageFilesRepository imageFilesRepo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);
            imageFilesRepo.eachImage((Functor)updater);
            updater.exit();
            if (updater.allUpdated()) {
                this.setUpdated();
            }
        }

        private void setUpdated() {
            ApplicationPropertiesRepository repo = (ApplicationPropertiesRepository)Lookup.getDefault().lookup(ApplicationPropertiesRepository.class);
            repo.setBoolean(DatabaseUpdateTask02.KEY_UPDATED, true);
        }

        private ProgressEvent createStartProgressEvent(int fileCount) {
            return new ProgressEvent.Builder().minimum(0).maximum(fileCount).value(0).stringPainted(true).stringToPaint(Bundle.getString(SizeInBytesUpdater.class, (String)"SizeInBytesUpdater.ProgressString", (Object[])new Object[]{fileCount})).build();
        }

        private class Updater
        implements Functor<File>,
        Cancelable {
            private final ProgressHandle progressHandle = ((ProgressHandleFactory)Lookup.getDefault().lookup(ProgressHandleFactory.class)).createProgressHandle((Cancelable)this);
            private volatile boolean cancel;
            private int countUpdated = 0;
            private long fileCount;
            private ProgressEvent progressEvent;
            private Connection con;
            private PreparedStatement stmt;

            private Updater() {
            }

            private void init() {
                ImageFilesRepository imageFilesRepo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);
                this.fileCount = imageFilesRepo.getFileCount();
                this.progressEvent = SizeInBytesUpdater.this.createStartProgressEvent((int)this.fileCount);
                this.progressHandle.progressStarted(this.progressEvent);
                try {
                    this.con = DatabaseUpdateTask02.this.getConnection();
                    String sql = "UPDATE files set size_in_bytes = ? WHERE filename = ?";
                    this.stmt = this.con.prepareStatement(sql);
                }
                catch (Throwable t) {
                    Logger.getLogger(Updater.class.getName()).log(Level.SEVERE, null, t);
                }
            }

            private void exit() {
                this.progressHandle.progressEnded();
                Database.close(this.stmt);
                DatabaseUpdateTask02.this.free(this.con);
            }

            public void execute(File file) {
                if (!this.cancel && this.stmt != null) {
                    try {
                        this.stmt.setLong(1, file.length());
                        this.stmt.setString(2, file.getAbsolutePath());
                        LOGGER.log(Level.FINER, this.stmt.toString());
                        this.stmt.executeUpdate();
                        ++this.countUpdated;
                        this.progressEvent.setValue(this.countUpdated);
                        this.progressHandle.progressPerformed(this.progressEvent);
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.SEVERE, null, t);
                    }
                }
            }

            public void cancel() {
                this.cancel = true;
            }

            private boolean allUpdated() {
                return (long)this.countUpdated == this.fileCount;
            }
        }
    }
}

