/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb.update.tables;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jphototagger.lib.util.Version;
import org.jphototagger.repository.hsqldb.AppDatabase;
import org.jphototagger.repository.hsqldb.update.tables.DatabaseUpdateTask;
import org.jphototagger.repository.hsqldb.update.tables.DatabaseUpdateTaskComparator;
import org.openide.util.Lookup;

public final class DatabaseUpdate {
    private final List<DatabaseUpdateTask> requiredUpdateTasks = new LinkedList<DatabaseUpdateTask>();

    public DatabaseUpdate() {
        this.lookupUpdaters();
        Collections.sort(this.requiredUpdateTasks, new DatabaseUpdateTaskComparator());
    }

    private synchronized void lookupUpdaters() {
        Version databaseVersion = AppDatabase.getPersistedDatabaseVersion();
        Collection allUpdateTasks = Lookup.getDefault().lookupAll(DatabaseUpdateTask.class);
        for (DatabaseUpdateTask updateTask : allUpdateTasks) {
            Version updatesToDatabaseVersion = updateTask.getUpdatesToDatabaseVersion();
            this.esnureCanUpdateDatabaseVersion(updateTask, databaseVersion);
            boolean databaseHasOlderVersionThanTask = databaseVersion.compareTo(updatesToDatabaseVersion) < 0;
            if (!databaseHasOlderVersionThanTask) continue;
            this.requiredUpdateTasks.add(updateTask);
        }
    }

    public synchronized void preCreateTables() throws SQLException {
        for (DatabaseUpdateTask updater : this.requiredUpdateTasks) {
            updater.preCreateTables();
        }
    }

    public synchronized void postCreateTables() throws SQLException {
        for (DatabaseUpdateTask updater : this.requiredUpdateTasks) {
            updater.postCreateTables();
        }
    }

    private void esnureCanUpdateDatabaseVersion(DatabaseUpdateTask updateTask, Version databaseVersion) {
        if (!updateTask.canUpdateDatabaseVersion(databaseVersion)) {
            throw new IllegalStateException("Database update task '" + updateTask.toString() + "' can't update database version " + databaseVersion.toString3());
        }
    }
}

