/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.repository.event.wordsets.WordsetInsertedEvent;
import org.jphototagger.domain.repository.event.wordsets.WordsetRemovedEvent;
import org.jphototagger.domain.repository.event.wordsets.WordsetRenamedEvent;
import org.jphototagger.domain.repository.event.wordsets.WordsetUpdatedEvent;
import org.jphototagger.domain.repository.event.wordsets.WordsetWordAddedEvent;
import org.jphototagger.domain.repository.event.wordsets.WordsetWordRemovedEvent;
import org.jphototagger.domain.repository.event.wordsets.WordsetWordRenamedEvent;
import org.jphototagger.domain.wordsets.Wordset;
import org.jphototagger.repository.hsqldb.Database;

final class WordsetsDatabase
extends Database {
    static final WordsetsDatabase INSTANCE = new WordsetsDatabase();
    private static final Logger LOGGER = Logger.getLogger(WordsetsDatabase.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Wordset> findAll() {
        LinkedList<Wordset> wordsets = new LinkedList<Wordset>();
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            String sql = "SELECT id, name FROM wordsets ORDER BY name ASC";
            stmt = con.prepareStatement(sql);
            LOGGER.log(Level.FINEST, stmt.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                long id = rs.getLong(1);
                String name = rs.getString(2);
                Wordset wordset = new Wordset(name);
                wordset.setId(id);
                List<String> words = this.findWordsOfWordset(con, id);
                wordset.setWords(words);
                wordsets.add(wordset);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                WordsetsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            WordsetsDatabase.close(stmt);
            this.free(con);
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return wordsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Wordset find(String wordsetName) {
        if (wordsetName == null) {
            throw new NullPointerException("wordsetName == null");
        }
        Wordset wordset = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            String sql = "SELECT id FROM wordsets WHERE name = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, wordsetName);
            LOGGER.log(Level.FINEST, stmt.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                long id = rs.getLong(1);
                wordset = new Wordset(wordsetName);
                wordset.setId(id);
                List<String> words = this.findWordsOfWordset(con, id);
                wordset.setWords(words);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                WordsetsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            WordsetsDatabase.close(stmt);
            this.free(con);
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return wordset;
    }

    Wordset findById(long id) {
        Wordset wordset = null;
        try {
            String wordsetName = this.findWordsetNameById(id);
            if (wordsetName != null) {
                wordset = this.find(wordsetName);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        return wordset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String findWordsetNameById(long id) {
        Connection con;
        PreparedStatement stmt;
        String name;
        block4: {
            name = null;
            stmt = null;
            con = null;
            try {
                con = this.getConnection();
                String sql = "SELECT name FROM wordsets WHERE id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, id);
                LOGGER.log(Level.FINEST, stmt.toString());
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                name = rs.getString(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    WordsetsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                WordsetsDatabase.close(stmt);
                this.free(con);
            }
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> findAllWordsetNames() {
        LinkedList<String> wordsetNames = new LinkedList<String>();
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            String sql = "SELECT name FROM wordsets ORDER BY name ASC";
            stmt = con.prepareStatement(sql);
            LOGGER.log(Level.FINEST, stmt.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                wordsetNames.add(name);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                WordsetsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            WordsetsDatabase.close(stmt);
            this.free(con);
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return wordsetNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findWordsOfWordset(Connection con, long wordsetsId) throws SQLException {
        PreparedStatement stmt = null;
        ArrayList<String> words = new ArrayList<String>();
        try {
            String sql = "SELECT word FROM wordsets_words WHERE id_wordsets = ? ORDER BY word_order ASC";
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, wordsetsId);
            LOGGER.log(Level.FINEST, stmt.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String word = rs.getString(1);
                words.add(word);
            }
        }
        catch (Throwable throwable) {
            WordsetsDatabase.close(stmt);
            throw throwable;
        }
        WordsetsDatabase.close(stmt);
        return words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(String wordsetName) {
        PreparedStatement stmt;
        Connection con;
        int countAffectedRows;
        block5: {
            if (wordsetName == null) {
                throw new NullPointerException("wordsetName == null");
            }
            countAffectedRows = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                String sql = "DELETE FROM wordsets WHERE name = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, wordsetName);
                LOGGER.log(Level.FINER, sql);
                con.setAutoCommit(true);
                countAffectedRows = stmt.executeUpdate();
                if (countAffectedRows <= 0) break block5;
                EventBus.publish((Object)new WordsetRemovedEvent((Object)this, wordsetName));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    WordsetsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                WordsetsDatabase.close(stmt);
                this.free(con);
            }
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return countAffectedRows > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addToWords(String wordsetName, String word) {
        if (wordsetName == null) {
            throw new NullPointerException("wordsetName == null");
        }
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        if (this.existsWord(wordsetName, word)) {
            return false;
        }
        int countAffectedRows = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            long wordsetsId = this.findWordsetId(con, wordsetName);
            if (wordsetsId > 0L) {
                String sql = "INSERT INTO wordsets_words (id_wordsets, word, word_order) VALUES (?, ?, ?)";
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, wordsetsId);
                stmt.setString(2, word);
                stmt.setLong(3, this.getWordCount(con, wordsetsId));
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                if (countAffectedRows > 0) {
                    EventBus.publish((Object)new WordsetWordAddedEvent((Object)this, wordsetName, word));
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            WordsetsDatabase.rollback(con);
        }
        finally {
            WordsetsDatabase.close(stmt);
            this.free(con);
        }
        return countAffectedRows > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFromWords(String wordsetName, String word) {
        if (wordsetName == null) {
            throw new NullPointerException("wordsetName == null");
        }
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        int countAffectedRows = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            long wordsetsId = this.findWordsetId(con, wordsetName);
            if (wordsetsId > 0L) {
                String sql = "REMOVE FROM wordsets_words WHERE id_wordsets = ? AND word = ?";
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, wordsetsId);
                stmt.setString(2, word);
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                if (countAffectedRows > 0) {
                    EventBus.publish((Object)new WordsetWordRemovedEvent((Object)this, wordsetName, word));
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            WordsetsDatabase.rollback(con);
        }
        finally {
            WordsetsDatabase.close(stmt);
            this.free(con);
        }
        return countAffectedRows > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean renameWord(String wordsetName, String oldWord, String newWord) {
        if (wordsetName == null) {
            throw new NullPointerException("wordsetName == null");
        }
        if (oldWord == null) {
            throw new NullPointerException("oldWord == null");
        }
        if (newWord == null) {
            throw new NullPointerException("newWord == null");
        }
        if (newWord.equals(oldWord)) {
            return false;
        }
        int countAffectedRows = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            long wordsetsId = this.findWordsetId(con, wordsetName);
            if (wordsetsId > 0L) {
                String sql = "UPDATE wordsets_words SET word = ? WHERE id_wordsets = ? AND word = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, newWord);
                stmt.setLong(2, wordsetsId);
                stmt.setString(3, oldWord);
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                if (countAffectedRows > 0) {
                    EventBus.publish((Object)new WordsetWordRenamedEvent((Object)this, wordsetName, oldWord, newWord));
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            WordsetsDatabase.rollback(con);
        }
        finally {
            WordsetsDatabase.close(stmt);
            this.free(con);
        }
        return countAffectedRows > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean renameWordset(String oldWordsetName, String newWordsetName) {
        PreparedStatement stmt;
        Connection con;
        int countAffectedRows;
        block6: {
            if (oldWordsetName == null) {
                throw new NullPointerException("oldWordsetName == null");
            }
            if (newWordsetName == null) {
                throw new NullPointerException("newWordsetName == null");
            }
            countAffectedRows = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                String sql = "UPDATE wordsets SET name = ? WHERE name = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, oldWordsetName);
                stmt.setString(2, newWordsetName);
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                if (countAffectedRows <= 0) break block6;
                EventBus.publish((Object)new WordsetRenamedEvent((Object)this, oldWordsetName, newWordsetName));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    WordsetsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    WordsetsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                WordsetsDatabase.close(stmt);
                this.free(con);
            }
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return countAffectedRows > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insert(Wordset wordset) {
        PreparedStatement stmt;
        Connection con;
        int countAffectedRows;
        block6: {
            if (wordset == null) {
                throw new NullPointerException("wordset == null");
            }
            String wordsetName = wordset.getName();
            if (this.existsWordset(wordsetName)) {
                return false;
            }
            countAffectedRows = 0;
            con = null;
            stmt = null;
            try {
                long wordsetsId;
                con = this.getConnection();
                con.setAutoCommit(false);
                String sql = "INSERT INTO wordsets (name) VALUES (?)";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, wordsetName);
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                if (countAffectedRows != 1 || (wordsetsId = this.findWordsetId(con, wordsetName)) <= 0L) break block6;
                this.insertWords(con, wordsetsId, wordset.getWords());
                con.commit();
                EventBus.publish((Object)new WordsetInsertedEvent((Object)this, wordset));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    countAffectedRows = 0;
                    WordsetsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    WordsetsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                WordsetsDatabase.close(stmt);
                this.free(con);
            }
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return countAffectedRows == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean update(Wordset wordset) {
        if (wordset == null) {
            throw new NullPointerException("wordset == null");
        }
        long wordsetsId = wordset.getId();
        Wordset oldWordset = this.findById(wordsetsId);
        if (oldWordset == null) {
            return false;
        }
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            this.deleteWordsOfWordset(con, wordsetsId);
            String oldName = oldWordset.getName();
            String newName = wordset.getName();
            if (!newName.equals(oldName)) {
                String sql = "UPDATE wordsets SET name = ? WHERE id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, wordset.getName());
                stmt.setLong(2, wordsetsId);
                stmt.executeUpdate();
                LOGGER.log(Level.FINER, stmt.toString());
            }
            this.insertWords(con, wordsetsId, wordset.getWords());
            con.commit();
            EventBus.publish((Object)new WordsetUpdatedEvent((Object)this, oldWordset, wordset));
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                WordsetsDatabase.rollback(con);
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WordsetsDatabase.close(stmt);
                this.free(con);
            }
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteWordsOfWordset(Connection con, long wordsetsId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String sql = "DELETE FROM wordsets_words WHERE id_wordsets = ?";
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, wordsetsId);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            WordsetsDatabase.close(stmt);
            throw throwable;
        }
        WordsetsDatabase.close(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertWords(Connection con, long wordsetsId, List<String> words) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String sql = "INSERT INTO wordsets_words (id_wordsets, word, word_order) VALUES (?, ?, ?)";
            stmt = con.prepareStatement(sql);
            int wordOrder = 0;
            for (String word : words) {
                stmt.setLong(1, wordsetsId);
                stmt.setString(2, word);
                stmt.setInt(3, wordOrder);
                LOGGER.log(Level.FINER, stmt.toString());
                stmt.executeUpdate();
                ++wordOrder;
            }
        }
        catch (Throwable throwable) {
            WordsetsDatabase.close(stmt);
            throw throwable;
        }
        WordsetsDatabase.close(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findWordsetId(Connection con, String wordsetName) throws SQLException {
        PreparedStatement stmt = null;
        int id = -1;
        try {
            String sql = "SELECT id FROM wordsets WHERE name = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, wordsetName);
            LOGGER.log(Level.FINEST, stmt.toString());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            WordsetsDatabase.close(stmt);
            throw throwable;
        }
        WordsetsDatabase.close(stmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long findWordsetId(String wordsetName) {
        if (wordsetName == null) {
            throw new NullPointerException("wordsetName == null");
        }
        long id = Long.MIN_VALUE;
        Connection con = null;
        try {
            con = this.getConnection();
            id = this.findWordsetId(con, wordsetName);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            this.free(con);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getWordCount(Connection con, long wordsetsId) throws SQLException {
        PreparedStatement stmt = null;
        long count = 0L;
        try {
            String sql = "SELECT COUNT(*) FROM wordsets_words WHERE id_wordsets = ?";
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, wordsetsId);
            LOGGER.log(Level.FINEST, stmt.toString());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                count = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            WordsetsDatabase.close(stmt);
            throw throwable;
        }
        WordsetsDatabase.close(stmt);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsWord(String wordsetName, String word) {
        long count;
        PreparedStatement stmt;
        Connection con;
        block6: {
            if (wordsetName == null) {
                throw new NullPointerException("wordsetName == null");
            }
            if (word == null) {
                throw new NullPointerException("word == null");
            }
            con = null;
            stmt = null;
            count = 0L;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM wordsets ws INNER JOIN wordsets_words wsw ON wsw.id_wordsets = ws.id WHERE ws.name = ? AND wsw.word = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, wordsetName);
                stmt.setString(2, word);
                LOGGER.log(Level.FINEST, stmt.toString());
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                count = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    WordsetsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                WordsetsDatabase.close(stmt);
                this.free(con);
            }
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return count > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsWordset(String wordsetName) {
        long count;
        PreparedStatement stmt;
        Connection con;
        block5: {
            if (wordsetName == null) {
                throw new NullPointerException("wordsetName == null");
            }
            con = null;
            stmt = null;
            count = 0L;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM wordsets WHERE name = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, wordsetName);
                LOGGER.log(Level.FINEST, stmt.toString());
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                count = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    WordsetsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                WordsetsDatabase.close(stmt);
                this.free(con);
            }
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return count > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsWordset(Long id) {
        long count;
        PreparedStatement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            count = 0L;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM wordsets WHERE id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, id);
                LOGGER.log(Level.FINEST, stmt.toString());
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                count = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    WordsetsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                WordsetsDatabase.close(stmt);
                this.free(con);
            }
        }
        WordsetsDatabase.close(stmt);
        this.free(con);
        return count > 0L;
    }

    private WordsetsDatabase() {
    }
}

