/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeDeletedEvent;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeInsertedEvent;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeUpdatedEvent;
import org.jphototagger.repository.hsqldb.Database;

final class UserDefinedFileTypesDatabase
extends Database {
    static final UserDefinedFileTypesDatabase INSTANCE = new UserDefinedFileTypesDatabase();
    private static final Logger LOGGER = Logger.getLogger(UserDefinedFileTypesDatabase.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int insert(UserDefinedFileType fileType) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block5: {
            if (fileType == null) {
                throw new NullPointerException("fileType == null");
            }
            count = 0;
            con = null;
            stmt = null;
            String suffix = fileType.getSuffix();
            String description = fileType.getDescription();
            boolean externalThumbnailCreator = fileType.isExternalThumbnailCreator();
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("INSERT INTO user_defined_file_types (suffix, description, external_thumbnail_creator) VALUES (?, ?, ?)");
                stmt.setString(1, suffix);
                stmt.setString(2, description);
                stmt.setBoolean(3, externalThumbnailCreator);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block5;
                fileType.setId(this.findIdOfSuffix(con, suffix));
                this.notifyFileTypeInserted(fileType);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    UserDefinedFileTypesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    UserDefinedFileTypesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                UserDefinedFileTypesDatabase.close(stmt);
                this.free(con);
            }
        }
        UserDefinedFileTypesDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int update(UserDefinedFileType oldFileType, UserDefinedFileType newFileType) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block5: {
            if (newFileType == null) {
                throw new NullPointerException("fileType == null");
            }
            count = 0;
            con = null;
            stmt = null;
            Long id = newFileType.getId();
            String suffix = newFileType.getSuffix();
            String description = newFileType.getDescription();
            boolean externalThumbnailCreator = newFileType.isExternalThumbnailCreator();
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("UPDATE user_defined_file_types SET suffix = ?, description = ?, external_thumbnail_creator = ?  WHERE id = ?");
                stmt.setString(1, suffix);
                stmt.setString(2, description);
                stmt.setBoolean(3, externalThumbnailCreator);
                stmt.setLong(4, id);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block5;
                this.notifyFileTypeUpdated(oldFileType, newFileType);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    UserDefinedFileTypesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    UserDefinedFileTypesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                UserDefinedFileTypesDatabase.close(stmt);
                this.free(con);
            }
        }
        UserDefinedFileTypesDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int delete(UserDefinedFileType fileType) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block5: {
            if (fileType == null) {
                throw new NullPointerException("fileType == null");
            }
            count = 0;
            String suffix = fileType.getSuffix();
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("DELETE FROM user_defined_file_types WHERE suffix = ?");
                stmt.setString(1, suffix);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block5;
                this.notifyFileTypeDeleted(fileType);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    UserDefinedFileTypesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    UserDefinedFileTypesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                UserDefinedFileTypesDatabase.close(stmt);
                this.free(con);
            }
        }
        UserDefinedFileTypesDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UserDefinedFileType> getAll() {
        ArrayList<UserDefinedFileType> fileTypes = new ArrayList<UserDefinedFileType>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT id, suffix, description, external_thumbnail_creator FROM user_defined_file_types ORDER BY suffix";
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                UserDefinedFileType fileType = new UserDefinedFileType();
                long id = rs.getLong(1);
                String suffix = rs.getString(2);
                String description = rs.getString(3);
                boolean externalThumbnailCreator = rs.getBoolean(4);
                fileType.setId(Long.valueOf(id));
                fileType.setSuffix(suffix);
                fileType.setDescription(description);
                fileType.setExternalThumbnailCreator(externalThumbnailCreator);
                fileTypes.add(fileType);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                fileTypes.clear();
            }
            catch (Throwable throwable) {
                UserDefinedFileTypesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            UserDefinedFileTypesDatabase.close(rs, stmt);
            this.free(con);
        }
        UserDefinedFileTypesDatabase.close(rs, stmt);
        this.free(con);
        return fileTypes;
    }

    static int getMaxLengthSuffix() {
        return 45;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsSuffix(String suffix) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        long count;
        block5: {
            if (suffix == null) {
                throw new NullPointerException("suffix == null");
            }
            count = 0L;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM user_defined_file_types WHERE suffix = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, suffix);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                count = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0L;
                    UserDefinedFileTypesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    UserDefinedFileTypesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                UserDefinedFileTypesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        UserDefinedFileTypesDatabase.close(rs, stmt);
        this.free(con);
        return count > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserDefinedFileType findBySuffix(String suffix) {
        if (suffix == null) {
            throw new NullPointerException("suffix == null");
        }
        UserDefinedFileType fileType = null;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT id, description, external_thumbnail_creator FROM user_defined_file_types WHERE suffix = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, suffix);
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                fileType = new UserDefinedFileType();
                long id = rs.getLong(1);
                String description = rs.getString(2);
                boolean externalThumbnailCreator = rs.getBoolean(3);
                fileType.setId(Long.valueOf(id));
                fileType.setSuffix(suffix);
                fileType.setDescription(description);
                fileType.setExternalThumbnailCreator(externalThumbnailCreator);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                UserDefinedFileTypesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            UserDefinedFileTypesDatabase.close(rs, stmt);
            this.free(con);
        }
        UserDefinedFileTypesDatabase.close(rs, stmt);
        this.free(con);
        return fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long findIdOfSuffix(Connection con, String suffix) {
        Long id;
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            rs = null;
            id = null;
            try {
                stmt = con.prepareStatement("SELECT id FROM user_defined_file_types WHERE suffix = ?");
                stmt.setString(1, suffix);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                id = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    UserDefinedFileTypesDatabase.close(rs, stmt);
                }
            }
        }
        UserDefinedFileTypesDatabase.close(rs, stmt);
        return id;
    }

    private void notifyFileTypeInserted(UserDefinedFileType fileType) {
        EventBus.publish((Object)new UserDefinedFileTypeInsertedEvent((Object)this, fileType));
    }

    private void notifyFileTypeDeleted(UserDefinedFileType fileType) {
        EventBus.publish((Object)new UserDefinedFileTypeDeletedEvent((Object)this, fileType));
    }

    private void notifyFileTypeUpdated(UserDefinedFileType oldFileType, UserDefinedFileType newFileType) {
        EventBus.publish((Object)new UserDefinedFileTypeUpdatedEvent((Object)this, oldFileType, newFileType));
    }

    private UserDefinedFileTypesDatabase() {
    }
}

