/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.filefilter.UserDefinedFileFilter;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterDeletedEvent;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterInsertedEvent;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterUpdatedEvent;
import org.jphototagger.repository.hsqldb.Database;

final class UserDefinedFileFiltersDatabase
extends Database {
    static final UserDefinedFileFiltersDatabase INSTANCE = new UserDefinedFileFiltersDatabase();
    private static final Logger LOGGER = Logger.getLogger(UserDefinedFileFiltersDatabase.class.getName());

    private String getInsertSql() {
        return "INSERT INTO user_defined_file_filters (is_not, type, name, expression) VALUES (?, ?, ?, ?)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertUserDefinedFileFilter(UserDefinedFileFilter filter) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block6: {
            if (filter == null) {
                throw new NullPointerException("filter == null");
            }
            if (this.existsUserDefinedFileFilter(filter.getName())) {
                return this.updateUserDefinedFileFilter(filter);
            }
            this.checkFilter(filter, false);
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement(this.getInsertSql());
                stmt.setBoolean(1, filter.getIsNot());
                stmt.setInt(2, filter.getType().getValue());
                stmt.setString(3, filter.getName());
                stmt.setString(4, filter.getExpression());
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count != 1) break block6;
                filter.setId(this.findId(con, filter.getName()));
                this.notifyInserted(filter);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    UserDefinedFileFiltersDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    UserDefinedFileFiltersDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                UserDefinedFileFiltersDatabase.close(stmt);
                this.free(con);
            }
        }
        UserDefinedFileFiltersDatabase.close(stmt);
        this.free(con);
        return count == 1;
    }

    private void checkFilter(UserDefinedFileFilter filter, boolean requiresId) {
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        if (requiresId && filter.getId() == null) {
            throw new IllegalArgumentException("Id is null: " + filter);
        }
        if (!filter.isValid()) {
            throw new IllegalArgumentException("Invalid filter: " + filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long findId(Connection con, String name) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Long id = null;
        try {
            String sql = "SELECT id FROM user_defined_file_filters WHERE name = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, name);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            UserDefinedFileFiltersDatabase.close(rs, stmt);
            throw throwable;
        }
        UserDefinedFileFiltersDatabase.close(rs, stmt);
        return id;
    }

    private String getUpdateSql() {
        return "UPDATE user_defined_file_filters SET is_not = ?, type = ?, name = ?, expression = ? WHERE id = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateUserDefinedFileFilter(UserDefinedFileFilter filter) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block4: {
            this.checkFilter(filter, true);
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement(this.getUpdateSql());
                stmt.setBoolean(1, filter.getIsNot());
                stmt.setInt(2, filter.getType().getValue());
                stmt.setString(3, filter.getName());
                stmt.setString(4, filter.getExpression());
                stmt.setLong(5, filter.getId());
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count != 1) break block4;
                this.notifyUpdated(filter);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    UserDefinedFileFiltersDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    UserDefinedFileFiltersDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                UserDefinedFileFiltersDatabase.close(stmt);
                this.free(con);
            }
        }
        UserDefinedFileFiltersDatabase.close(stmt);
        this.free(con);
        return count == 1;
    }

    private String getDeleteSql() {
        return "DELETE FROM user_defined_file_filters WHERE id = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteUserDefinedFileFilter(UserDefinedFileFilter filter) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block4: {
            this.checkFilter(filter, true);
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement(this.getDeleteSql());
                stmt.setLong(1, filter.getId());
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count != 1) break block4;
                this.notifyDeleted(filter);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    UserDefinedFileFiltersDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    UserDefinedFileFiltersDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                UserDefinedFileFiltersDatabase.close(stmt);
                this.free(con);
            }
        }
        UserDefinedFileFiltersDatabase.close(stmt);
        this.free(con);
        return count == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsUserDefinedFileFilter(String name) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        int count;
        block5: {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            count = 0;
            con = null;
            stmt = null;
            rs = null;
            try {
                String sql = "SELECT COUNT (*) FROM user_defined_file_filters WHERE name = ?";
                con = this.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setString(1, name);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    UserDefinedFileFiltersDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                UserDefinedFileFiltersDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        UserDefinedFileFiltersDatabase.close(rs, stmt);
        this.free(con);
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<UserDefinedFileFilter> getAllUserDefinedFileFilters() {
        LinkedHashSet<UserDefinedFileFilter> filter = new LinkedHashSet<UserDefinedFileFilter>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT id, is_not, type, name, expression FROM user_defined_file_filters ORDER BY name ASC";
            con = this.getConnection();
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                UserDefinedFileFilter f = new UserDefinedFileFilter();
                f.setId(this.getLong(rs, 1));
                f.setIsNot(Boolean.valueOf(rs.getBoolean(2)));
                f.setType(UserDefinedFileFilter.Type.parseValue((int)this.getInt(rs, 3)));
                f.setName(this.getString(rs, 4));
                f.setExpression(this.getString(rs, 5));
                filter.add(f);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                UserDefinedFileFiltersDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            UserDefinedFileFiltersDatabase.close(rs, stmt);
            this.free(con);
        }
        UserDefinedFileFiltersDatabase.close(rs, stmt);
        this.free(con);
        return filter;
    }

    private void notifyInserted(UserDefinedFileFilter filter) {
        EventBus.publish((Object)new UserDefinedFileFilterInsertedEvent((Object)this, filter));
    }

    private void notifyDeleted(UserDefinedFileFilter filter) {
        EventBus.publish((Object)new UserDefinedFileFilterDeletedEvent((Object)this, filter));
    }

    private void notifyUpdated(UserDefinedFileFilter filter) {
        EventBus.publish((Object)new UserDefinedFileFilterUpdatedEvent((Object)this, filter));
    }

    private UserDefinedFileFiltersDatabase() {
    }
}

