/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.repository.event.synonyms.SynonymInsertedEvent;
import org.jphototagger.domain.repository.event.synonyms.SynonymOfWordDeletedEvent;
import org.jphototagger.domain.repository.event.synonyms.SynonymOfWordRenamedEvent;
import org.jphototagger.domain.repository.event.synonyms.SynonymRenamedEvent;
import org.jphototagger.domain.repository.event.synonyms.WordDeletedEvent;
import org.jphototagger.domain.repository.event.synonyms.WordRenamedEvent;
import org.jphototagger.repository.hsqldb.Database;

final class SynonymsDatabase
extends Database {
    static final SynonymsDatabase INSTANCE = new SynonymsDatabase();
    private static final Logger LOGGER = Logger.getLogger(SynonymsDatabase.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateSynonymOfWord(String word, String oldSynonym, String newSynonym) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block7: {
            if (word == null) {
                throw new NullPointerException("word == null");
            }
            if (oldSynonym == null) {
                throw new NullPointerException("oldSynonym == null");
            }
            if (newSynonym == null) {
                throw new NullPointerException("newSynonym == null");
            }
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("UPDATE synonyms SET synonym = ? WHERE word = ? AND synonym = ?");
                stmt.setString(1, newSynonym);
                stmt.setString(2, word);
                stmt.setString(3, oldSynonym);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block7;
                this.notifySynonymOfWordRenamed(word, oldSynonym, newSynonym);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    SynonymsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    SynonymsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                SynonymsDatabase.close(stmt);
                this.free(con);
            }
        }
        SynonymsDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateWord(String oldWord, String newWord) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block6: {
            if (oldWord == null) {
                throw new NullPointerException("oldWord == null");
            }
            if (newWord == null) {
                throw new NullPointerException("newWord == null");
            }
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("UPDATE synonyms SET word = ? WHERE word = ?");
                stmt.setString(1, newWord);
                stmt.setString(2, oldWord);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block6;
                this.notifyWordRenamed(oldWord, newWord);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    SynonymsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    SynonymsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                SynonymsDatabase.close(stmt);
                this.free(con);
            }
        }
        SynonymsDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateSynonym(String oldSynonym, String newSynonym) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block6: {
            if (oldSynonym == null) {
                throw new NullPointerException("oldSynonym == null");
            }
            if (newSynonym == null) {
                throw new NullPointerException("newSynonym == null");
            }
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("UPDATE synonyms SET synonym = ? WHERE synonym = ?");
                stmt.setString(1, newSynonym);
                stmt.setString(2, oldSynonym);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block6;
                this.notifySynonymRenamed(oldSynonym, newSynonym);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    SynonymsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    SynonymsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                SynonymsDatabase.close(stmt);
                this.free(con);
            }
        }
        SynonymsDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsWord(String word) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        long count;
        block5: {
            if (word == null) {
                throw new NullPointerException("word == null");
            }
            count = 0L;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM synonyms WHERE word = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, word);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                count = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0L;
                    SynonymsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    SynonymsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                SynonymsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        SynonymsDatabase.close(rs, stmt);
        this.free(con);
        return count > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsSynonym(String word, String synonym) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        long count;
        block6: {
            if (word == null) {
                throw new NullPointerException("word == null");
            }
            if (synonym == null) {
                throw new NullPointerException("synonym == null");
            }
            count = 0L;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM synonyms WHERE word = ? AND synonym = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, word);
                stmt.setString(2, synonym);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                count = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0L;
                    SynonymsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    SynonymsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                SynonymsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        SynonymsDatabase.close(rs, stmt);
        this.free(con);
        return count == 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int insertSynonym(String word, String synonym) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block7: {
            if (word == null) {
                throw new NullPointerException("word == null");
            }
            if (synonym == null) {
                throw new NullPointerException("synonym == null");
            }
            if (this.existsSynonym(word, synonym)) {
                return 0;
            }
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("INSERT INTO synonyms (word, synonym) VALUES (?, ?)");
                stmt.setString(1, word);
                stmt.setString(2, synonym);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block7;
                this.notifySynonymInserted(word, synonym);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    SynonymsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    SynonymsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                SynonymsDatabase.close(stmt);
                this.free(con);
            }
        }
        SynonymsDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteSynonym(String word, String synonym) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block6: {
            if (word == null) {
                throw new NullPointerException("word == null");
            }
            if (synonym == null) {
                throw new NullPointerException("synonym == null");
            }
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("DELETE FROM synonyms WHERE word = ? AND synonym = ?");
                stmt.setString(1, word);
                stmt.setString(2, synonym);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block6;
                this.notifySynonymOfWordDeleted(word, synonym);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    SynonymsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    SynonymsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                SynonymsDatabase.close(stmt);
                this.free(con);
            }
        }
        SynonymsDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteWord(String word) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block5: {
            if (word == null) {
                throw new NullPointerException("word == null");
            }
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("DELETE FROM synonyms WHERE word = ?");
                stmt.setString(1, word);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block5;
                this.notifyWordDeleted(word);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    count = 0;
                    SynonymsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    SynonymsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                SynonymsDatabase.close(stmt);
                this.free(con);
            }
        }
        SynonymsDatabase.close(stmt);
        this.free(con);
        return count;
    }

    private String getGetSynonymsOfSql() {
        return "SELECT synonym FROM synonyms WHERE word = ? UNION SELECT word FROM synonyms WHERE synonym = ? ORDER BY 1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getSynonymsOfWord(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        LinkedHashSet<String> synonyms = new LinkedHashSet<String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(this.getGetSynonymsOfSql());
            stmt.setString(1, word);
            stmt.setString(2, word);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                synonyms.add(rs.getString(1));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                SynonymsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            SynonymsDatabase.close(rs, stmt);
            this.free(con);
        }
        SynonymsDatabase.close(rs, stmt);
        this.free(con);
        return synonyms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getAllWords() {
        LinkedHashSet<String> words = new LinkedHashSet<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT DISTINCT word FROM synonyms ORDER BY word";
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                words.add(rs.getString(1));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                words.clear();
            }
            catch (Throwable throwable) {
                SynonymsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            SynonymsDatabase.close(rs, stmt);
            this.free(con);
        }
        SynonymsDatabase.close(rs, stmt);
        this.free(con);
        return words;
    }

    private void notifySynonymOfWordDeleted(String word, String synonym) {
        EventBus.publish((Object)new SynonymOfWordDeletedEvent((Object)this, word, synonym));
    }

    private void notifyWordDeleted(String word) {
        EventBus.publish((Object)new WordDeletedEvent((Object)this, word));
    }

    private void notifySynonymInserted(String word, String synonym) {
        EventBus.publish((Object)new SynonymInsertedEvent((Object)this, word, synonym));
    }

    private void notifySynonymOfWordRenamed(String word, String oldSynonymName, String newSynonymName) {
        EventBus.publish((Object)new SynonymOfWordRenamedEvent((Object)this, word, oldSynonymName, newSynonymName));
    }

    private void notifySynonymRenamed(String oldSynonymName, String newSynonymName) {
        EventBus.publish((Object)new SynonymRenamedEvent((Object)this, oldSynonymName, newSynonymName));
    }

    private void notifyWordRenamed(String fromName, String toName) {
        EventBus.publish((Object)new WordRenamedEvent((Object)this, fromName, toName));
    }

    private SynonymsDatabase() {
    }
}

