/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.metadata.search.ParamStatement;
import org.jphototagger.domain.metadata.search.SavedSearch;
import org.jphototagger.domain.metadata.search.SavedSearchPanel;
import org.jphototagger.domain.repository.event.search.SavedSearchDeletedEvent;
import org.jphototagger.domain.repository.event.search.SavedSearchInsertedEvent;
import org.jphototagger.domain.repository.event.search.SavedSearchRenamedEvent;
import org.jphototagger.domain.repository.event.search.SavedSearchUpdatedEvent;
import org.jphototagger.repository.hsqldb.Database;

public final class SavedSearchesDatabase
extends Database {
    public static final SavedSearchesDatabase INSTANCE = new SavedSearchesDatabase();
    private static final Logger LOGGER = Logger.getLogger(SavedSearchesDatabase.class.getName());

    private SavedSearchesDatabase() {
    }

    private String getInsertSql() {
        return "INSERT INTO saved_searches (name, custom_sql, search_type) VALUES (?, ?, ?)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(SavedSearch savedSearch) {
        if (savedSearch == null) {
            throw new NullPointerException("savedSearch == null");
        }
        boolean inserted = false;
        Connection con = null;
        PreparedStatement stmt = null;
        if (!savedSearch.isValid()) {
            return false;
        }
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            stmt = con.prepareStatement(this.getInsertSql());
            stmt.setString(1, savedSearch.getName());
            String customSql = savedSearch.getCustomSql();
            if (customSql != null) {
                stmt.setBytes(2, customSql.getBytes());
            }
            this.setSearchType(stmt, 3, savedSearch);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
            long id = this.findId(con, savedSearch.getName());
            List panels = savedSearch.getPanels();
            List keywords = savedSearch.getKeywords();
            this.insertSavedSearchPanels(con, id, panels);
            this.insertSavedSearchKeywords(con, id, keywords);
            con.commit();
            inserted = true;
            this.notifyInserted(savedSearch);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                SavedSearchesDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                SavedSearchesDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            SavedSearchesDatabase.close(stmt);
            this.free(con);
        }
        SavedSearchesDatabase.close(stmt);
        this.free(con);
        return inserted;
    }

    private void setSearchType(PreparedStatement stmt, int parameterIndex, SavedSearch search) throws SQLException {
        if (search == null || !search.isValid()) {
            return;
        }
        stmt.setShort(parameterIndex, search.getType().getValue());
    }

    private String getInsertSavedSearchPanelsSql() {
        return "INSERT INTO saved_searches_panels (id_saved_search, panel_index, bracket_left_1, operator_id, bracket_left_2, column_id, comparator_id, value, bracket_right) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSavedSearchPanels(Connection con, long idSavedSearch, List<SavedSearchPanel> panels) throws SQLException {
        if (idSavedSearch > 0L && panels != null) {
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement(this.getInsertSavedSearchPanelsSql());
                stmt.setLong(1, idSavedSearch);
                for (SavedSearchPanel panel : panels) {
                    stmt.setInt(2, panel.getPanelIndex());
                    stmt.setBoolean(3, panel.isBracketLeft1Selected());
                    stmt.setInt(4, panel.getOperatorId());
                    stmt.setBoolean(5, panel.isBracketLeft2Selected());
                    stmt.setInt(6, panel.getColumnId());
                    stmt.setInt(7, panel.getComparatorId());
                    stmt.setString(8, panel.getValue());
                    stmt.setBoolean(9, panel.isBracketRightSelected());
                    LOGGER.log(Level.FINER, stmt.toString());
                    stmt.executeUpdate();
                }
            }
            catch (Throwable throwable) {
                SavedSearchesDatabase.close(stmt);
                throw throwable;
            }
            SavedSearchesDatabase.close(stmt);
        }
    }

    private String getInsertSavedSearchKeywordsSql() {
        return "INSERT INTO saved_searches_keywords (id_saved_search, keyword) VALUES (?, ?)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSavedSearchKeywords(Connection con, long idSavedSearch, List<String> keywords) throws SQLException {
        if (idSavedSearch > 0L && keywords != null) {
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement(this.getInsertSavedSearchKeywordsSql());
                stmt.setLong(1, idSavedSearch);
                for (String keyword : keywords) {
                    stmt.setString(2, keyword);
                    LOGGER.log(Level.FINER, stmt.toString());
                    stmt.executeUpdate();
                }
            }
            catch (Throwable throwable) {
                SavedSearchesDatabase.close(stmt);
                throw throwable;
            }
            SavedSearchesDatabase.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findId(Connection con, String name) throws SQLException {
        long id = -1L;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM saved_searches WHERE name = ?");
            stmt.setString(1, name);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            SavedSearchesDatabase.close(rs, stmt);
            throw throwable;
        }
        SavedSearchesDatabase.close(rs, stmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        ResultSet rs;
        Statement stmt;
        Connection con;
        int count;
        block4: {
            count = -1;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.createStatement();
                String sql = "SELECT COUNT(*) FROM saved_searches";
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    SavedSearchesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                SavedSearchesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        SavedSearchesDatabase.close(rs, stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        Connection con = null;
        try {
            con = this.getConnection();
            long id = this.findId(con, name);
            boolean bl = id > 0L;
            return bl;
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            this.free(con);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String name) {
        PreparedStatement stmt;
        Connection con;
        boolean deleted;
        block5: {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            deleted = false;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("DELETE FROM saved_searches WHERE name = ?");
                stmt.setString(1, name);
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = deleted = count > 0;
                if (!deleted) break block5;
                this.notifyDeleted(name);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    SavedSearchesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    SavedSearchesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                SavedSearchesDatabase.close(stmt);
                this.free(con);
            }
        }
        SavedSearchesDatabase.close(stmt);
        this.free(con);
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRename(String fromName, String toName) {
        PreparedStatement stmt;
        Connection con;
        boolean renamed;
        block6: {
            if (fromName == null) {
                throw new NullPointerException("fromName == null");
            }
            if (toName == null) {
                throw new NullPointerException("toName == null");
            }
            renamed = false;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(true);
                stmt = con.prepareStatement("UPDATE saved_searches SET name = ? WHERE name = ?");
                stmt.setString(1, toName);
                stmt.setString(2, fromName);
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                boolean bl = renamed = count > 0;
                if (!renamed) break block6;
                this.notifyRenamed(fromName, toName);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    SavedSearchesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                SavedSearchesDatabase.close(stmt);
                this.free(con);
            }
        }
        SavedSearchesDatabase.close(stmt);
        this.free(con);
        return renamed;
    }

    public boolean update(SavedSearch savedSearch) {
        if (savedSearch == null) {
            throw new NullPointerException("savedSearch == null");
        }
        if (!savedSearch.isValid()) {
            return false;
        }
        this.delete(savedSearch.getName());
        boolean updated = this.insert(savedSearch);
        if (updated) {
            this.notifyUpdated(savedSearch);
        }
        return updated;
    }

    private String getFindSql() {
        return "SELECT name, custom_sql, search_type FROM saved_searches WHERE name = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SavedSearch find(String name) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        SavedSearch savedSearch;
        block5: {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            savedSearch = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement(this.getFindSql());
                stmt.setString(1, name);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                savedSearch = new SavedSearch();
                savedSearch.setName(rs.getString(1));
                savedSearch.setCustomSql(new String(rs.getBytes(2)));
                this.setSearchType(rs, 3, savedSearch);
                this.setSavedSearchPanels(con, savedSearch);
                this.setSavedSearchKeywords(con, savedSearch);
            }
            catch (Throwable t) {
                try {
                    savedSearch = null;
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    SavedSearchesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                SavedSearchesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        SavedSearchesDatabase.close(rs, stmt);
        this.free(con);
        return savedSearch;
    }

    private void setSearchType(ResultSet rs, int columnIndex, SavedSearch search) throws SQLException {
        short value = rs.getShort(columnIndex);
        SavedSearch.Type type = rs.wasNull() ? SavedSearch.Type.KEYWORDS_AND_PANELS : SavedSearch.Type.fromValue((short)value);
        search.setType(type);
    }

    private String getGetAllSql() {
        return "SELECT name, custom_sql, search_type FROM saved_searches ORDER BY name";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SavedSearch> getAll() {
        ArrayList<SavedSearch> searches = new ArrayList<SavedSearch>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            String sql = this.getGetAllSql();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SavedSearch savedSearch = new SavedSearch();
                savedSearch.setName(rs.getString(1));
                savedSearch.setCustomSql(new String(rs.getBytes(2)));
                this.setSearchType(rs, 3, savedSearch);
                this.setSavedSearchPanels(con, savedSearch);
                this.setSavedSearchKeywords(con, savedSearch);
                searches.add(savedSearch);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                searches.clear();
            }
            catch (Throwable throwable) {
                SavedSearchesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            SavedSearchesDatabase.close(rs, stmt);
            this.free(con);
        }
        SavedSearchesDatabase.close(rs, stmt);
        this.free(con);
        return searches;
    }

    public void tagSearchesIfStmtContains(String what, String tag) {
        if (what == null) {
            throw new NullPointerException("what == null");
        }
        if (tag == null) {
            throw new NullPointerException("tag == null");
        }
        for (SavedSearch search : this.getAll()) {
            String name;
            ParamStatement stmt = search.createParamStatement();
            if (!search.isCustomSql() || !stmt.getSql().contains(what) || (name = search.getName()).startsWith(tag) || name.endsWith(tag)) continue;
            this.delete(name);
            search.setName(tag + name + tag);
            this.update(search);
        }
    }

    private String getSetSavedSearchPanelsSql() {
        return "SELECT saved_searches_panels.panel_index, saved_searches_panels.bracket_left_1, saved_searches_panels.operator_id, saved_searches_panels.bracket_left_2, saved_searches_panels.column_id, saved_searches_panels.comparator_id, saved_searches_panels.value, saved_searches_panels.bracket_right FROM saved_searches_panels INNER JOIN saved_searches ON saved_searches_panels.id_saved_search = saved_searches.id AND saved_searches.name = ? ORDER BY saved_searches_panels.panel_index ASC";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSavedSearchPanels(Connection con, SavedSearch savedSearch) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(this.getSetSavedSearchPanelsSql());
            stmt.setString(1, savedSearch.getName());
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            ArrayList<SavedSearchPanel> panels = new ArrayList<SavedSearchPanel>();
            while (rs.next()) {
                SavedSearchPanel panel = new SavedSearchPanel();
                panel.setPanelIndex(rs.getInt(1));
                panel.setBracketLeft1Selected(rs.getBoolean(2));
                panel.setOperatorId(rs.getInt(3));
                panel.setBracketLeft2Selected(rs.getBoolean(4));
                panel.setColumnId(rs.getInt(5));
                panel.setComparatorId(rs.getInt(6));
                panel.setValue(rs.getString(7));
                panel.setBracketRightSelected(rs.getBoolean(8));
                panels.add(panel);
            }
            savedSearch.setPanels(panels);
        }
        catch (Throwable throwable) {
            SavedSearchesDatabase.close(rs, stmt);
            throw throwable;
        }
        SavedSearchesDatabase.close(rs, stmt);
    }

    private String getSetSavedSearchKeywordsSql() {
        return "SELECT keyword FROM saved_searches_keywords INNER JOIN saved_searches ON saved_searches_keywords.id_saved_search = saved_searches.id AND saved_searches.name = ? ORDER BY keyword ASC";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSavedSearchKeywords(Connection con, SavedSearch savedSearch) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(this.getSetSavedSearchKeywordsSql());
            stmt.setString(1, savedSearch.getName());
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            ArrayList<String> keywords = new ArrayList<String>();
            while (rs.next()) {
                keywords.add(rs.getString(1));
            }
            savedSearch.setKeywords(keywords);
        }
        catch (Throwable throwable) {
            SavedSearchesDatabase.close(rs, stmt);
            throw throwable;
        }
        SavedSearchesDatabase.close(rs, stmt);
    }

    private void notifyInserted(SavedSearch savedSerch) {
        EventBus.publish((Object)new SavedSearchInsertedEvent((Object)this, savedSerch));
    }

    private void notifyUpdated(SavedSearch savedSerch) {
        EventBus.publish((Object)new SavedSearchUpdatedEvent((Object)this, savedSerch));
    }

    private void notifyDeleted(String name) {
        EventBus.publish((Object)new SavedSearchDeletedEvent((Object)this, name));
    }

    private void notifyRenamed(String fromName, String toName) {
        EventBus.publish((Object)new SavedSearchRenamedEvent((Object)this, fromName, toName));
    }
}

