/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.repository.event.renametemplates.RenameTemplateDeletedEvent;
import org.jphototagger.domain.repository.event.renametemplates.RenameTemplateInsertedEvent;
import org.jphototagger.domain.repository.event.renametemplates.RenameTemplateUpdatedEvent;
import org.jphototagger.domain.templates.RenameTemplate;
import org.jphototagger.repository.hsqldb.Database;

final class RenameTemplatesDatabase
extends Database {
    static final RenameTemplatesDatabase INSTANCE = new RenameTemplatesDatabase();
    private static final Logger LOGGER = Logger.getLogger(RenameTemplatesDatabase.class.getName());

    private RenameTemplatesDatabase() {
    }

    private String getInsertSql() {
        return "INSERT INTO rename_templates (name, start_number, step_width, number_count, date_delimiter, format_class_at_begin, delimiter_1, format_class_in_the_middle, delimiter_2, format_class_at_end, text_at_begin, text_in_the_middle, text_at_end) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    private void setValues(RenameTemplate template, PreparedStatement stmt) throws SQLException {
        this.setString(template.getName(), stmt, 1);
        this.setInt(template.getStartNumber(), stmt, 2);
        this.setInt(template.getStepWidth(), stmt, 3);
        this.setInt(template.getNumberCount(), stmt, 4);
        this.setString(template.getDateDelimiter(), stmt, 5);
        this.setClassname(template.getFormatClassAtBegin(), stmt, 6);
        this.setString(template.getDelimiter1(), stmt, 7);
        this.setClassname(template.getFormatClassInTheMiddle(), stmt, 8);
        this.setString(template.getDelimiter2(), stmt, 9);
        this.setClassname(template.getFormatClassAtEnd(), stmt, 10);
        this.setString(template.getTextAtBegin(), stmt, 11);
        this.setString(template.getTextInTheMiddle(), stmt, 12);
        this.setString(template.getTextAtEnd(), stmt, 13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertRenameTemplate(RenameTemplate template) {
        PreparedStatement stmt;
        Connection con;
        boolean inserted;
        block5: {
            if (template == null) {
                throw new NullPointerException("template == null");
            }
            inserted = false;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement(this.getInsertSql());
                this.setValues(template, stmt);
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = inserted = count == 1;
                if (!inserted) break block5;
                template.setId(Long.valueOf(this.getId(template.getName())));
                this.notifyInserted(template);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    RenameTemplatesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    RenameTemplatesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                RenameTemplatesDatabase.close(stmt);
                this.free(con);
            }
        }
        RenameTemplatesDatabase.close(stmt);
        this.free(con);
        return inserted;
    }

    private String getUpdateSql() {
        return "UPDATE rename_templates SET name = ?, start_number = ?, step_width = ?, number_count = ?, date_delimiter = ?, format_class_at_begin = ?, delimiter_1 = ?, format_class_in_the_middle = ?, delimiter_2 = ?, format_class_at_end = ?, text_at_begin = ?, text_in_the_middle = ?, text_at_end = ? WHERE id = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateRenameTemplate(RenameTemplate template) {
        int count;
        PreparedStatement stmt;
        Connection con;
        block5: {
            if (template == null) {
                throw new NullPointerException("template == null");
            }
            con = null;
            stmt = null;
            count = 0;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement(this.getUpdateSql());
                this.setValues(template, stmt);
                stmt.setLong(14, template.getId());
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count != 1) break block5;
                this.notifyUpdated(template);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    RenameTemplatesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    RenameTemplatesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                RenameTemplatesDatabase.close(stmt);
                this.free(con);
            }
        }
        RenameTemplatesDatabase.close(stmt);
        this.free(con);
        return count == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteRenameTemplate(String name) {
        int count;
        PreparedStatement stmt;
        Connection con;
        block6: {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            con = null;
            stmt = null;
            count = 0;
            try {
                RenameTemplate delTemplate = this.findRenameTemplate(name);
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("DELETE FROM rename_templates WHERE name = ?");
                stmt.setString(1, name);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                con.commit();
                if (count != 1) break block6;
                this.notifyDeleted(delTemplate);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    RenameTemplatesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    RenameTemplatesDatabase.close(stmt);
                    this.free(con);
                }
            }
        }
        RenameTemplatesDatabase.close(stmt);
        this.free(con);
        return count;
    }

    private String getGetAllSql() {
        return "SELECT  id, name, start_number, step_width, number_count, date_delimiter, format_class_at_begin, delimiter_1, format_class_in_the_middle, delimiter_2, format_class_at_end, text_at_begin, text_in_the_middle, text_at_end FROM rename_templates ORDER BY name ASC";
    }

    private RenameTemplate getTemplate(ResultSet rs) throws SQLException {
        RenameTemplate template = new RenameTemplate();
        template.setId(this.getLong(rs, 1));
        template.setName(this.getString(rs, 2));
        template.setStartNumber(this.getInt(rs, 3));
        template.setStepWidth(this.getInt(rs, 4));
        template.setNumberCount(this.getInt(rs, 5));
        template.setDateDelimiter(this.getString(rs, 6));
        template.setFormatClassAtBegin(this.getClassFromName(rs, 7));
        template.setDelimiter1(this.getString(rs, 8));
        template.setFormatClassInTheMiddle(this.getClassFromName(rs, 9));
        template.setDelimiter2(this.getString(rs, 10));
        template.setFormatClassAtEnd(this.getClassFromName(rs, 11));
        template.setTextAtBegin(this.getString(rs, 12));
        template.setTextInTheMiddle(this.getString(rs, 13));
        template.setTextAtEnd(this.getString(rs, 14));
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<RenameTemplate> getAllRenameTemplates() {
        LinkedHashSet<RenameTemplate> templates = new LinkedHashSet<RenameTemplate>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            String sql = this.getGetAllSql();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                templates.add(this.getTemplate(rs));
            }
        }
        catch (Throwable t) {
            try {
                templates.clear();
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                RenameTemplatesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            RenameTemplatesDatabase.close(rs, stmt);
            this.free(con);
        }
        RenameTemplatesDatabase.close(rs, stmt);
        this.free(con);
        return templates;
    }

    private String getGetSql() {
        return "SELECT id, name, start_number, step_width, number_count, date_delimiter, format_class_at_begin, delimiter_1, format_class_in_the_middle, delimiter_2, format_class_at_end, text_at_begin, text_in_the_middle, text_at_end FROM rename_templates WHERE name = ? ORDER BY name ASC";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RenameTemplate findRenameTemplate(String name) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        RenameTemplate template;
        block5: {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            template = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement(this.getGetSql());
                stmt.setString(1, name);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                template = this.getTemplate(rs);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    RenameTemplatesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                RenameTemplatesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        RenameTemplatesDatabase.close(rs, stmt);
        this.free(con);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsRenameTemplate(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        boolean exists = false;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement("SELECT COUNT(*) FROM rename_templates WHERE name = ?");
            stmt.setString(1, name);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            exists = count > 0;
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                RenameTemplatesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            RenameTemplatesDatabase.close(rs, stmt);
            this.free(con);
        }
        RenameTemplatesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getId(String name) throws SQLException {
        long id;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            rs = null;
            id = -1L;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT id FROM rename_templates WHERE name = ?");
                stmt.setString(1, name);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                id = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    RenameTemplatesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                RenameTemplatesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        RenameTemplatesDatabase.close(rs, stmt);
        this.free(con);
        return id;
    }

    private void notifyDeleted(RenameTemplate template) {
        EventBus.publish((Object)new RenameTemplateDeletedEvent((Object)this, template));
    }

    private void notifyInserted(RenameTemplate template) {
        EventBus.publish((Object)new RenameTemplateInsertedEvent((Object)this, template));
    }

    private void notifyUpdated(RenameTemplate template) {
        EventBus.publish((Object)new RenameTemplateUpdatedEvent((Object)this, template));
    }
}

