/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.programs.DefaultProgram;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.programs.ProgramType;
import org.jphototagger.domain.repository.ActionsAfterRepoUpdatesRepository;
import org.jphototagger.domain.repository.event.programs.DefaultProgramDeletedEvent;
import org.jphototagger.domain.repository.event.programs.DefaultProgramInsertedEvent;
import org.jphototagger.domain.repository.event.programs.DefaultProgramUpdatedEvent;
import org.jphototagger.domain.repository.event.programs.ProgramDeletedEvent;
import org.jphototagger.domain.repository.event.programs.ProgramInsertedEvent;
import org.jphototagger.domain.repository.event.programs.ProgramUpdatedEvent;
import org.jphototagger.repository.hsqldb.Database;
import org.openide.util.Lookup;

final class ProgramsDatabase
extends Database {
    static final ProgramsDatabase INSTANCE = new ProgramsDatabase();
    private static final Logger LOGGER = Logger.getLogger(ProgramsDatabase.class.getName());
    private final ActionsAfterRepoUpdatesRepository repo = (ActionsAfterRepoUpdatesRepository)Lookup.getDefault().lookup(ActionsAfterRepoUpdatesRepository.class);

    private ProgramsDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertProgram(Program program) {
        if (program == null) {
            throw new NullPointerException("program == null");
        }
        int countAffectedRows = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            String sql = "INSERT INTO programs (id, action, filename, alias, parameters_before_filename, parameters_after_filename, input_before_execute, input_before_execute_per_file, single_file_processing, change_file, sequence_number, use_pattern, pattern) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            con = this.getConnection();
            con.setAutoCommit(false);
            this.setId(con, program);
            stmt = con.prepareStatement(sql);
            this.ensureSequenceNumber(con, program);
            this.setValuesInsert(stmt, program);
            LOGGER.log(Level.FINER, stmt.toString());
            countAffectedRows = stmt.executeUpdate();
            con.commit();
            this.notifyInserted(program);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                ProgramsDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ProgramsDatabase.close(stmt);
                this.free(con);
            }
        }
        ProgramsDatabase.close(stmt);
        this.free(con);
        return countAffectedRows == 1;
    }

    private void setValuesInsert(PreparedStatement stmt, Program program) throws SQLException {
        stmt.setLong(1, program.getId());
        stmt.setBoolean(2, program.isAction());
        stmt.setString(3, program.getFile().getAbsolutePath());
        stmt.setString(4, program.getAlias());
        String parametersBeforeFilename = program.getParametersBeforeFilename();
        stmt.setBytes(5, parametersBeforeFilename == null ? null : parametersBeforeFilename.getBytes());
        String parametersAfterFilename = program.getParametersAfterFilename();
        stmt.setBytes(6, parametersAfterFilename == null ? null : parametersAfterFilename.getBytes());
        stmt.setBoolean(7, program.isInputBeforeExecute());
        stmt.setBoolean(8, program.isInputBeforeExecutePerFile());
        stmt.setBoolean(9, program.isSingleFileProcessing());
        stmt.setBoolean(10, program.isChangeFile());
        stmt.setInt(11, program.getSequenceNumber());
        stmt.setBoolean(12, program.isUsePattern());
        String pattern = program.getPattern();
        stmt.setBytes(13, pattern == null ? null : pattern.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setId(Connection con, Program program) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            String sql = "SELECT MAX(id) FROM programs";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                program.setId(rs.getLong(1) + 1L);
            }
        }
        catch (Throwable throwable) {
            ProgramsDatabase.close(rs, stmt);
            throw throwable;
        }
        ProgramsDatabase.close(rs, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateProgram(Program program) {
        if (program == null) {
            throw new NullPointerException("program == null");
        }
        int countAffectedRows = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            String sql = "UPDATE programs SET action = ?, filename = ?, alias = ?, parameters_before_filename = ?, parameters_after_filename = ?, input_before_execute = ?, input_before_execute_per_file = ?, single_file_processing = ?, change_file = ?, sequence_number = ?, use_pattern = ?, pattern = ? WHERE id = ?";
            con = this.getConnection();
            con.setAutoCommit(false);
            stmt = con.prepareStatement(sql);
            this.ensureSequenceNumber(con, program);
            this.setValuesUpdate(stmt, program);
            stmt.setLong(13, program.getId());
            LOGGER.log(Level.FINER, stmt.toString());
            countAffectedRows = stmt.executeUpdate();
            con.commit();
            this.notifyUpdated(program);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                ProgramsDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                ProgramsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            ProgramsDatabase.close(stmt);
            this.free(con);
        }
        ProgramsDatabase.close(stmt);
        this.free(con);
        return countAffectedRows == 1;
    }

    private void setValuesUpdate(PreparedStatement stmt, Program program) throws SQLException {
        stmt.setBoolean(1, program.isAction());
        stmt.setString(2, program.getFile().getAbsolutePath());
        stmt.setString(3, program.getAlias());
        String parametersBeforeFilename = program.getParametersBeforeFilename();
        stmt.setBytes(4, parametersBeforeFilename == null ? null : parametersBeforeFilename.getBytes());
        String parametersAfterFilename = program.getParametersAfterFilename();
        stmt.setBytes(5, parametersAfterFilename == null ? null : parametersAfterFilename.getBytes());
        stmt.setBoolean(6, program.isInputBeforeExecute());
        stmt.setBoolean(7, program.isInputBeforeExecutePerFile());
        stmt.setBoolean(8, program.isSingleFileProcessing());
        stmt.setBoolean(9, program.isChangeFile());
        stmt.setInt(10, program.getSequenceNumber());
        stmt.setBoolean(11, program.isUsePattern());
        String pattern = program.getPattern();
        stmt.setBytes(12, pattern == null ? null : pattern.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteProgram(Program program) {
        if (program == null) {
            throw new NullPointerException("program == null");
        }
        int countAffectedRows = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            stmt = con.prepareStatement("DELETE FROM programs WHERE id = ?");
            stmt.setLong(1, program.getId());
            LOGGER.log(Level.FINER, stmt.toString());
            countAffectedRows = stmt.executeUpdate();
            con.commit();
            this.repo.deleteAction(program);
            this.deleteProgramFromDefaultPrograms(con, program.getId());
            this.notifyDeleted(program);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                ProgramsDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                ProgramsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            ProgramsDatabase.close(stmt);
            this.free(con);
        }
        ProgramsDatabase.close(stmt);
        this.free(con);
        return countAffectedRows == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Program> getAllPrograms(ProgramType type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        LinkedList<Program> programs = new LinkedList<Program>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(this.getSelectProgramSql(WhereFilter.ACTION));
            stmt.setBoolean(1, type.equals((Object)ProgramType.ACTION));
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                programs.add(this.createProgramOfCurrentRecord(rs));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ProgramsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ProgramsDatabase.close(rs, stmt);
            this.free(con);
        }
        ProgramsDatabase.close(rs, stmt);
        this.free(con);
        return programs;
    }

    private String getSelectProgramSql(WhereFilter filter) {
        return "SELECT id, action, filename, alias, parameters_before_filename, parameters_after_filename, input_before_execute, input_before_execute_per_file, single_file_processing, change_file, sequence_number, use_pattern, pattern FROM programs" + (filter.equals((Object)WhereFilter.ACTION) ? " WHERE action = ?" : (filter.equals((Object)WhereFilter.ID) ? " WHERE id = ?" : "")) + " ORDER BY sequence_number, alias";
    }

    private Program createProgramOfCurrentRecord(ResultSet rs) throws SQLException {
        byte[] parametersBeforeFilename = rs.getBytes(5);
        byte[] parametersAfterFilename = rs.getBytes(6);
        byte[] pattern = rs.getBytes(13);
        Program program = new Program();
        program.setId(rs.getLong(1));
        program.setAction(rs.getBoolean(2));
        program.setFile(new File(rs.getString(3)));
        program.setAlias(rs.getString(4));
        program.setParametersBeforeFilename(parametersBeforeFilename == null ? null : new String(parametersBeforeFilename));
        program.setParametersAfterFilename(parametersAfterFilename == null ? null : new String(parametersAfterFilename));
        program.setInputBeforeExecute(rs.getBoolean(7));
        program.setInputBeforeExecutePerFile(rs.getBoolean(8));
        program.setSingleFileProcessing(rs.getBoolean(9));
        program.setChangeFile(rs.getBoolean(10));
        program.setSequenceNumber(rs.getInt(11));
        program.setUsePattern(rs.getBoolean(12));
        program.setPattern(pattern == null ? null : new String(pattern));
        return program;
    }

    private String getDefaultImageOpenProgramSql() {
        return "SELECT id, action, filename, alias, parameters_before_filename, parameters_after_filename, input_before_execute, input_before_execute_per_file, single_file_processing, change_file, sequence_number, use_pattern, pattern FROM programs WHERE action = FALSE AND sequence_number = 0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Program getDefaultImageOpenProgram() {
        ResultSet rs;
        Statement stmt;
        Connection con;
        Program program;
        block4: {
            program = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = this.getDefaultImageOpenProgramSql();
                stmt = con.createStatement();
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block4;
                program = this.createProgramOfCurrentRecord(rs);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ProgramsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ProgramsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ProgramsDatabase.close(rs, stmt);
        this.free(con);
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsProgram(Program program) {
        boolean exists;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block5: {
            if (program == null) {
                throw new NullPointerException("program == null");
            }
            con = null;
            stmt = null;
            rs = null;
            exists = false;
            try {
                String sql = "SELECT COUNT(*) FROM programs WHERE alias = ? AND filename = ?";
                con = this.getConnection();
                stmt = con.prepareStatement(sql);
                this.setString(program.getAlias(), stmt, 1);
                this.setString(program.getFile().getAbsolutePath(), stmt, 2);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getLong(1) > 0L;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ProgramsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ProgramsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ProgramsDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Program findProgram(long id) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        Program program;
        block4: {
            program = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement(this.getSelectProgramSql(WhereFilter.ID));
                stmt.setLong(1, id);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                program = this.createProgramOfCurrentRecord(rs);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ProgramsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ProgramsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ProgramsDatabase.close(rs, stmt);
        this.free(con);
        return program;
    }

    boolean hasProgram() {
        return this.has(false);
    }

    boolean hasAction() {
        return this.has(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean has(boolean action) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        int count;
        block5: {
            count = 0;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM programs WHERE action = " + (action ? "TRUE" : "FALSE"));
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ProgramsDatabase.close(rs, stmt);
                    this.free(con);
                }
            }
        }
        ProgramsDatabase.close(rs, stmt);
        this.free(con);
        return count > 0;
    }

    private void notifyDeleted(Program program) {
        EventBus.publish((Object)new ProgramDeletedEvent((Object)this, program));
    }

    private void notifyInserted(Program program) {
        EventBus.publish((Object)new ProgramInsertedEvent((Object)this, program));
    }

    private void notifyUpdated(Program program) {
        EventBus.publish((Object)new ProgramUpdatedEvent((Object)this, program));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getProgramCount(boolean actions) {
        ResultSet rs;
        PreparedStatement stmt;
        int count;
        block4: {
            count = 0;
            stmt = null;
            rs = null;
            try {
                String sql = "SELECT COUNT(*) FROM programs WHERE action = ?";
                Connection con = this.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setBoolean(1, actions);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (SQLException ex) {
                try {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
                catch (Throwable throwable) {
                    ProgramsDatabase.close(rs, stmt);
                    throw throwable;
                }
                ProgramsDatabase.close(rs, stmt);
            }
        }
        ProgramsDatabase.close(rs, stmt);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSequenceNumber(Connection con, Program program) throws SQLException {
        if (program.getSequenceNumber() >= 0) {
            return;
        }
        int count = this.getProgramCount(program.isAction());
        if (count <= 0) {
            program.setSequenceNumber(0);
            return;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT MAX(sequence_number) FROM programs WHERE action = ?";
            stmt = con.prepareStatement(sql);
            stmt.setBoolean(1, program.isAction());
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                int max = rs.getInt(1);
                program.setSequenceNumber(max < 0 ? 0 : max + 1);
            }
        }
        catch (Throwable throwable) {
            ProgramsDatabase.close(rs, stmt);
            throw throwable;
        }
        ProgramsDatabase.close(rs, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DefaultProgram> findAllDefaultPrograms() {
        Connection con = null;
        PreparedStatement stmt = null;
        LinkedList<DefaultProgram> defaultPrograms = new LinkedList<DefaultProgram>();
        try {
            con = this.getConnection();
            String sql = "SELECT d.id_program, d.filename_suffix, p.alias FROM default_programs d INNER JOIN programs p ON d.id_program = p.id";
            stmt = con.prepareStatement(sql);
            LOGGER.log(Level.FINEST, stmt.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                DefaultProgram defaultProgram = new DefaultProgram();
                defaultProgram.setIdProgram(rs.getLong(1));
                defaultProgram.setFilenameSuffix(rs.getString(2));
                defaultProgram.setProgramAlias(rs.getString(3));
                defaultPrograms.add(defaultProgram);
            }
        }
        catch (Throwable t) {
            List<DefaultProgram> list;
            try {
                LOGGER.log(Level.SEVERE, null, t);
                list = Collections.emptyList();
            }
            catch (Throwable throwable) {
                ProgramsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            ProgramsDatabase.close(stmt);
            this.free(con);
            return list;
        }
        ProgramsDatabase.close(stmt);
        this.free(con);
        return defaultPrograms;
    }

    boolean setDefaultProgram(String filenameSuffix, long idProgram) {
        if (filenameSuffix == null) {
            throw new NullPointerException("filenameSuffix == null");
        }
        return this.existsDefaultProgram(filenameSuffix) ? this.updateDefaultProgram(filenameSuffix, idProgram) == 1 : this.insertDefaultProgram(filenameSuffix, idProgram) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertDefaultProgram(String filenameSuffix, long idProgram) {
        int countAffectedRows;
        PreparedStatement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            countAffectedRows = 0;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                String sql = "INSERT INTO default_programs (id_program, filename_suffix) VALUES(?, ?)";
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, idProgram);
                stmt.setString(2, filenameSuffix);
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                if (countAffectedRows != 1) break block4;
                EventBus.publish((Object)new DefaultProgramInsertedEvent((Object)this, filenameSuffix, idProgram));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    ProgramsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    ProgramsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ProgramsDatabase.close(stmt);
                this.free(con);
            }
        }
        ProgramsDatabase.close(stmt);
        this.free(con);
        return countAffectedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateDefaultProgram(String filenameSuffix, long idProgram) {
        int countAffectedRows;
        PreparedStatement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            countAffectedRows = 0;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                String sql = "UPDATE default_programs SET id_program = ? WHERE filename_suffix = ?";
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, idProgram);
                stmt.setString(2, filenameSuffix);
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                if (countAffectedRows != 1) break block4;
                EventBus.publish((Object)new DefaultProgramUpdatedEvent((Object)this, filenameSuffix, idProgram));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    ProgramsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    ProgramsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ProgramsDatabase.close(stmt);
                this.free(con);
            }
        }
        ProgramsDatabase.close(stmt);
        this.free(con);
        return countAffectedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteDefaultProgram(String filenameSuffix) {
        int countAffectedRows;
        PreparedStatement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            countAffectedRows = 0;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                String sql = "DELETE FROM default_programs WHERE filename_suffix = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, filenameSuffix);
                LOGGER.log(Level.FINER, stmt.toString());
                countAffectedRows = stmt.executeUpdate();
                if (countAffectedRows != 1) break block4;
                EventBus.publish((Object)new DefaultProgramDeletedEvent((Object)this, filenameSuffix));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    ProgramsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    ProgramsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ProgramsDatabase.close(stmt);
                this.free(con);
            }
        }
        ProgramsDatabase.close(stmt);
        this.free(con);
        return countAffectedRows == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProgramFromDefaultPrograms(Connection con, long idProgram) throws SQLException {
        PreparedStatement stmt = null;
        try {
            con.setAutoCommit(false);
            String sql = "DELETE FROM default_programs WHERE id_program = ?";
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, idProgram);
            LOGGER.log(Level.FINER, stmt.toString());
            int countAffected = stmt.executeUpdate();
            if (countAffected > 0) {
                LOGGER.log(Level.INFO, "Deleted {0} entries from default programs where program id was {1}", new Object[]{countAffected, idProgram});
            }
        }
        catch (Throwable throwable) {
            ProgramsDatabase.close(stmt);
            this.free(con);
            throw throwable;
        }
        ProgramsDatabase.close(stmt);
        this.free(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Program findDefaultProgram(String filenameSuffix) {
        if (filenameSuffix == null) {
            throw new NullPointerException("filenameSuffix == null");
        }
        Connection con = null;
        try {
            con = this.getConnection();
            long id = this.findDefaultProgramId(con, filenameSuffix);
            if (id > 0L) {
                Program program = this.findProgram(id);
                return program;
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            this.free(con);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findDefaultProgramId(Connection con, String filenameSuffix) throws SQLException {
        long id = Long.MIN_VALUE;
        PreparedStatement stmt = null;
        try {
            String sql = "SELECT id_program FROM default_programs WHERE filename_suffix = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, filenameSuffix);
            LOGGER.log(Level.FINEST, stmt.toString());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            ProgramsDatabase.close(stmt);
            throw throwable;
        }
        ProgramsDatabase.close(stmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsDefaultProgram(String filenameSuffix) {
        Connection con;
        PreparedStatement stmt;
        long count;
        block5: {
            if (filenameSuffix == null) {
                throw new NullPointerException("filenameSuffix == null");
            }
            count = 0L;
            stmt = null;
            con = null;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM default_programs WHERE filename_suffix = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, filenameSuffix);
                LOGGER.log(Level.FINEST, stmt.toString());
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                count = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ProgramsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ProgramsDatabase.close(stmt);
                this.free(con);
            }
        }
        ProgramsDatabase.close(stmt);
        this.free(con);
        return count > 0L;
    }

    private static enum WhereFilter {
        ID,
        ACTION;

    }
}

