/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcCreatorMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcDescriptionMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcRightsMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcTitleMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpIptc4XmpCoreDateCreatedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpIptc4xmpcoreLocationMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopAuthorspositionMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCaptionwriterMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCityMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCountryMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCreditMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopHeadlineMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopInstructionsMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopSourceMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopStateMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopTransmissionReferenceMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpRatingMetaDataValue;
import org.jphototagger.domain.repository.event.metadatatemplates.MetadataTemplateDeletedEvent;
import org.jphototagger.domain.repository.event.metadatatemplates.MetadataTemplateInsertedEvent;
import org.jphototagger.domain.repository.event.metadatatemplates.MetadataTemplateRenamedEvent;
import org.jphototagger.domain.repository.event.metadatatemplates.MetadataTemplateUpdatedEvent;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.repository.hsqldb.Database;

final class MetadataTemplatesDatabase
extends Database {
    static final MetadataTemplatesDatabase INSTANCE = new MetadataTemplatesDatabase();
    private static final String DELIM_REPEATABLE_STRINGS = "\t";
    private static final Logger LOGGER = Logger.getLogger(MetadataTemplatesDatabase.class.getName());

    private MetadataTemplatesDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertOrUpdateMetadataTemplate(MetadataTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        if (this.existsMetadataTemplate(template.getName())) {
            return this.updateMetadataTemplate(template);
        }
        boolean inserted = false;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            String sql = "INSERT INTO metadata_edit_templates (name, dcSubjects, dcTitle, photoshopHeadline, dcDescription, photoshopCaptionwriter, iptc4xmpcoreLocation, dcRights, dcCreator, photoshopAuthorsposition, photoshopCity, photoshopState, photoshopCountry, photoshopTransmissionReference, photoshopInstructions, photoshopCredit, photoshopSource, rating, iptc4xmpcore_datecreated) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            stmt = con.prepareStatement(sql);
            this.set(stmt, template);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
            con.commit();
            inserted = true;
            this.notifyInserted(template);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                MetadataTemplatesDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                MetadataTemplatesDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            MetadataTemplatesDatabase.close(stmt);
            this.free(con);
        }
        MetadataTemplatesDatabase.close(stmt);
        this.free(con);
        return inserted;
    }

    private void set(PreparedStatement stmt, MetadataTemplate template) throws SQLException {
        stmt.setString(1, template.getName());
        stmt.setBytes(2, template.getMetaDataValue((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE) == null ? null : this.fromRepeatable((Collection)template.getMetaDataValue((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(3, template.getMetaDataValue((MetaDataValue)XmpDcTitleMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpDcTitleMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(4, template.getMetaDataValue((MetaDataValue)XmpPhotoshopHeadlineMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopHeadlineMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(5, template.getMetaDataValue((MetaDataValue)XmpDcDescriptionMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpDcDescriptionMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(6, template.getMetaDataValue((MetaDataValue)XmpPhotoshopCaptionwriterMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopCaptionwriterMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(7, template.getMetaDataValue((MetaDataValue)XmpIptc4xmpcoreLocationMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpIptc4xmpcoreLocationMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(8, template.getMetaDataValue((MetaDataValue)XmpDcRightsMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpDcRightsMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(9, template.getMetaDataValue((MetaDataValue)XmpDcCreatorMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpDcCreatorMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(10, template.getMetaDataValue((MetaDataValue)XmpPhotoshopAuthorspositionMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopAuthorspositionMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(11, template.getMetaDataValue((MetaDataValue)XmpPhotoshopCityMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopCityMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(12, template.getMetaDataValue((MetaDataValue)XmpPhotoshopStateMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopStateMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(13, template.getMetaDataValue((MetaDataValue)XmpPhotoshopCountryMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopCountryMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(14, template.getMetaDataValue((MetaDataValue)XmpPhotoshopTransmissionReferenceMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopTransmissionReferenceMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(15, template.getMetaDataValue((MetaDataValue)XmpPhotoshopInstructionsMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopInstructionsMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(16, template.getMetaDataValue((MetaDataValue)XmpPhotoshopCreditMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopCreditMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(17, template.getMetaDataValue((MetaDataValue)XmpPhotoshopSourceMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpPhotoshopSourceMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(18, template.getMetaDataValue((MetaDataValue)XmpRatingMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpRatingMetaDataValue.INSTANCE)).getBytes());
        stmt.setBytes(19, template.getMetaDataValue((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE) == null ? null : ((String)template.getMetaDataValue((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE)).getBytes());
    }

    private String fromRepeatable(Collection<String> strings) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (String string : strings) {
            sb.append(index++ == 0 ? "" : DELIM_REPEATABLE_STRINGS);
            sb.append(string);
        }
        return sb.toString();
    }

    private List<String> toRepeatable(String string) {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, DELIM_REPEATABLE_STRINGS);
        while (tokenizer.hasMoreTokens()) {
            strings.add(tokenizer.nextToken());
        }
        return strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MetadataTemplate findMetadataTemplate(String name) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        MetadataTemplate template;
        block6: {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            template = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = this.getSelectForSetValues() + " WHERE name = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, name);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                template = new MetadataTemplate();
                this.setValues(template, rs);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    MetadataTemplatesDatabase.close(rs, stmt);
                    this.free(con);
                }
            }
        }
        MetadataTemplatesDatabase.close(rs, stmt);
        this.free(con);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MetadataTemplate> getAllMetadataTemplates() {
        ArrayList<MetadataTemplate> templates = new ArrayList<MetadataTemplate>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            String sql = this.getSelectForSetValues() + " WHERE name IS NOT NULL";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                MetadataTemplate template = new MetadataTemplate();
                this.setValues(template, rs);
                templates.add(template);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                MetadataTemplatesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            MetadataTemplatesDatabase.close(rs, stmt);
            this.free(con);
        }
        MetadataTemplatesDatabase.close(rs, stmt);
        this.free(con);
        return templates;
    }

    private String getSelectForSetValues() {
        return "SELECT name, dcSubjects, dcTitle, photoshopHeadline, dcDescription, photoshopCaptionwriter, iptc4xmpcoreLocation, dcRights, dcCreator, photoshopAuthorsposition, photoshopCity, photoshopState, photoshopCountry, photoshopTransmissionReference, photoshopInstructions, photoshopCredit, photoshopSource, rating, iptc4xmpcore_datecreated FROM metadata_edit_templates";
    }

    private void setValues(MetadataTemplate template, ResultSet rs) throws SQLException {
        template.setName(rs.getString(1));
        byte[] bytes = rs.getBytes(2);
        template.setMetaDataValue((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE, rs.wasNull() ? null : this.toRepeatable(new String(bytes)));
        bytes = rs.getBytes(3);
        template.setMetaDataValue((MetaDataValue)XmpDcTitleMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(4);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopHeadlineMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(5);
        template.setMetaDataValue((MetaDataValue)XmpDcDescriptionMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(6);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopCaptionwriterMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(7);
        template.setMetaDataValue((MetaDataValue)XmpIptc4xmpcoreLocationMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(8);
        template.setMetaDataValue((MetaDataValue)XmpDcRightsMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(9);
        template.setMetaDataValue((MetaDataValue)XmpDcCreatorMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(10);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopAuthorspositionMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(11);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopCityMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(12);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopStateMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(13);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopCountryMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(14);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopTransmissionReferenceMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(15);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopInstructionsMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(16);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopCreditMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(17);
        template.setMetaDataValue((MetaDataValue)XmpPhotoshopSourceMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(18);
        template.setMetaDataValue((MetaDataValue)XmpRatingMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
        bytes = rs.getBytes(19);
        template.setMetaDataValue((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE, (Object)(rs.wasNull() ? null : new String(bytes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateMetadataTemplate(MetadataTemplate template) {
        PreparedStatement stmt;
        Connection con;
        boolean updated;
        block6: {
            if (template == null) {
                throw new NullPointerException("template == null");
            }
            updated = false;
            con = null;
            stmt = null;
            try {
                String sql = "UPDATE metadata_edit_templates SET name = ?, dcSubjects = ?, dcTitle = ?, photoshopHeadline = ?, dcDescription = ?, photoshopCaptionwriter = ?, iptc4xmpcoreLocation = ?, dcRights = ?, dcCreator = ?, photoshopAuthorsposition = ?, photoshopCity = ?, photoshopState = ?, photoshopCountry = ?, photoshopTransmissionReference = ?, photoshopInstructions = ?, photoshopCredit = ?, photoshopSource = ?, rating = ?, iptc4xmpcore_datecreated = ? WHERE name = ?";
                con = this.getConnection();
                con.setAutoCommit(false);
                MetadataTemplate oldTemplate = this.findMetadataTemplate(template.getName());
                stmt = con.prepareStatement(sql);
                this.set(stmt, template);
                stmt.setString(20, template.getName());
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = updated = count > 0;
                if (!updated) break block6;
                this.notifyUpdated(oldTemplate, template);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    MetadataTemplatesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    MetadataTemplatesDatabase.close(stmt);
                    this.free(con);
                }
            }
        }
        MetadataTemplatesDatabase.close(stmt);
        this.free(con);
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateRenameMetadataTemplate(String fromName, String toName) {
        PreparedStatement stmt;
        Connection con;
        boolean renamed;
        block5: {
            if (toName == null) {
                throw new NullPointerException("toName == null");
            }
            renamed = false;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("UPDATE metadata_edit_templates SET name = ? WHERE name = ?");
                stmt.setString(1, toName);
                stmt.setString(2, fromName);
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = renamed = count > 0;
                if (!renamed) break block5;
                this.notifyRenamed(fromName, toName);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    MetadataTemplatesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    MetadataTemplatesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                MetadataTemplatesDatabase.close(stmt);
                this.free(con);
            }
        }
        MetadataTemplatesDatabase.close(stmt);
        this.free(con);
        return renamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteMetadataTemplate(String name) {
        PreparedStatement stmt;
        Connection con;
        boolean deleted;
        block6: {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            deleted = false;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                MetadataTemplate template = this.findMetadataTemplate(name);
                stmt = con.prepareStatement("DELETE FROM metadata_edit_templates WHERE name = ?");
                stmt.setString(1, name);
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = deleted = count > 0;
                if (!deleted) break block6;
                this.notifyDelted(template);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    MetadataTemplatesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    MetadataTemplatesDatabase.close(stmt);
                    this.free(con);
                }
            }
        }
        MetadataTemplatesDatabase.close(stmt);
        this.free(con);
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsMetadataTemplate(String name) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM metadata_edit_templates WHERE name = ?");
                stmt.setString(1, name);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    MetadataTemplatesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                MetadataTemplatesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        MetadataTemplatesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    private void notifyDelted(MetadataTemplate template) {
        EventBus.publish((Object)new MetadataTemplateDeletedEvent((Object)this, template));
    }

    private void notifyInserted(MetadataTemplate template) {
        EventBus.publish((Object)new MetadataTemplateInsertedEvent((Object)this, template));
    }

    private void notifyUpdated(MetadataTemplate oldTemplate, MetadataTemplate updatedTemplate) {
        EventBus.publish((Object)new MetadataTemplateUpdatedEvent((Object)this, oldTemplate, updatedTemplate));
    }

    private void notifyRenamed(String fromName, String toName) {
        EventBus.publish((Object)new MetadataTemplateRenamedEvent((Object)this, fromName, toName));
    }
}

