/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.repository.hsqldb.Database;

final class MetaDataValuesDatabase
extends Database {
    static final MetaDataValuesDatabase INSTANCE = new MetaDataValuesDatabase();
    private static final Logger LOGGER = Logger.getLogger(MetaDataValuesDatabase.class.getName());

    private MetaDataValuesDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getDistinctMetaDataValues(MetaDataValue metaDataValue) {
        if (metaDataValue == null) {
            throw new NullPointerException("column == null");
        }
        LinkedHashSet<String> content = new LinkedHashSet<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String columnName = metaDataValue.getValueName();
            stmt = con.createStatement();
            String sql = "SELECT DISTINCT " + columnName + " FROM " + metaDataValue.getCategory() + " WHERE " + columnName + " IS NOT NULL ORDER BY 1 ASC";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                content.add(rs.getString(1));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                content.clear();
            }
            catch (Throwable throwable) {
                MetaDataValuesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            MetaDataValuesDatabase.close(rs, stmt);
            this.free(con);
        }
        MetaDataValuesDatabase.close(rs, stmt);
        this.free(con);
        return content;
    }

    Set<String> getDistinctMetaDataValues(Set<MetaDataValue> metaDataValues) {
        if (metaDataValues == null) {
            throw new NullPointerException("columns == null");
        }
        LinkedHashSet<String> content = new LinkedHashSet<String>();
        for (MetaDataValue column : metaDataValues) {
            content.addAll(this.getDistinctMetaDataValues(column));
        }
        return content;
    }
}

