/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.keywords.Keyword;
import org.jphototagger.domain.metadata.keywords.KeywordType;
import org.jphototagger.repository.hsqldb.Database;

final class KeywordsDatabase
extends Database {
    static final KeywordsDatabase INSTANCE = new KeywordsDatabase();
    private static final Logger LOGGER = Logger.getLogger(KeywordsDatabase.class.getName());

    private KeywordsDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Keyword> getAllKeywords() {
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT id, id_parent, subject, real FROM hierarchical_subjects";
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Long idParent = rs.getLong(2);
                if (rs.wasNull()) {
                    idParent = null;
                }
                keywords.add(new Keyword(Long.valueOf(rs.getLong(1)), idParent, rs.getString(3), Boolean.valueOf(rs.getBoolean(4))));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                keywords.clear();
            }
            catch (Throwable throwable) {
                KeywordsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            KeywordsDatabase.close(rs, stmt);
            this.free(con);
        }
        KeywordsDatabase.close(rs, stmt);
        this.free(con);
        return keywords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateKeyword(Keyword keyword) {
        if (keyword == null) {
            throw new NullPointerException("keyword == null");
        }
        boolean updated = false;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.prepareStatement("UPDATE hierarchical_subjects SET id_parent = ?, subject = ?, real = ? WHERE id = ?");
            if (keyword.getIdParent() == null) {
                stmt.setNull(1, -5);
            } else {
                stmt.setLong(1, keyword.getIdParent());
            }
            stmt.setString(2, keyword.getName());
            if (keyword.isReal() == null) {
                stmt.setNull(3, 16);
            } else {
                stmt.setBoolean(3, keyword.isReal());
            }
            stmt.setLong(4, keyword.getId());
            LOGGER.log(Level.FINER, stmt.toString());
            updated = stmt.executeUpdate() == 1;
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                KeywordsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            KeywordsDatabase.close(stmt);
            this.free(con);
        }
        KeywordsDatabase.close(stmt);
        this.free(con);
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertKeyword(Keyword keyword) {
        PreparedStatement stmt;
        Connection con;
        boolean inserted;
        block13: {
            if (keyword == null) {
                throw new NullPointerException("keyword == null");
            }
            inserted = false;
            assert (keyword.getName() != null) : "Keyword is null!";
            assert (!keyword.getName().trim().isEmpty()) : "Keyword is empty!";
            if (this.hasParentChildKeywordWithEqualName(keyword)) {
                return false;
            }
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(true);
                String sql = "INSERT INTO hierarchical_subjects (id, id_parent, subject, real) VALUES (?, ?, ?, ?)";
                stmt = con.prepareStatement(sql);
                long nextId = this.findNextId(con);
                stmt.setLong(1, nextId);
                if (keyword.getIdParent() == null) {
                    stmt.setNull(2, -5);
                } else {
                    stmt.setLong(2, keyword.getIdParent());
                }
                stmt.setString(3, keyword.getName().trim());
                if (keyword.isReal() == null) {
                    stmt.setNull(4, 16);
                } else {
                    stmt.setBoolean(4, keyword.isReal());
                }
                LOGGER.log(Level.FINER, stmt.toString());
                boolean bl = inserted = stmt.executeUpdate() == 1;
                if (!inserted) break block13;
                keyword.setId(Long.valueOf(nextId));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    KeywordsDatabase.close(stmt);
                    this.free(con);
                }
            }
        }
        KeywordsDatabase.close(stmt);
        this.free(con);
        return inserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteAllKeywords() {
        Connection con = null;
        PreparedStatement stmt = null;
        int countAffected = 0;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            stmt = con.prepareStatement("DELETE FROM hierarchical_subjects");
            LOGGER.log(Level.FINER, stmt.toString());
            countAffected = stmt.executeUpdate();
            con.commit();
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                KeywordsDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                KeywordsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            KeywordsDatabase.close(stmt);
            this.free(con);
        }
        KeywordsDatabase.close(stmt);
        this.free(con);
        return countAffected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteKeywords(Collection<Keyword> keywords) {
        if (keywords == null) {
            throw new NullPointerException("keywords == null");
        }
        boolean deleted = false;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            stmt = con.prepareStatement("DELETE FROM hierarchical_subjects WHERE id = ?");
            for (Keyword keyword : keywords) {
                stmt.setLong(1, keyword.getId());
                LOGGER.log(Level.FINER, stmt.toString());
                stmt.executeUpdate();
            }
            con.commit();
            deleted = true;
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                KeywordsDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                KeywordsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            KeywordsDatabase.close(stmt);
            this.free(con);
        }
        KeywordsDatabase.close(stmt);
        this.free(con);
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Keyword findKeyword(long id, Connection con) throws SQLException {
        Keyword keyword = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT id, id_parent, subject, real FROM hierarchical_subjects WHERE id = ?";
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, id);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                Long idParent = rs.getLong(2);
                if (rs.wasNull()) {
                    idParent = null;
                }
                keyword = new Keyword(Long.valueOf(rs.getLong(1)), idParent, rs.getString(3), Boolean.valueOf(rs.getBoolean(4)));
            }
        }
        catch (Throwable throwable) {
            KeywordsDatabase.close(rs, stmt);
            throw throwable;
        }
        KeywordsDatabase.close(rs, stmt);
        return keyword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Keyword> getParentKeywords(Keyword keyword) {
        if (keyword == null) {
            throw new NullPointerException("keyword == null");
        }
        ArrayList<Keyword> parents = new ArrayList<Keyword>();
        Connection con = null;
        try {
            con = this.getConnection();
            Long idParent = keyword.getIdParent();
            while (idParent != null) {
                Keyword parent = this.findKeyword(idParent, con);
                parents.add(parent);
                idParent = parent.getIdParent();
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            this.free(con);
        }
        return parents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Keyword> getChildKeywords(long idParent) {
        ArrayList<Keyword> children = new ArrayList<Keyword>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT id, id_parent, subject, real FROM hierarchical_subjects WHERE id_parent = ? ORDER BY subject ASC";
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, idParent);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long idPar = rs.getLong(2);
                if (rs.wasNull()) {
                    idPar = null;
                }
                children.add(new Keyword(Long.valueOf(rs.getLong(1)), idPar, rs.getString(3), Boolean.valueOf(rs.getBoolean(4))));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                KeywordsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            KeywordsDatabase.close(rs, stmt);
            this.free(con);
        }
        KeywordsDatabase.close(rs, stmt);
        this.free(con);
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Keyword> getRootKeywords() {
        ArrayList<Keyword> children = new ArrayList<Keyword>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT id, id_parent, subject, real FROM hierarchical_subjects WHERE id_parent IS NULL ORDER BY subject ASC";
            stmt = con.prepareStatement(sql);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long idParent = rs.getLong(2);
                if (rs.wasNull()) {
                    idParent = null;
                }
                children.add(new Keyword(Long.valueOf(rs.getLong(1)), idParent, rs.getString(3), Boolean.valueOf(rs.getBoolean(4))));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                KeywordsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            KeywordsDatabase.close(rs, stmt);
            this.free(con);
        }
        KeywordsDatabase.close(rs, stmt);
        this.free(con);
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long findNextId(Connection con) throws Exception {
        long id = 1L;
        String sql = "SELECT MAX(id) FROM hierarchical_subjects";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                id = rs.getLong(1) + 1L;
            }
        }
        catch (Throwable throwable) {
            KeywordsDatabase.close(rs, stmt);
            throw throwable;
        }
        KeywordsDatabase.close(rs, stmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasParentChildKeywordWithEqualName(Keyword keyword) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block7: {
            boolean parentIsRoot;
            if (keyword == null) {
                throw new NullPointerException("keyword == null");
            }
            exists = false;
            boolean bl = parentIsRoot = keyword.getIdParent() == null;
            if (keyword.getName() == null) {
                return false;
            }
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = parentIsRoot ? "SELECT COUNT(*) FROM hierarchical_subjects WHERE id_parent IS NULL AND subject = ?" : "SELECT COUNT(*) FROM hierarchical_subjects WHERE id_parent = ? AND subject = ?";
                stmt = con.prepareStatement(sql);
                if (!parentIsRoot) {
                    stmt.setLong(1, keyword.getIdParent());
                }
                stmt.setString(parentIsRoot ? 1 : 2, keyword.getName());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block7;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    KeywordsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                KeywordsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        KeywordsDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsRootKeyword(String keyword) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (keyword == null) {
                throw new NullPointerException("keyword == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM hierarchical_subjects WHERE  subject = ? AND id_parent IS NULL";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, keyword);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    KeywordsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                KeywordsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        KeywordsDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsKeyword(String keyword) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (keyword == null) {
                throw new NullPointerException("keyword == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM hierarchical_subjects WHERE subject = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, keyword);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    KeywordsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                KeywordsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        KeywordsDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateRenameAllKeywords(String fromName, String toName) {
        if (fromName == null) {
            throw new NullPointerException("fromName == null");
        }
        if (toName == null) {
            throw new NullPointerException("toName == null");
        }
        int count = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            String sql = "UPDATE hierarchical_subjects SET subject = ? WHERE subject = ? AND real = TRUE";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, toName);
            stmt.setString(2, fromName);
            LOGGER.log(Level.FINEST, stmt.toString());
            count = stmt.executeUpdate();
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                KeywordsDatabase.close(stmt);
                this.free(con);
            }
        }
        KeywordsDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Collection<Keyword>> getParentKeywords(String keywordName, KeywordType select) {
        if (keywordName == null) {
            throw new NullPointerException("keywordName == null");
        }
        if (select == null) {
            throw new NullPointerException("select == null");
        }
        ArrayList<Collection<Keyword>> paths = new ArrayList<Collection<Keyword>>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT id_parent FROM hierarchical_subjects WHERE subject = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, keywordName);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                long idParent = rs.getLong(1);
                if (rs.wasNull()) continue;
                ArrayList<Keyword> path = new ArrayList<Keyword>();
                this.addPathToRoot(path, idParent, select, con);
                Collections.reverse(path);
                paths.add(path);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                KeywordsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            KeywordsDatabase.close(rs, stmt);
            this.free(con);
        }
        KeywordsDatabase.close(rs, stmt);
        this.free(con);
        return paths;
    }

    private void addPathToRoot(Collection<Keyword> path, long idParent, KeywordType select, Connection con) throws SQLException {
        Keyword keyword = this.findKeyword(idParent, con);
        if (keyword != null) {
            Long idNextParent;
            Boolean real = keyword.isReal() != false || keyword.isReal() == null;
            if (select.equals((Object)KeywordType.REAL_OR_HELPER_KEYWORD) || select.equals((Object)KeywordType.REAL_KEYWORD) && real.booleanValue()) {
                path.add(keyword);
            }
            if ((idNextParent = keyword.getIdParent()) != null) {
                this.addPathToRoot(path, idNextParent, select, con);
            }
        }
    }
}

