/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.awt.Image;
import java.io.File;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jphototagger.api.applifecycle.generics.Functor;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.image.ImageFile;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.xmp.FileXmp;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.timeline.Timeline;
import org.jphototagger.repository.hsqldb.ImageFilesDatabase;

public final class ImageFilesRepositoryImpl
implements ImageFilesRepository {
    public long getFileCount() {
        return ImageFilesDatabase.INSTANCE.getFileCount();
    }

    public List<File> findAllImageFiles() {
        return ImageFilesDatabase.INSTANCE.getAllImageFiles();
    }

    public void eachImage(Functor<File> functor) {
        ImageFilesDatabase.INSTANCE.eachImage(functor);
    }

    public long findImageFilesLastModifiedTimestamp(File imageFile) {
        return ImageFilesDatabase.INSTANCE.getImageFilesLastModifiedTimestamp(imageFile);
    }

    public long findImageFilesSizeInBytes(File file) {
        return ImageFilesDatabase.INSTANCE.getImageFilesSizeInBytes(file);
    }

    public long findXmpFilesLastModifiedTimestamp(File imageFile) {
        return ImageFilesDatabase.INSTANCE.getXmpFilesLastModifiedTimestamp(imageFile);
    }

    public int deleteImageFiles(List<File> imageFiles) {
        return ImageFilesDatabase.INSTANCE.deleteImageFiles(imageFiles);
    }

    public void deleteDcSubject(String dcSubject) {
        ImageFilesDatabase.INSTANCE.deleteDcSubject(dcSubject);
    }

    public int deleteAbsentImageFiles(ProgressListener listener) {
        return ImageFilesDatabase.INSTANCE.deleteAbsentImageFiles(listener);
    }

    public int deleteAbsentXmp(ProgressListener listener) {
        return ImageFilesDatabase.INSTANCE.deleteAbsentXmp(listener);
    }

    public void deleteValueOfJoinedMetaDataValue(MetaDataValue mdValue, String value) {
        ImageFilesDatabase.INSTANCE.deleteValueOfJoinedColumn(mdValue, value);
    }

    public boolean existsImageFile(File imageFile) {
        return ImageFilesDatabase.INSTANCE.existsImageFile(imageFile);
    }

    public boolean existsDcSubject(String dcSubject) {
        return ImageFilesDatabase.INSTANCE.existsDcSubject(dcSubject);
    }

    public boolean existsExifDate(Date date) {
        return ImageFilesDatabase.INSTANCE.existsExifDate(date);
    }

    public boolean existsMetaDataValue(Object value, MetaDataValue mdValue) {
        return ImageFilesDatabase.INSTANCE.existsValueInColumn(value, mdValue);
    }

    public boolean existsXMPDateCreated(String date) {
        return ImageFilesDatabase.INSTANCE.existsXMPDateCreated(date);
    }

    public Set<String> findAllDcSubjects() {
        return ImageFilesDatabase.INSTANCE.getAllDcSubjects();
    }

    public Set<String> findAllDistinctMetaDataValues(MetaDataValue mdValue) {
        return ImageFilesDatabase.INSTANCE.getAllDistinctValuesOfColumn(mdValue);
    }

    public List<String> findDcSubjectsOfImageFile(File imageFile) {
        return ImageFilesDatabase.INSTANCE.getDcSubjectsOfImageFile(imageFile);
    }

    public Exif findExifOfImageFile(File imageFile) {
        return ImageFilesDatabase.INSTANCE.getExifOfImageFile(imageFile);
    }

    public ImageFile findImageFileOfFile(File file) {
        return ImageFilesDatabase.INSTANCE.getImageFileOfFile(file);
    }

    public Set<File> findImageFilesContainingAllDcSubjects(List<? extends String> dcSubjects) {
        return ImageFilesDatabase.INSTANCE.getImageFilesContainingAllDcSubjects(dcSubjects);
    }

    public Set<File> findImageFilesContainingDcSubject(String dcSubject, boolean includeSynonyms) {
        return ImageFilesDatabase.INSTANCE.getImageFilesContainingDcSubject(dcSubject, includeSynonyms);
    }

    public Set<File> findImageFilesContainingSomeOfDcSubjects(List<? extends String> dcSubjects) {
        return ImageFilesDatabase.INSTANCE.getImageFilesContainingSomeOfDcSubjects(dcSubjects);
    }

    public Set<File> findImageFilesContainingAllWordsInMetaDataValue(List<? extends String> words, MetaDataValue mdValue) {
        return ImageFilesDatabase.INSTANCE.getImageFilesContainingAllWordsInColumn(words, mdValue);
    }

    public List<File> findImageFilesContainingAVauleInMetaDataValue(MetaDataValue mdValue) {
        return ImageFilesDatabase.INSTANCE.getImageFilesContainingAVauleInColumn(mdValue);
    }

    public Set<File> findImageFilesOfDateTaken(int year, int month, int day) {
        return ImageFilesDatabase.INSTANCE.getImageFilesOfDateTaken(year, month, day);
    }

    public List<File> findImageFilesOfUnknownDateTaken() {
        return ImageFilesDatabase.INSTANCE.getImageFilesOfUnknownDateTaken();
    }

    public List<File> findImageFilesWhereMetaDataValueHasExactValue(MetaDataValue mdValue, String exactValue) {
        return ImageFilesDatabase.INSTANCE.getImageFilesWhereColumnHasExactValue(mdValue, exactValue);
    }

    public List<File> findImageFilesWithoutDataValue(MetaDataValue mdValue) {
        return ImageFilesDatabase.INSTANCE.getImageFilesWithoutMetadataInColumn(mdValue);
    }

    public Set<String> findNotReferencedDcSubjects() {
        return ImageFilesDatabase.INSTANCE.getNotReferencedDcSubjects();
    }

    public Timeline findTimeline() {
        return ImageFilesDatabase.INSTANCE.getTimeline();
    }

    public Xmp findXmpOfImageFile(File imageFile) {
        return ImageFilesDatabase.INSTANCE.getXmpOfImageFile(imageFile);
    }

    public List<FileXmp> findXmpOfImageFiles(Collection<? extends File> imageFiles) {
        return ImageFilesDatabase.INSTANCE.getXmpOfImageFiles(imageFiles);
    }

    public boolean saveDcSubject(String dcSubject) {
        return ImageFilesDatabase.INSTANCE.insertDcSubject(dcSubject);
    }

    public boolean saveOrUpdateExif(File imageFile, Exif exif) {
        return ImageFilesDatabase.INSTANCE.insertOrUpdateExif(imageFile, exif);
    }

    public boolean saveOrUpdateImageFile(ImageFile imageFile) {
        return ImageFilesDatabase.INSTANCE.insertOrUpdateImageFile(imageFile);
    }

    public boolean isDcSubjectReferenced(String dcSubject) {
        return ImageFilesDatabase.INSTANCE.isDcSubjectReferenced(dcSubject);
    }

    public boolean setLastModifiedToXmpSidecarFileOfImageFile(File imageFile, long time) {
        return ImageFilesDatabase.INSTANCE.setLastModifiedToXmpSidecarFileOfImageFile(imageFile, time);
    }

    public boolean updateImageFile(ImageFile imageFile) {
        return ImageFilesDatabase.INSTANCE.updateImageFile(imageFile);
    }

    public int updateRenameImageFile(File fromImageFile, File toImageFile) {
        return ImageFilesDatabase.INSTANCE.updateRenameImageFile(fromImageFile, toImageFile);
    }

    public boolean updateThumbnail(File imageFile, Image thumbnail) {
        return ImageFilesDatabase.INSTANCE.updateThumbnail(imageFile, thumbnail);
    }

    public Long findIdDcSubject(String dcSubject) {
        return ImageFilesDatabase.INSTANCE.getIdDcSubject(dcSubject);
    }

    public boolean existsXmpDcSubjectsLink(long idXmp, long idDcSubject) {
        return ImageFilesDatabase.INSTANCE.existsXmpDcSubjectsLink(idXmp, idDcSubject);
    }

    public int updateAllThumbnails(ProgressListener listener) {
        return ImageFilesDatabase.INSTANCE.updateAllThumbnails(listener);
    }

    public int updateRenameFilenamesStartingWith(String before, String after, ProgressListener progressListener) {
        return ImageFilesDatabase.INSTANCE.updateRenameFilenamesStartingWith(before, after, progressListener);
    }

    public boolean saveOrUpdateXmpOfImageFile(File imageFile, Xmp xmp) {
        return ImageFilesDatabase.INSTANCE.insertOrUpdateXmpOfImageFile(imageFile, xmp);
    }

    public boolean existsXmpForFile(File file) {
        return ImageFilesDatabase.INSTANCE.existsXmpForFile(file);
    }

    public int deleteXmpOfFile(File file) {
        return ImageFilesDatabase.INSTANCE.deleteXmpOfFile(file);
    }

    public String findXmpIptc4CoreDateCreated(File file) {
        return ImageFilesDatabase.INSTANCE.findXmpIptc4CoreDateCreated(file);
    }

    public long findExifDateTimeOriginalTimestamp(File file) {
        return ImageFilesDatabase.INSTANCE.findExifDateTimeOriginalTimestamp(file);
    }
}

