/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.awt.Image;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.applifecycle.generics.Functor;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.image.ImageFile;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.search.Join;
import org.jphototagger.domain.metadata.xmp.FileXmp;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcCreatorMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcDescriptionMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcRightsMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcTitleMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpIptc4XmpCoreDateCreatedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpIptc4xmpcoreLocationMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpLastModifiedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopAuthorspositionMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCaptionwriterMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCityMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCountryMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopCreditMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopHeadlineMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopInstructionsMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopSourceMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopStateMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpPhotoshopTransmissionReferenceMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpRatingMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.RepositoryStatistics;
import org.jphototagger.domain.repository.SynonymsRepository;
import org.jphototagger.domain.repository.ThumbnailsRepository;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectDeletedEvent;
import org.jphototagger.domain.repository.event.dcsubjects.DcSubjectInsertedEvent;
import org.jphototagger.domain.repository.event.exif.ExifDeletedEvent;
import org.jphototagger.domain.repository.event.exif.ExifInsertedEvent;
import org.jphototagger.domain.repository.event.exif.ExifUpdatedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileDeletedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileInsertedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileMovedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailUpdatedEvent;
import org.jphototagger.domain.timeline.Timeline;
import org.jphototagger.image.util.ThumbnailCreatorService;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.repository.hsqldb.Database;
import org.openide.util.Lookup;

final class ImageFilesDatabase
extends Database {
    static final ImageFilesDatabase INSTANCE = new ImageFilesDatabase();
    private static final Logger LOGGER = Logger.getLogger(ImageFilesDatabase.class.getName());
    private final XmpSidecarFileResolver xmpSidecarFileResolver = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private final ThumbnailsRepository tnRepo = (ThumbnailsRepository)Lookup.getDefault().lookup(ThumbnailsRepository.class);

    private ImageFilesDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateRenameImageFile(File fromImageFile, File toImageFile) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block6: {
            if (fromImageFile == null) {
                throw new NullPointerException("fromImageFile == null");
            }
            if (toImageFile == null) {
                throw new NullPointerException("toImageFile == null");
            }
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(true);
                stmt = con.prepareStatement("UPDATE files SET filename = ? WHERE filename = ?");
                stmt.setString(1, toImageFile.getAbsolutePath());
                stmt.setString(2, fromImageFile.getAbsolutePath());
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                this.tnRepo.renameThumbnail(fromImageFile, toImageFile);
                if (count <= 0) break block6;
                this.notifyImageFileMoved(fromImageFile, toImageFile);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getAllImageFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT filename FROM files";
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                files.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eachImage(Functor<File> functor) {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT filename FROM files";
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                functor.execute((Object)new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
    }

    private long getFileCountNameStartingWith(Connection con, String start) throws SQLException {
        long count = 0L;
        String sql = "SELECT COUNT(*) FROM files WHERE filename LIKE ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(sql);
            stmt.setString(1, start + "%");
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                count = rs.getLong(1);
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                throw throwable;
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int updateRenameFilenamesStartingWith(String before, String after, ProgressListener progressListener) {
        if (before == null) {
            throw new NullPointerException("before == null");
        }
        if (after == null) {
            throw new NullPointerException("after == null");
        }
        if (before.equals(after)) {
            return 0;
        }
        int countRenamed = 0;
        int startLength = before.length();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ProgressEvent progressEvent = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(0).value(0).build();
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.prepareStatement("SELECT filename FROM files WHERE filename LIKE ?");
            stmt.setString(1, before + "%");
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            progressEvent.setMaximum((int)this.getFileCountNameStartingWith(con, before));
            boolean cancel = this.notifyProgressListenerStart(progressListener, progressEvent);
            while (!cancel && rs.next()) {
                String from = rs.getString(1);
                String to = after + from.substring(startLength);
                this.updateImageFilename(con, new File(from), new File(to));
                progressEvent.setValue(++countRenamed);
                cancel = this.notifyProgressListenerPerformed(progressListener, progressEvent);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                ImageFilesDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                this.notifyProgressListenerEnd(progressListener, null);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
            this.notifyProgressListenerEnd(progressListener, null);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        this.notifyProgressListenerEnd(progressListener, null);
        return countRenamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImageFilename(Connection con, File fromImageFile, File toImageFile) throws SQLException {
        if (fromImageFile.equals(toImageFile)) {
            return;
        }
        PreparedStatement stmt = null;
        try {
            String sql = "UPDATE files SET filename = ? WHERE filename = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, toImageFile.getAbsolutePath());
            stmt.setString(2, fromImageFile.getAbsolutePath());
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
            this.notifyImageFileMoved(fromImageFile, toImageFile);
            this.tnRepo.renameThumbnail(fromImageFile, toImageFile);
        }
        catch (Throwable throwable) {
            ImageFilesDatabase.close(stmt);
            throw throwable;
        }
        ImageFilesDatabase.close(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteRowWithFilename(Connection con, File imageFile) {
        int countDeleted = 0;
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM files WHERE filename = ?");
            stmt.setString(1, imageFile.getAbsolutePath());
            LOGGER.log(Level.FINER, stmt.toString());
            countDeleted = stmt.executeUpdate();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            ImageFilesDatabase.close(stmt);
        }
        return countDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean insertOrUpdateExif(File imageFile, Exif exif) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (exif == null) {
            throw new NullPointerException("exif == null");
        }
        Connection con = null;
        try {
            con = this.getConnection();
            long idFile = this.findIdImageFile(con, imageFile);
            if (idFile < 0L) {
                boolean bl = false;
                return bl;
            }
            this.insertOrUpdateExif(con, imageFile, idFile, exif);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            ImageFilesDatabase.rollback(con);
        }
        finally {
            this.free(con);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean insertOrUpdateXmpOfImageFile(File imageFile, Xmp xmp) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        Connection con = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            long idFile = this.findIdImageFile(con, imageFile);
            if (idFile < 0L) {
                boolean bl = false;
                return bl;
            }
            this.insertOrUpdateXmp(con, imageFile, idFile, xmp);
            this.setLastModifiedToXmpSidecarFileOfImageFile(imageFile, xmp.contains((MetaDataValue)XmpLastModifiedMetaDataValue.INSTANCE) ? (Long)xmp.getValue((MetaDataValue)XmpLastModifiedMetaDataValue.INSTANCE) : -1L);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
            ImageFilesDatabase.rollback(con);
        }
        finally {
            this.free(con);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean insertOrUpdateImageFile(ImageFile imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        boolean success = false;
        if (this.existsImageFile(imageFile.getFile())) {
            return this.updateImageFile(imageFile);
        }
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            String sqlWithXmpLastModified = "INSERT INTO files (filename, size_in_bytes, lastmodified, xmp_lastmodified) VALUES (?, ?, ?, ?)";
            String sqlWithoutXmpLastModified = "INSERT INTO files (filename, size_in_bytes, lastmodified) VALUES (?, ?, ?)";
            boolean insertXmpIntoDb = imageFile.isInsertXmpIntoDb();
            stmt = con.prepareStatement(insertXmpIntoDb ? sqlWithXmpLastModified : sqlWithoutXmpLastModified);
            File file = imageFile.getFile();
            stmt.setString(1, file.getAbsolutePath());
            stmt.setLong(2, imageFile.getSizeInBytes());
            stmt.setLong(3, imageFile.getLastmodified());
            if (insertXmpIntoDb) {
                stmt.setLong(4, this.getLastmodifiedXmp(imageFile));
            }
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
            long idFile = this.findIdImageFile(con, file);
            if (imageFile.isInsertThumbnailIntoDb()) {
                this.updateThumbnailFile(file, imageFile.getThumbnail());
            }
            if (insertXmpIntoDb) {
                this.insertXmp(con, file, idFile, imageFile.getXmp());
            }
            if (imageFile.isInsertExifIntoDb()) {
                this.insertExif(con, file, idFile, imageFile.getExif());
            }
            con.commit();
            success = true;
            this.notifyImageFileInserted(file);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                ImageFilesDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(stmt);
        this.free(con);
        return success;
    }

    public ImageFile getImageFileOfFile(File file) {
        if (file == null) {
            throw new NullPointerException("imgFile == null");
        }
        ImageFile imageFile = new ImageFile();
        imageFile.setExif(this.getExifOfImageFile(file));
        imageFile.setFile(file);
        imageFile.setLastmodified(this.getImageFilesLastModifiedTimestamp(file));
        imageFile.setSizeInBytes(this.getImageFilesSizeInBytes(file));
        Image thumbnail = this.tnRepo.findThumbnail(file);
        if (thumbnail != null) {
            imageFile.setThumbnail(thumbnail);
        }
        imageFile.setXmp(this.getXmpOfImageFile(file));
        return imageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateImageFile(ImageFile imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        boolean success = false;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            String sqlWithXmpLastModified = "UPDATE files SET size_in_bytes = ?, lastmodified = ?, xmp_lastmodified = ? WHERE id = ?";
            String sqlWithoutXmpLastModified = "UPDATE files SET size_in_bytes = ?, lastmodified = ? WHERE id = ?";
            boolean insertXmpIntoDb = imageFile.isInsertXmpIntoDb();
            stmt = con.prepareStatement(insertXmpIntoDb ? sqlWithXmpLastModified : sqlWithoutXmpLastModified);
            File imgFile = imageFile.getFile();
            long idFile = this.findIdImageFile(con, imgFile);
            stmt.setLong(1, imageFile.getSizeInBytes());
            stmt.setLong(2, imageFile.getLastmodified());
            if (insertXmpIntoDb) {
                stmt.setLong(3, this.getLastmodifiedXmp(imageFile));
            }
            stmt.setLong(insertXmpIntoDb ? 4 : 3, idFile);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
            if (imageFile.isInsertThumbnailIntoDb()) {
                this.updateThumbnailFile(imgFile, imageFile.getThumbnail());
            }
            if (insertXmpIntoDb) {
                this.insertOrUpdateXmp(con, imgFile, idFile, imageFile.getXmp());
            }
            if (imageFile.isInsertExifIntoDb()) {
                this.insertOrUpdateExif(con, imgFile, idFile, imageFile.getExif());
            }
            con.commit();
            success = true;
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                ImageFilesDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(stmt);
        this.free(con);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateAllThumbnails(ProgressListener listener) {
        int updated = 0;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        RepositoryStatistics repoStatistics = (RepositoryStatistics)Lookup.getDefault().lookup(RepositoryStatistics.class);
        try {
            int filecount = repoStatistics.getFileCount();
            ProgressEvent progressEvent = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(filecount).value(0).info((Object)"").build();
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.createStatement();
            String sql = "SELECT filename FROM files ORDER BY filename ASC";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            int count = 0;
            this.notifyProgressListenerStart(listener, progressEvent);
            while (!progressEvent.isCancel() && rs.next()) {
                File imgFile = new File(rs.getString(1));
                Image thumbnail = ThumbnailCreatorService.INSTANCE.createThumbnail(imgFile);
                if (thumbnail != null) {
                    this.updateThumbnailFile(imgFile, thumbnail);
                }
                ++updated;
                progressEvent.setValue(++count);
                progressEvent.setInfo((Object)imgFile);
                this.notifyProgressListenerPerformed(listener, progressEvent);
            }
            this.notifyProgressListenerEnd(listener, progressEvent);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateThumbnail(File imageFile, Image thumbnail) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (thumbnail == null) {
            throw new NullPointerException("thumbnail == null");
        }
        Connection con = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            this.updateThumbnailFile(imageFile, thumbnail);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            this.free(con);
        }
        return false;
    }

    private void updateThumbnailFile(File imageFile, Image thumbnail) {
        if (thumbnail != null) {
            this.tnRepo.insertThumbnail(thumbnail, imageFile);
            this.notifyThumbnailUpdated(imageFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getImageFilesLastModifiedTimestamp(File imageFile) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        long lastModified;
        block5: {
            if (imageFile == null) {
                throw new NullPointerException("imageFile == null");
            }
            lastModified = -1L;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT lastmodified FROM files WHERE filename = ?");
                stmt.setString(1, imageFile.getAbsolutePath());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                lastModified = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getImageFilesSizeInBytes(File file) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        long sizeInBytes;
        block5: {
            if (file == null) {
                throw new NullPointerException("file == null");
            }
            sizeInBytes = 0L;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT size_in_bytes FROM files WHERE filename = ?");
                stmt.setString(1, file.getAbsolutePath());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                sizeInBytes = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return sizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsImageFile(File imageFile) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (imageFile == null) {
                throw new NullPointerException("imageFile == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM files WHERE filename = ?");
                stmt.setString(1, imageFile.getAbsolutePath());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteImageFiles(List<File> imageFiles) {
        if (imageFiles == null) {
            throw new NullPointerException("files == null");
        }
        int countDeleted = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.prepareStatement("DELETE FROM files WHERE filename = ?");
            for (File imageFile : imageFiles) {
                Xmp xmp = this.getXmpOfImageFile(imageFile);
                Exif exif = this.getExifOfImageFile(imageFile);
                stmt.setString(1, imageFile.getAbsolutePath());
                LOGGER.log(Level.FINER, stmt.toString());
                int countAffectedRows = stmt.executeUpdate();
                countDeleted += countAffectedRows;
                if (countAffectedRows <= 0) continue;
                this.tnRepo.deleteThumbnail(imageFile);
                this.notifyImageFileDeleted(imageFile);
                if (xmp != null) {
                    this.notifyXmpDeleted(imageFile, xmp);
                }
                if (exif == null) continue;
                this.notifyExifDeleted(imageFile, exif);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(stmt);
        this.free(con);
        return countDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteAbsentImageFiles(ProgressListener listener) {
        int countDeleted = 0;
        RepositoryStatistics repoStatistics = (RepositoryStatistics)Lookup.getDefault().lookup(RepositoryStatistics.class);
        ProgressEvent event = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(repoStatistics.getFileCount()).value(0).build();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.createStatement();
            String sql = "SELECT filename FROM files";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            boolean cancel = this.notifyProgressListenerStart(listener, event);
            while (!cancel && rs.next()) {
                File imgFile = new File(rs.getString(1));
                event.setInfo(null);
                if (!imgFile.exists()) {
                    Xmp xmp = this.getXmpOfImageFile(imgFile);
                    Exif exif = this.getExifOfImageFile(imgFile);
                    int deletedRows = this.deleteRowWithFilename(con, imgFile);
                    countDeleted += deletedRows;
                    if (deletedRows > 0) {
                        event.setInfo((Object)Bundle.getString(ImageFilesDatabase.class, (String)"ImageFilesDatabase.DeleteAbsentImageFiles.ImageFileDeleted", (Object[])new Object[]{imgFile}));
                        this.tnRepo.deleteThumbnail(imgFile);
                        this.notifyImageFileDeleted(imgFile);
                        if (xmp != null) {
                            this.notifyXmpDeleted(imgFile, xmp);
                        }
                        if (exif != null) {
                            this.notifyExifDeleted(imgFile, exif);
                        }
                    }
                }
                event.setValue(event.getValue() + 1);
                this.notifyProgressListenerPerformed(listener, event);
                cancel = event.isCancel();
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        event.setInfo((Object)countDeleted);
        this.notifyProgressListenerEnd(listener, event);
        return countDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findIdXmpOfIdFile(Connection con, long idFile) throws SQLException {
        long id = -1L;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM xmp WHERE id_file = ?");
            stmt.setLong(1, idFile);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            ImageFilesDatabase.close(rs, stmt);
            throw throwable;
        }
        ImageFilesDatabase.close(rs, stmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getXmpFilesLastModifiedTimestamp(File imageFile) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        long lastModified;
        block5: {
            if (imageFile == null) {
                throw new NullPointerException("imageFile == null");
            }
            lastModified = -1L;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT xmp_lastmodified FROM files WHERE filename = ?");
                stmt.setString(1, imageFile.getAbsolutePath());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                lastModified = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLastModifiedToXmpSidecarFileOfImageFile(File imageFile, long time) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        boolean set = false;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.prepareStatement("UPDATE files SET xmp_lastmodified = ? WHERE filename = ?");
            stmt.setLong(1, time);
            stmt.setString(2, imageFile.getAbsolutePath());
            LOGGER.log(Level.FINER, stmt.toString());
            int count = stmt.executeUpdate();
            set = count > 0;
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(stmt);
        this.free(con);
        return set;
    }

    private long getLastmodifiedXmp(ImageFile imageFile) {
        Xmp xmp = imageFile.getXmp();
        return xmp == null ? -1L : (xmp.contains((MetaDataValue)XmpLastModifiedMetaDataValue.INSTANCE) ? (Long)xmp.getValue((MetaDataValue)XmpLastModifiedMetaDataValue.INSTANCE) : -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertXmp(Connection con, File imageFile, long idImageFile, Xmp xmp) throws SQLException {
        if (xmp != null && !xmp.isEmpty()) {
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement(this.getInsertIntoXmpStatement());
                this.setXmpValues(stmt, idImageFile, xmp);
                LOGGER.log(Level.FINER, stmt.toString());
                stmt.executeUpdate();
                long idXmp = this.findIdXmpOfIdFile(con, idImageFile);
                if (xmp.contains((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE)) {
                    this.insertXmpDcSubjects(con, idXmp, (List)xmp.getValue((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE));
                }
                this.notifyXmpInserted(imageFile, xmp);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(stmt);
                throw throwable;
            }
            ImageFilesDatabase.close(stmt);
        }
    }

    private void insertXmpDcSubjects(Connection con, long idXmp, List<String> dcSubjects) throws SQLException {
        for (String dcSubject : dcSubjects) {
            Long idDcSubject = this.ensureDcSubjectExists(con, dcSubject);
            if (idDcSubject == null) {
                throw new SQLException("Couldn't ensure ID of DC subject!");
            }
            if (this.existsXmpDcSubjectsLink(idXmp, idDcSubject)) continue;
            this.insertXmpDcSubjectsLink(con, idXmp, idDcSubject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertXmpDcSubjectsLink(Connection con, long idXmp, long idDcSubject) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO xmp_dc_subject (id_xmp, id_dc_subject) VALUES (?, ?)");
            stmt.setLong(1, idXmp);
            stmt.setLong(2, idDcSubject);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
        }
        finally {
            ImageFilesDatabase.close(stmt);
        }
    }

    private Long ensureDcSubjectExists(Connection con, String dcSubject) throws SQLException {
        Long idDcSubject = this.getIdDcSubject(dcSubject);
        if (idDcSubject == null) {
            this.insertDcSubject(con, dcSubject);
            idDcSubject = this.getIdDcSubject(dcSubject);
        }
        return idDcSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertDcSubject(Connection con, String dcSubject) throws SQLException {
        PreparedStatement stmt = null;
        int count = 0;
        try {
            stmt = con.prepareStatement("INSERT INTO dc_subjects (subject) VALUES (?)");
            stmt.setString(1, dcSubject);
            LOGGER.log(Level.FINER, stmt.toString());
            count = stmt.executeUpdate();
        }
        finally {
            ImageFilesDatabase.close(stmt);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertDcSubject(String dcSubject) {
        if (dcSubject == null) {
            throw new NullPointerException("dcSubject == null");
        }
        boolean inserted = false;
        Connection con = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            int count = this.insertDcSubject(con, dcSubject);
            boolean bl = inserted = count == 1;
            if (inserted) {
                this.notifyDcSubjectInserted(dcSubject);
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            this.free(con);
        }
        return inserted;
    }

    private String getUpdateXmpStatement() {
        return "UPDATE xmp SET id_file = ?, id_dc_creator = ?, dc_description = ?, id_dc_rights = ?, dc_title = ?, id_iptc4xmpcore_location = ?, id_photoshop_authorsposition = ?, id_photoshop_captionwriter = ?, id_photoshop_city = ?, id_photoshop_country = ?, id_photoshop_credit = ?, photoshop_headline = ?, photoshop_instructions = ?, id_photoshop_source = ?, id_photoshop_state = ?, photoshop_transmissionReference = ?, rating = ?, iptc4xmpcore_datecreated = ? WHERE id = ?";
    }

    private String getInsertIntoXmpStatement() {
        return "INSERT INTO xmp (id_file, id_dc_creator, dc_description, id_dc_rights, dc_title, id_iptc4xmpcore_location, id_photoshop_authorsposition, id_photoshop_captionwriter, id_photoshop_city, id_photoshop_country, id_photoshop_credit, photoshop_headline, photoshop_instructions, id_photoshop_source, id_photoshop_state, photoshop_transmissionReference, rating, iptc4xmpcore_datecreated) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    private void setXmpValues(PreparedStatement stmt, long idImageFile, Xmp xmp) throws SQLException {
        stmt.setLong(1, idImageFile);
        this.setLong(this.ensureValueExists("dc_creators", "creator", (String)xmp.getValue((MetaDataValue)XmpDcCreatorMetaDataValue.INSTANCE)), stmt, 2);
        this.setString(xmp.getValue((MetaDataValue)XmpDcDescriptionMetaDataValue.INSTANCE), stmt, 3);
        this.setLong(this.ensureValueExists("dc_rights", "rights", (String)xmp.getValue((MetaDataValue)XmpDcRightsMetaDataValue.INSTANCE)), stmt, 4);
        this.setString(xmp.getValue((MetaDataValue)XmpDcTitleMetaDataValue.INSTANCE), stmt, 5);
        this.setLong(this.ensureValueExists("iptc4xmpcore_locations", "location", (String)xmp.getValue((MetaDataValue)XmpIptc4xmpcoreLocationMetaDataValue.INSTANCE)), stmt, 6);
        this.setLong(this.ensureValueExists("photoshop_authorspositions", "authorsposition", (String)xmp.getValue((MetaDataValue)XmpPhotoshopAuthorspositionMetaDataValue.INSTANCE)), stmt, 7);
        this.setLong(this.ensureValueExists("photoshop_captionwriters", "captionwriter", (String)xmp.getValue((MetaDataValue)XmpPhotoshopCaptionwriterMetaDataValue.INSTANCE)), stmt, 8);
        this.setLong(this.ensureValueExists("photoshop_cities", "city", (String)xmp.getValue((MetaDataValue)XmpPhotoshopCityMetaDataValue.INSTANCE)), stmt, 9);
        this.setLong(this.ensureValueExists("photoshop_countries", "country", (String)xmp.getValue((MetaDataValue)XmpPhotoshopCountryMetaDataValue.INSTANCE)), stmt, 10);
        this.setLong(this.ensureValueExists("photoshop_credits", "credit", (String)xmp.getValue((MetaDataValue)XmpPhotoshopCreditMetaDataValue.INSTANCE)), stmt, 11);
        this.setString(xmp.getValue((MetaDataValue)XmpPhotoshopHeadlineMetaDataValue.INSTANCE), stmt, 12);
        this.setString(xmp.getValue((MetaDataValue)XmpPhotoshopInstructionsMetaDataValue.INSTANCE), stmt, 13);
        this.setLong(this.ensureValueExists("photoshop_sources", "source", (String)xmp.getValue((MetaDataValue)XmpPhotoshopSourceMetaDataValue.INSTANCE)), stmt, 14);
        this.setLong(this.ensureValueExists("photoshop_states", "state", (String)xmp.getValue((MetaDataValue)XmpPhotoshopStateMetaDataValue.INSTANCE)), stmt, 15);
        this.setString(xmp.getValue((MetaDataValue)XmpPhotoshopTransmissionReferenceMetaDataValue.INSTANCE), stmt, 16);
        this.setLongMinMax(xmp.getValue((MetaDataValue)XmpRatingMetaDataValue.INSTANCE), XmpRatingMetaDataValue.getMinValue(), XmpRatingMetaDataValue.getMaxValue(), stmt, 17);
        this.setString(xmp.getValue((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE), stmt, 18);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrUpdateXmp(Connection con, File imageFile, long idFile, Xmp xmp) throws SQLException {
        block3: {
            block4: {
                if (xmp == null) break block3;
                long idXmp = this.findIdXmpOfIdFile(con, idFile);
                if (idXmp <= 0L) break block4;
                PreparedStatement stmt = null;
                try {
                    Xmp oldXmp = this.getXmpOfImageFile(imageFile);
                    stmt = con.prepareStatement(this.getUpdateXmpStatement());
                    this.setXmpValues(stmt, idFile, xmp);
                    stmt.setLong(19, idXmp);
                    LOGGER.log(Level.FINER, stmt.toString());
                    stmt.executeUpdate();
                    this.deleteXmpDcSubjects(con, idXmp);
                    if (xmp.contains((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE)) {
                        this.insertXmpDcSubjects(con, idXmp, (List)xmp.getValue((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE));
                    }
                    this.notifyXmpUpdated(imageFile, oldXmp, xmp);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(stmt);
                    throw throwable;
                }
                ImageFilesDatabase.close(stmt);
                break block3;
            }
            this.insertXmp(con, imageFile, idFile, xmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String findXmpIptc4CoreDateCreated(File file) {
        String result;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block5: {
            if (file == null) {
                throw new NullPointerException("file == null");
            }
            con = null;
            stmt = null;
            rs = null;
            String sql = "SELECT xmp.iptc4xmpcore_datecreated FROM files INNER JOIN xmp ON files.id = xmp.id_file WHERE files.filename = ?";
            result = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setString(1, file.getAbsolutePath());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                result = rs.getString(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsXmpForFile(File file) {
        long count;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block5: {
            if (file == null) {
                throw new NullPointerException("file == null");
            }
            con = null;
            stmt = null;
            rs = null;
            String sql = "SELECT COUNT(*) FROM files INNER JOIN xmp ON files.id = xmp.id_file WHERE files.filename = ?";
            count = 0L;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setString(1, file.getAbsolutePath());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                count = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return count > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteXmpOfFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        Connection con = null;
        int countDeleted = 0;
        try {
            con = this.getConnection();
            countDeleted = this.deleteXmpOfImageFile(con, file);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            this.free(con);
        }
        return countDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteXmpDcSubjects(Connection con, long idXmp) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM xmp_dc_subject WHERE id_xmp = ?");
            stmt.setLong(1, idXmp);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
        }
        finally {
            ImageFilesDatabase.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteAbsentXmp(ProgressListener listener) {
        int countDeleted = 0;
        RepositoryStatistics repoStatistics = (RepositoryStatistics)Lookup.getDefault().lookup(RepositoryStatistics.class);
        ProgressEvent progressEvent = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(repoStatistics.getXmpCount()).value(0).build();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.createStatement();
            String sql = "SELECT files.filename FROM files, xmp WHERE files.id = xmp.id_file";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            boolean cancel = this.notifyProgressListenerStart(listener, progressEvent);
            while (!cancel && rs.next()) {
                progressEvent.setInfo(null);
                File imageFile = new File(rs.getString(1));
                if (this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(imageFile) == null) {
                    int deleteCount = this.deleteXmpOfImageFile(con, imageFile);
                    countDeleted += deleteCount;
                    progressEvent.setInfo(deleteCount > 0 ? Bundle.getString(ImageFilesDatabase.class, (String)"ImageFilesDatabase.Info.DeleteAbsentXmp.XmpMetadataDeleted", (Object[])new Object[]{imageFile}) : null);
                }
                progressEvent.setValue(progressEvent.getValue() + 1);
                this.notifyProgressListenerPerformed(listener, progressEvent);
                cancel = progressEvent.isCancel();
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        progressEvent.setInfo((Object)countDeleted);
        this.notifyProgressListenerEnd(listener, progressEvent);
        return countDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteXmpOfImageFile(Connection con, File imageFile) {
        int count = 0;
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM xmp WHERE xmp.id_file in (SELECT xmp.id_file FROM xmp, files WHERE xmp.id_file = files.id AND files.filename = ?)");
            stmt.setString(1, imageFile.getAbsolutePath());
            LOGGER.log(Level.FINER, stmt.toString());
            Xmp xmp = this.getXmpOfImageFile(imageFile);
            count = stmt.executeUpdate();
            if (count > 0) {
                EventBus.publish((Object)new XmpDeletedEvent((Object)this, imageFile, xmp));
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            ImageFilesDatabase.close(stmt);
        }
        return count;
    }

    private String getXmpOfImageFilesStatement(int fileCount) {
        return " SELECT files.filename, dc_creators.creator, xmp.dc_description, dc_rights.rights, xmp.dc_title, iptc4xmpcore_locations.location, photoshop_authorspositions.authorsposition, photoshop_captionwriters.captionwriter, photoshop_cities.city, photoshop_countries.country, photoshop_credits.credit, xmp.photoshop_headline, xmp.photoshop_instructions, photoshop_sources.source, photoshop_states.state, xmp.photoshop_transmissionReference, dc_subjects.subject, xmp.rating, xmp.iptc4xmpcore_datecreated FROM files LEFT JOIN xmp ON files.id = xmp.id_file LEFT JOIN dc_creators ON xmp.id_dc_creator = dc_creators.id LEFT JOIN dc_rights ON xmp.id_dc_rights = dc_rights.id LEFT JOIN iptc4xmpcore_locations ON xmp.id_iptc4xmpcore_location = iptc4xmpcore_locations.id LEFT JOIN photoshop_authorspositions ON xmp.id_photoshop_authorsposition = photoshop_authorspositions.id LEFT JOIN photoshop_captionwriters ON xmp.id_photoshop_captionwriter = photoshop_captionwriters.id LEFT JOIN photoshop_cities ON xmp.id_photoshop_city = photoshop_cities.id LEFT JOIN photoshop_countries ON xmp.id_photoshop_country = photoshop_countries.id LEFT JOIN photoshop_credits ON xmp.id_photoshop_credit = photoshop_credits.id LEFT JOIN photoshop_sources ON xmp.id_photoshop_source = photoshop_sources.id LEFT JOIN photoshop_states ON xmp.id_photoshop_state = photoshop_states.id LEFT JOIN xmp_dc_subject ON xmp.id = xmp_dc_subject.id_xmp LEFT JOIN dc_subjects ON xmp_dc_subject.id_dc_subject = dc_subjects.id WHERE files.filename IN (" + ImageFilesDatabase.getPlaceholder(fileCount) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileXmp> getXmpOfImageFiles(Collection<? extends File> imageFiles) {
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        ArrayList<FileXmp> list = new ArrayList<FileXmp>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = this.getXmpOfImageFilesStatement(imageFiles.size());
            stmt = con.prepareStatement(sql);
            this.setStrings(stmt, imageFiles.toArray(new File[0]), 1);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            String prevFilepath = "";
            Xmp xmp = new Xmp();
            while (rs.next()) {
                String filepath = rs.getString(1);
                if (!filepath.equals(prevFilepath)) {
                    xmp = new Xmp();
                }
                xmp.setValue((MetaDataValue)XmpDcCreatorMetaDataValue.INSTANCE, (Object)this.getString(rs, 2));
                xmp.setValue((MetaDataValue)XmpDcDescriptionMetaDataValue.INSTANCE, (Object)this.getString(rs, 3));
                xmp.setValue((MetaDataValue)XmpDcRightsMetaDataValue.INSTANCE, (Object)this.getString(rs, 4));
                xmp.setValue((MetaDataValue)XmpDcTitleMetaDataValue.INSTANCE, (Object)this.getString(rs, 5));
                xmp.setValue((MetaDataValue)XmpIptc4xmpcoreLocationMetaDataValue.INSTANCE, (Object)this.getString(rs, 6));
                xmp.setValue((MetaDataValue)XmpPhotoshopAuthorspositionMetaDataValue.INSTANCE, (Object)this.getString(rs, 7));
                xmp.setValue((MetaDataValue)XmpPhotoshopCaptionwriterMetaDataValue.INSTANCE, (Object)this.getString(rs, 8));
                xmp.setValue((MetaDataValue)XmpPhotoshopCityMetaDataValue.INSTANCE, (Object)this.getString(rs, 9));
                xmp.setValue((MetaDataValue)XmpPhotoshopCountryMetaDataValue.INSTANCE, (Object)this.getString(rs, 10));
                xmp.setValue((MetaDataValue)XmpPhotoshopCreditMetaDataValue.INSTANCE, (Object)this.getString(rs, 11));
                xmp.setValue((MetaDataValue)XmpPhotoshopHeadlineMetaDataValue.INSTANCE, (Object)this.getString(rs, 12));
                xmp.setValue((MetaDataValue)XmpPhotoshopInstructionsMetaDataValue.INSTANCE, (Object)this.getString(rs, 13));
                xmp.setValue((MetaDataValue)XmpPhotoshopSourceMetaDataValue.INSTANCE, (Object)this.getString(rs, 14));
                xmp.setValue((MetaDataValue)XmpPhotoshopStateMetaDataValue.INSTANCE, (Object)this.getString(rs, 15));
                xmp.setValue((MetaDataValue)XmpPhotoshopTransmissionReferenceMetaDataValue.INSTANCE, (Object)this.getString(rs, 16));
                String dcSubject = this.getString(rs, 17);
                if (dcSubject != null) {
                    xmp.setValue((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE, (Object)dcSubject);
                }
                xmp.setValue((MetaDataValue)XmpRatingMetaDataValue.INSTANCE, (Object)this.getLongMinMax(rs, 18, XmpRatingMetaDataValue.getMinValue(), XmpRatingMetaDataValue.getMaxValue()));
                xmp.setValue((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE, (Object)this.getString(rs, 19));
                if (!filepath.equals(prevFilepath)) {
                    File file = new File(filepath);
                    list.add(new FileXmp(file, xmp));
                }
                prevFilepath = filepath;
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return list;
    }

    private void setStrings(PreparedStatement stmt, File[] files, int startIndex) throws SQLException {
        int endIndex = startIndex + files.length;
        int stringIndex = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            stmt.setString(i, files[stringIndex].getAbsolutePath());
            ++stringIndex;
        }
    }

    private static String getPlaceholder(int count) {
        StringBuilder sb = new StringBuilder(count * 3 - 2);
        for (int i = 0; i < count; ++i) {
            sb.append(i > 0 && i < count ? ", ?" : "?");
        }
        return sb.toString();
    }

    private String getXmpOfStatement() {
        return " SELECT dc_creators.creator, xmp.dc_description, dc_rights.rights, xmp.dc_title, iptc4xmpcore_locations.location, photoshop_authorspositions.authorsposition, photoshop_captionwriters.captionwriter, photoshop_cities.city, photoshop_countries.country, photoshop_credits.credit, xmp.photoshop_headline, xmp.photoshop_instructions, photoshop_sources.source, photoshop_states.state, xmp.photoshop_transmissionReference, dc_subjects.subject, xmp.rating, xmp.iptc4xmpcore_datecreated FROM files INNER JOIN xmp ON files.id = xmp.id_file LEFT JOIN dc_creators ON xmp.id_dc_creator = dc_creators.id LEFT JOIN dc_rights ON xmp.id_dc_rights = dc_rights.id LEFT JOIN iptc4xmpcore_locations ON xmp.id_iptc4xmpcore_location = iptc4xmpcore_locations.id LEFT JOIN photoshop_authorspositions ON xmp.id_photoshop_authorsposition = photoshop_authorspositions.id LEFT JOIN photoshop_captionwriters ON xmp.id_photoshop_captionwriter = photoshop_captionwriters.id LEFT JOIN photoshop_cities ON xmp.id_photoshop_city = photoshop_cities.id LEFT JOIN photoshop_countries ON xmp.id_photoshop_country = photoshop_countries.id LEFT JOIN photoshop_credits ON xmp.id_photoshop_credit = photoshop_credits.id LEFT JOIN photoshop_sources ON xmp.id_photoshop_source = photoshop_sources.id LEFT JOIN photoshop_states ON xmp.id_photoshop_state = photoshop_states.id LEFT JOIN xmp_dc_subject ON xmp.id = xmp_dc_subject.id_xmp LEFT JOIN dc_subjects ON xmp_dc_subject.id_dc_subject = dc_subjects.id WHERE files.filename = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xmp getXmpOfImageFile(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        Xmp xmp = new Xmp();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(this.getXmpOfStatement());
            stmt.setString(1, imageFile.getAbsolutePath());
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                xmp.setValue((MetaDataValue)XmpDcCreatorMetaDataValue.INSTANCE, (Object)this.getString(rs, 1));
                xmp.setValue((MetaDataValue)XmpDcDescriptionMetaDataValue.INSTANCE, (Object)this.getString(rs, 2));
                xmp.setValue((MetaDataValue)XmpDcRightsMetaDataValue.INSTANCE, (Object)this.getString(rs, 3));
                xmp.setValue((MetaDataValue)XmpDcTitleMetaDataValue.INSTANCE, (Object)this.getString(rs, 4));
                xmp.setValue((MetaDataValue)XmpIptc4xmpcoreLocationMetaDataValue.INSTANCE, (Object)this.getString(rs, 5));
                xmp.setValue((MetaDataValue)XmpPhotoshopAuthorspositionMetaDataValue.INSTANCE, (Object)this.getString(rs, 6));
                xmp.setValue((MetaDataValue)XmpPhotoshopCaptionwriterMetaDataValue.INSTANCE, (Object)this.getString(rs, 7));
                xmp.setValue((MetaDataValue)XmpPhotoshopCityMetaDataValue.INSTANCE, (Object)this.getString(rs, 8));
                xmp.setValue((MetaDataValue)XmpPhotoshopCountryMetaDataValue.INSTANCE, (Object)this.getString(rs, 9));
                xmp.setValue((MetaDataValue)XmpPhotoshopCreditMetaDataValue.INSTANCE, (Object)this.getString(rs, 10));
                xmp.setValue((MetaDataValue)XmpPhotoshopHeadlineMetaDataValue.INSTANCE, (Object)this.getString(rs, 11));
                xmp.setValue((MetaDataValue)XmpPhotoshopInstructionsMetaDataValue.INSTANCE, (Object)this.getString(rs, 12));
                xmp.setValue((MetaDataValue)XmpPhotoshopSourceMetaDataValue.INSTANCE, (Object)this.getString(rs, 13));
                xmp.setValue((MetaDataValue)XmpPhotoshopStateMetaDataValue.INSTANCE, (Object)this.getString(rs, 14));
                xmp.setValue((MetaDataValue)XmpPhotoshopTransmissionReferenceMetaDataValue.INSTANCE, (Object)this.getString(rs, 15));
                String dcSubject = this.getString(rs, 16);
                if (dcSubject != null) {
                    xmp.setValue((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE, (Object)dcSubject);
                }
                xmp.setValue((MetaDataValue)XmpRatingMetaDataValue.INSTANCE, (Object)this.getLongMinMax(rs, 17, XmpRatingMetaDataValue.getMinValue(), XmpRatingMetaDataValue.getMaxValue()));
                xmp.setValue((MetaDataValue)XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE, (Object)this.getString(rs, 18));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return xmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNotReferencedDcSubjects() {
        LinkedHashSet<String> dcSubjects = new LinkedHashSet<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT subject FROM dc_subjects WHERE ID NOT in (SELECT DISTINCT id_dc_subject from xmp_dc_subject)ORDER BY 1";
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                dcSubjects.add(rs.getString(1));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return dcSubjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDcSubjectReferenced(String subject) {
        if (subject == null) {
            throw new NullPointerException("subject == null");
        }
        Connection con = null;
        boolean ref = false;
        try {
            con = this.getConnection();
            Long id = ImageFilesDatabase.getId(con, "dc_subjects", "subject", subject);
            if (id != null) {
                ref = ImageFilesDatabase.getCount(con, "xmp_dc_subject", "id_dc_subject", id) > 0L;
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            this.free(con);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllDcSubjects() {
        LinkedHashSet<String> dcSubjects = new LinkedHashSet<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT subject FROM dc_subjects ORDER BY 1 ASC";
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                dcSubjects.add(rs.getString(1));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return dcSubjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDcSubjectsOfImageFile(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        ArrayList<String> dcSubjects = new ArrayList<String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT DISTINCT dc_subjects.subject FROM files INNER JOIN xmp ON files.id = xmp.id_file INNER JOIN xmp_dc_subject ON xmp.id = xmp_dc_subject.id_xmp INNER JOIN dc_subjects ON xmp_dc_subject.id_dc_subject = dc_subjects.id WHERE files.filename = ?  ORDER BY dc_subjects.subject ASC";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, imageFile.getAbsolutePath());
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                dcSubjects.add(rs.getString(1));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return dcSubjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getImageFilesContainingDcSubject(String dcSubject, boolean includeSynonyms) {
        if (dcSubject == null) {
            throw new NullPointerException("dcSubject == null");
        }
        LinkedHashSet<File> imageFiles = new LinkedHashSet<File>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        EnumSet<DcSubjectOption> opts = includeSynonyms ? EnumSet.copyOf(Arrays.asList(DcSubjectOption.INCLUDE_SYNONYMS)) : EnumSet.noneOf(DcSubjectOption.class);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(this.getGetFilenamesOfDcSubjectSql(dcSubject, opts));
            this.setDcSubjectSynonyms(dcSubject, opts, stmt);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                imageFiles.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return imageFiles;
    }

    private void setDcSubjectSynonyms(String dcSubject, Set<DcSubjectOption> options, PreparedStatement stmt) throws SQLException {
        stmt.setString(1, dcSubject);
        if (options.contains((Object)DcSubjectOption.INCLUDE_SYNONYMS)) {
            int paramIndex = 2;
            SynonymsRepository synonymsRepo = (SynonymsRepository)Lookup.getDefault().lookup(SynonymsRepository.class);
            for (String synonym : synonymsRepo.findSynonymsOfWord(dcSubject)) {
                stmt.setString(paramIndex, synonym);
                ++paramIndex;
            }
        }
    }

    private String getGetFilenamesOfDcSubjectSql(String dcSubject, Set<DcSubjectOption> options) {
        StringBuilder sql = new StringBuilder(" SELECT DISTINCT files.filename FROM dc_subjects INNER JOIN xmp_dc_subject ON dc_subjects.id = xmp_dc_subject.id_dc_subject INNER JOIN xmp ON xmp_dc_subject.id_xmp = xmp.id INNER JOIN files ON xmp.id_file = files.id WHERE dc_subjects.subject = ?");
        if (options.contains((Object)DcSubjectOption.INCLUDE_SYNONYMS)) {
            SynonymsRepository synonymsRepo = (SynonymsRepository)Lookup.getDefault().lookup(SynonymsRepository.class);
            int size = synonymsRepo.findSynonymsOfWord(dcSubject).size();
            for (int i = 0; i < size; ++i) {
                sql.append(" OR dc_subjects.subject = ?");
            }
        }
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getImageFilesContainingAllDcSubjects(List<? extends String> dcSubjects) {
        if (dcSubjects == null) {
            throw new NullPointerException("dcSubjects == null");
        }
        LinkedHashSet<File> imageFiles = new LinkedHashSet<File>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            int count = dcSubjects.size();
            String sql = " SELECT files.filename FROM dc_subjects INNER JOIN xmp_dc_subject ON dc_subjects.id = xmp_dc_subject.id_dc_subject INNER JOIN xmp ON xmp_dc_subject.id_xmp = xmp.id INNER JOIN files ON xmp.id_file = files.id WHERE dc_subjects.subject IN " + this.getParamsInParentheses(count) + " GROUP BY files.filename HAVING COUNT(*) = " + count;
            stmt = con.prepareStatement(sql);
            this.setStringParams(stmt, dcSubjects, 0);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                imageFiles.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return imageFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getImageFilesContainingSomeOfDcSubjects(List<? extends String> dcSubjects) {
        if (dcSubjects == null) {
            throw new NullPointerException("dcSubjects == null");
        }
        LinkedHashSet<File> imageFiles = new LinkedHashSet<File>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            int count = dcSubjects.size();
            String sql = " SELECT DISTINCT files.filename FROM dc_subjects INNER JOIN xmp_dc_subject ON dc_subjects.id = xmp_dc_subject.id_dc_subject INNER JOIN xmp ON xmp_dc_subject.id_xmp = xmp.id INNER JOIN files ON xmp.id_file = files.id WHERE dc_subjects.subject IN " + this.getParamsInParentheses(count);
            stmt = con.prepareStatement(sql);
            this.setStringParams(stmt, dcSubjects, 0);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                imageFiles.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return imageFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getImageFilesContainingAllWordsInColumn(List<? extends String> words, MetaDataValue column) {
        if (column == null) {
            throw new NullPointerException("column == null");
        }
        if (words == null) {
            throw new NullPointerException("words == null");
        }
        LinkedHashSet<File> imageFiles = new LinkedHashSet<File>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String tableName = column.getCategory();
            String columnName = column.getValueName();
            int count = words.size();
            String sql = " SELECT files.filename FROM files" + Join.getJoinToFiles((String)tableName, (Join.Type)Join.Type.INNER) + " WHERE " + tableName + "." + columnName + " IN " + this.getParamsInParentheses(count) + " GROUP BY files.filename" + " HAVING COUNT(*) = " + count;
            stmt = con.prepareStatement(sql);
            this.setStringParams(stmt, words, 0);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                imageFiles.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return imageFiles;
    }

    private String getUpdateExifStatement() {
        return "UPDATE exif SET id_file = ?, id_exif_recording_equipment = ?, exif_date_time_original = ?, exif_focal_length = ?, exif_iso_speed_ratings = ?, id_exif_lens = ?, exif_date_time_original_timestamp = ?, exif_gps_latitude = ?, exif_gps_longitude = ? WHERE id_file = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOrUpdateExif(Connection con, File imageFile, long idFile, Exif exif) throws SQLException {
        block3: {
            block4: {
                PreparedStatement stmt;
                block2: {
                    if (exif == null) break block3;
                    long idExif = this.findIdExifOfIdFile(con, idFile);
                    if (idExif <= 0L) break block4;
                    stmt = null;
                    try {
                        Exif oldExif = this.getExifOfImageFile(imageFile);
                        stmt = con.prepareStatement(this.getUpdateExifStatement());
                        this.setExifValues(stmt, idFile, exif);
                        stmt.setLong(10, idFile);
                        LOGGER.log(Level.FINER, stmt.toString());
                        int count = stmt.executeUpdate();
                        if (count <= 0) break block2;
                        this.notifyExifUpdated(imageFile, oldExif, exif);
                    }
                    catch (Throwable throwable) {
                        ImageFilesDatabase.close(stmt);
                        throw throwable;
                    }
                }
                ImageFilesDatabase.close(stmt);
                break block3;
            }
            this.insertExif(con, imageFile, idFile, exif);
        }
    }

    private String getInsertIntoExifStatement() {
        return "INSERT INTO exif (id_file, id_exif_recording_equipment, exif_date_time_original, exif_focal_length, exif_iso_speed_ratings, id_exif_lens, exif_date_time_original_timestamp, exif_gps_latitude, exif_gps_longitude) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertExif(Connection con, File imageFile, long idFile, Exif exif) throws SQLException {
        if (exif != null && !exif.isEmpty()) {
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement(this.getInsertIntoExifStatement());
                this.setExifValues(stmt, idFile, exif);
                LOGGER.log(Level.FINER, stmt.toString());
                stmt.executeUpdate();
                this.notifyExifInserted(imageFile, exif);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(stmt);
                throw throwable;
            }
            ImageFilesDatabase.close(stmt);
        }
    }

    private void setExifValues(PreparedStatement stmt, long idFile, Exif exif) throws SQLException {
        stmt.setLong(1, idFile);
        this.setLong(this.ensureValueExists("exif_recording_equipment", "equipment", exif.getRecordingEquipment()), stmt, 2);
        this.setDate(exif.getDateTimeOriginal(), stmt, 3);
        this.setDouble(exif.getFocalLengthGreaterZeroOrNull(), stmt, 4);
        this.setShort(exif.getIsoSpeedRatingsGreaterZeroOrNull(), stmt, 5);
        this.setLong(this.ensureValueExists("exif_lenses", "lens", exif.getLens()), stmt, 6);
        this.setLong(exif.getDateTimeOriginalTimestampGreaterZeroOrNull(), stmt, 7);
        boolean hasGpsCoordinates = exif.hasGpsCoordinates();
        this.setDouble(hasGpsCoordinates ? Double.valueOf(exif.getGpsLatitude()) : null, stmt, 8);
        this.setDouble(hasGpsCoordinates ? Double.valueOf(exif.getGpsLongitude()) : null, stmt, 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findIdExifOfIdFile(Connection con, long idFile) throws SQLException {
        long id = -1L;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM exif WHERE id_file = ?");
            stmt.setLong(1, idFile);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            ImageFilesDatabase.close(rs, stmt);
            throw throwable;
        }
        ImageFilesDatabase.close(rs, stmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeline getTimeline() {
        Timeline timeline = new Timeline();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT exif_date_time_original FROM exif WHERE exif_date_time_original IS NOT NULL ORDER BY exif_date_time_original ASC";
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(rs.getDate(1));
                timeline.add(cal);
            }
            this.addXmpDateCreatedToTimeline(con, timeline);
            timeline.addUnknownNode();
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return timeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXmpDateCreatedToTimeline(Connection con, Timeline timeline) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT iptc4xmpcore_datecreated FROM xmp WHERE iptc4xmpcore_datecreated IS NOT NULL";
        try {
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Timeline.Date date = new Timeline.Date(-1, -1, -1);
                date.setXmpDateCreated(rs.getString(1));
                if (!date.isValid()) continue;
                timeline.add(date);
            }
        }
        catch (Throwable throwable) {
            ImageFilesDatabase.close(rs, stmt);
            throw throwable;
        }
        ImageFilesDatabase.close(rs, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getImageFilesOfDateTaken(int year, int month, int day) {
        HashSet<File> files = new HashSet<File>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT files.filename FROM exif LEFT JOIN files ON exif.id_file = files.id WHERE exif.exif_date_time_original LIKE ? UNION SELECT files.filename FROM xmp LEFT JOIN files ON xmp.id_file = files.id WHERE xmp.iptc4xmpcore_datecreated LIKE ? ORDER BY files.filename ASC";
            stmt = con.prepareStatement(sql);
            String exifDateString = this.getExifSqlDateString(year, month, day);
            String xmpDateString = this.getXmpSqlDateString(year, month, day);
            stmt.setString(1, exifDateString);
            stmt.setString(2, xmpDateString);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                files.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return files;
    }

    private String getExifSqlDateString(int year, int month, int day) {
        StringBuilder sb = new StringBuilder(String.valueOf(year));
        if (month > 0) {
            sb.append("-");
            sb.append(ImageFilesDatabase.getMonthDayPrefix(month));
            sb.append(String.valueOf(month));
        } else {
            sb.append("-%");
        }
        if (day > 0) {
            sb.append("-");
            sb.append(ImageFilesDatabase.getMonthDayPrefix(day));
            sb.append(String.valueOf(day));
        } else {
            sb.append("-%");
        }
        return sb.toString();
    }

    private String getXmpSqlDateString(int year, int month, int day) {
        boolean hasOnlyYear;
        StringBuilder sb = new StringBuilder(String.valueOf(year));
        boolean hasMonth = month > 0;
        boolean hasDay = day > 0;
        boolean bl = hasOnlyYear = !hasMonth && !hasDay;
        if (hasOnlyYear) {
            sb.append("%");
            return sb.toString();
        }
        if (hasMonth) {
            sb.append("-");
            sb.append(ImageFilesDatabase.getMonthDayPrefix(month));
            sb.append(String.valueOf(month));
        }
        if (!hasDay) {
            sb.append("%");
            return sb.toString();
        }
        sb.append("-");
        sb.append(ImageFilesDatabase.getMonthDayPrefix(day));
        sb.append(String.valueOf(day));
        return sb.toString();
    }

    private static String getMonthDayPrefix(int i) {
        return i >= 10 ? "" : "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getImageFilesOfUnknownDateTaken() {
        ArrayList<File> files = new ArrayList<File>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT files.filename FROM files LEFT JOIN exif ON files.id = exif.id_file LEFT JOIN xmp ON files.id = xmp.id_file WHERE    (exif.id IS NULL AND xmp.id IS NULL)    OR (xmp.id IS NULL AND exif.id IS NOT NULL AND exif.exif_date_time_original IS NULL)    OR (exif.id IS NULL AND xmp.id IS NOT NULL AND (xmp.iptc4xmpcore_datecreated IS NULL OR xmp.iptc4xmpcore_datecreated = ''))    OR (exif.id IS NOT NULL AND exif.exif_date_time_original IS NULL       AND xmp.id IS NOT NULL AND (xmp.iptc4xmpcore_datecreated IS NULL OR xmp.iptc4xmpcore_datecreated = '')) ORDER BY files.filename ASC";
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                files.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllDistinctValuesOfColumn(MetaDataValue column) {
        if (column == null) {
            throw new NullPointerException("column == null");
        }
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = "SELECT DISTINCT " + column.getValueName() + " FROM " + column.getCategory() + " WHERE " + column.getValueName() + " IS NOT NULL" + " ORDER BY " + column.getValueName();
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                values.add(rs.getString(1));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return values;
    }

    private String getFilesNotNullInSql(String tablename, String columnName) {
        boolean isLink = !tablename.equals("xmp") && !tablename.equals("exif");
        return isLink ? Join.getNotNullSqlOf((String)tablename) : "SELECT DISTINCT files.filename FROM " + tablename + " INNER JOIN files ON " + tablename + ".id_file = files.id" + " WHERE " + tablename + "." + columnName + " IS NOT NULL" + " ORDER BY files.filename ASC";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getImageFilesContainingAVauleInColumn(MetaDataValue column) {
        if (column == null) {
            throw new NullPointerException("column == null");
        }
        ArrayList<File> files = new ArrayList<File>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String tablename = column.getCategory();
            String columnName = column.getValueName();
            String sql = this.getFilesNotNullInSql(tablename, columnName);
            stmt = con.createStatement();
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                files.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getImageFilesWhereColumnHasExactValue(MetaDataValue column, String exactValue) {
        if (column == null) {
            throw new NullPointerException("column == null");
        }
        ArrayList<File> files = new ArrayList<File>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String tableName = column.getCategory();
        String columnName = column.getValueName();
        try {
            con = this.getConnection();
            String sql = "SELECT files.filename FROM files" + Join.getJoinToFiles((String)tableName, (Join.Type)Join.Type.INNER) + " WHERE " + tableName + "." + columnName + " = ?" + " ORDER BY files.filename ASC";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, exactValue);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                files.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long findExifDateTimeOriginalTimestamp(File file) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        long timestamp;
        block5: {
            if (file == null) {
                throw new NullPointerException("file == null");
            }
            timestamp = -1L;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = "SELECT exif.exif_date_time_original_timestamp FROM files INNER JOIN exif ON files.id = exif.id_file WHERE files.filename = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, file.getAbsolutePath());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                timestamp = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return timestamp;
    }

    private String getExifOfStatement() {
        return "SELECT exif_recording_equipment.equipment, exif.exif_date_time_original, exif.exif_focal_length, exif.exif_iso_speed_ratings, exif_lenses.lens, exif_date_time_original_timestamp, exif_gps_latitude, exif_gps_longitude FROM files INNER JOIN exif ON files.id = exif.id_file LEFT JOIN exif_recording_equipment ON exif.id_exif_recording_equipment = exif_recording_equipment.id LEFT JOIN exif_lenses ON exif.id_exif_lens = exif_lenses.id WHERE files.filename = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exif getExifOfImageFile(File imageFile) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        Exif exif;
        block5: {
            if (imageFile == null) {
                throw new NullPointerException("imageFile == null");
            }
            exif = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                boolean hasGpsLongitude;
                con = this.getConnection();
                stmt = con.prepareStatement(this.getExifOfStatement());
                stmt.setString(1, imageFile.getAbsolutePath());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exif = new Exif();
                exif.setRecordingEquipment(rs.getString(1));
                exif.setDateTimeOriginal(rs.getDate(2));
                exif.setFocalLength(rs.getDouble(3));
                exif.setIsoSpeedRatings(rs.getShort(4));
                exif.setLens(rs.getString(5));
                exif.setDateTimeOriginalTimestamp(rs.getLong(6));
                double gpsLatitude = rs.getDouble(7);
                boolean hasGpsLatitude = !rs.wasNull();
                double gpsLongitude = rs.getDouble(8);
                boolean bl = hasGpsLongitude = !rs.wasNull();
                if (!hasGpsLatitude || !hasGpsLongitude) break block5;
                exif.setGpsLatitude(gpsLatitude);
                exif.setGpsLongitude(gpsLongitude);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return exif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsExifDate(Date date) {
        ResultSet rs;
        Statement stmt;
        Connection con;
        boolean exists;
        block6: {
            if (date == null) {
                throw new NullPointerException("date == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                int year = cal.get(1);
                int month = cal.get(2) + 1;
                int day = cal.get(5);
                String sql = "SELECT COUNT(*) FROM exif WHERE exif_date_time_original LIKE '" + year + "-" + ImageFilesDatabase.getMonthDayPrefix(month) + month + "-" + ImageFilesDatabase.getMonthDayPrefix(day) + day + "%'";
                stmt = con.createStatement();
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block6;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                }
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsXMPDateCreated(String date) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (date == null) {
                throw new NullPointerException("date == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM xmp WHERE iptc4xmpcore_datecreated = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, date);
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsValueInColumn(Object value, MetaDataValue column) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block6: {
            if (column == null) {
                throw new NullPointerException("column == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                String sql = "SELECT COUNT(*) FROM " + column.getCategory() + " WHERE " + column.getValueName() + " = ?";
                stmt = con.prepareStatement(sql);
                LOGGER.log(Level.FINEST, stmt.toString());
                stmt.setObject(1, value);
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                }
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    private String getFilenamesWithoutMetadataInSql(String tablename, String columnName) {
        boolean isLink = !tablename.equals("xmp") && !tablename.equals("exif");
        return isLink ? Join.getNullSqlOf((String)tablename) : "SELECT files.filename FROM files INNER JOIN " + tablename + " ON files.id = " + tablename + ".id_file WHERE " + tablename + "." + columnName + " IS NULL" + " UNION SELECT files.filename FROM files " + Join.getUnjoinedFilesSqlWhere((String)tablename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getImageFilesWithoutMetadataInColumn(MetaDataValue column) {
        if (column == null) {
            throw new NullPointerException("column == null");
        }
        ArrayList<File> imageFiles = new ArrayList<File>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String columnName = column.getValueName();
            String tablename = column.getCategory();
            String sql = this.getFilenamesWithoutMetadataInSql(tablename, columnName);
            stmt = con.prepareStatement(sql);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                imageFiles.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return imageFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long findIdImageFile(Connection con, File file) throws SQLException {
        long id = -1L;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM files WHERE filename = ?");
            stmt.setString(1, file.getAbsolutePath());
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            ImageFilesDatabase.close(rs, stmt);
            throw throwable;
        }
        ImageFilesDatabase.close(rs, stmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteValueOfJoinedColumn(MetaDataValue column, String value) {
        if (column == null) {
            throw new NullPointerException("column == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        String sql = Join.getDeleteSql((String)column.getCategory());
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.prepareStatement(sql);
            stmt.setString(1, value);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (Throwable throwable) {
                ImageFilesDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            ImageFilesDatabase.close(stmt);
            this.free(con);
        }
        ImageFilesDatabase.close(stmt);
        this.free(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDcSubject(String dcSubject) {
        PreparedStatement stmt;
        Connection con;
        block5: {
            if (dcSubject == null) {
                throw new NullPointerException("dcSubject == null");
            }
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("DELETE FROM dc_subjects WHERE subject = ?");
                stmt.setString(1, dcSubject);
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                if (count <= 0) break block5;
                this.notifyDcSubjectDeleted(dcSubject);
            }
            catch (SQLException ex) {
                try {
                    LOGGER.log(Level.SEVERE, null, ex);
                    ImageFilesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(stmt);
        this.free(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsDcSubject(String subject) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (subject == null) {
                throw new NullPointerException("subject == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM dc_subjects WHERE subject = ?");
                stmt.setString(1, subject);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) == 1;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getIdDcSubject(String dcSubject) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        Long id;
        block5: {
            if (dcSubject == null) {
                throw new NullPointerException("dcSubject == null");
            }
            id = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT id FROM dc_subjects WHERE subject = ?");
                stmt.setString(1, dcSubject);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                id = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsXmpDcSubjectsLink(long idXmp, long idDcSubject) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block4: {
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM xmp_dc_subject WHERE id_xmp = ? AND id_dc_subject = ?");
                stmt.setLong(1, idXmp);
                stmt.setLong(2, idDcSubject);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                exists = rs.getInt(1) == 1;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    void notifyImageFileDeleted(File imageFile) {
        EventBus.publish((Object)new ImageFileDeletedEvent((Object)this, imageFile));
    }

    private void notifyImageFileInserted(File imageFile) {
        EventBus.publish((Object)new ImageFileInsertedEvent((Object)this, imageFile));
    }

    private void notifyImageFileMoved(File oldFile, File newFile) {
        EventBus.publish((Object)new ImageFileMovedEvent((Object)this, oldFile, newFile));
    }

    private void notifyXmpUpdated(File imageFile, Xmp oldXmp, Xmp updatedXmp) {
        EventBus.publish((Object)new XmpUpdatedEvent((Object)this, imageFile, oldXmp, updatedXmp));
    }

    private void notifyXmpInserted(File imageFile, Xmp xmp) {
        EventBus.publish((Object)new XmpInsertedEvent((Object)this, imageFile, xmp));
    }

    private void notifyXmpDeleted(File imageFile, Xmp xmp) {
        EventBus.publish((Object)new XmpDeletedEvent((Object)this, imageFile, xmp));
    }

    private void notifyExifUpdated(File imageFile, Exif oldExif, Exif updatedExif) {
        EventBus.publish((Object)new ExifUpdatedEvent((Object)this, imageFile, oldExif, updatedExif));
    }

    private void notifyExifInserted(File imageFile, Exif eExif) {
        EventBus.publish((Object)new ExifInsertedEvent((Object)this, imageFile, eExif));
    }

    private void notifyExifDeleted(File imageFile, Exif exif) {
        EventBus.publish((Object)new ExifDeletedEvent((Object)exif, imageFile, exif));
    }

    private void notifyThumbnailUpdated(File imageFile) {
        EventBus.publish((Object)new ThumbnailUpdatedEvent((Object)this, imageFile));
    }

    private void notifyDcSubjectInserted(String dcSubject) {
        EventBus.publish((Object)new DcSubjectInsertedEvent((Object)this, dcSubject));
    }

    private void notifyDcSubjectDeleted(String dcSubject) {
        EventBus.publish((Object)new DcSubjectDeletedEvent((Object)this, dcSubject));
    }

    private void setStringParams(PreparedStatement stmt, List<? extends String> params, int offset) throws SQLException {
        if (offset < 0) {
            return;
        }
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            stmt.setString(i + 1 + offset, params.get(i));
        }
    }

    private String getParamsInParentheses(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Count < 1: " + count);
        }
        StringBuilder sb = new StringBuilder(count * 2);
        sb.append("(");
        for (int i = 0; i < count; ++i) {
            sb.append(i == 0 ? "" : ",").append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileCount() {
        long count;
        ResultSet rs;
        Statement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            rs = null;
            count = 0L;
            try {
                con = this.getConnection();
                stmt = con.createStatement();
                con.setAutoCommit(false);
                String sql = "SELECT COUNT(*) FROM files";
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block4;
                count = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageFilesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageFilesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageFilesDatabase.close(rs, stmt);
        this.free(con);
        return count;
    }

    private static enum DcSubjectOption {
        INCLUDE_SYNONYMS;

    }
}

