/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.imagecollections.ImageCollection;
import org.jphototagger.domain.repository.event.imagecollections.ImageCollectionDeletedEvent;
import org.jphototagger.domain.repository.event.imagecollections.ImageCollectionImagesDeletedEvent;
import org.jphototagger.domain.repository.event.imagecollections.ImageCollectionImagesInsertedEvent;
import org.jphototagger.domain.repository.event.imagecollections.ImageCollectionInsertedEvent;
import org.jphototagger.domain.repository.event.imagecollections.ImageCollectionRenamedEvent;
import org.jphototagger.repository.hsqldb.Database;
import org.jphototagger.repository.hsqldb.ImageFilesDatabase;

final class ImageCollectionsDatabase
extends Database {
    static final ImageCollectionsDatabase INSTANCE = new ImageCollectionsDatabase();
    private static final Logger LOGGER = Logger.getLogger(ImageCollectionsDatabase.class.getName());
    private final ImageFilesDatabase repo = ImageFilesDatabase.INSTANCE;

    private ImageCollectionsDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getAllImageCollectionNames() {
        ArrayList<String> names = new ArrayList<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            String sql = "SELECT name FROM collection_names ORDER BY name";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                names.add(rs.getString(1));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                names.clear();
            }
            catch (Throwable throwable) {
                ImageCollectionsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageCollectionsDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageCollectionsDatabase.close(rs, stmt);
        this.free(con);
        return names;
    }

    List<ImageCollection> getAllImageCollections() {
        List<String> names = this.getAllImageCollectionNames();
        ArrayList<ImageCollection> collections = new ArrayList<ImageCollection>(names.size());
        for (String name : names) {
            collections.add(new ImageCollection(name, this.getImageFilesOfImageCollection(name)));
        }
        return collections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateRenameImageCollection(String fromName, String toName) {
        PreparedStatement stmt;
        Connection con;
        int count;
        block7: {
            if (fromName == null) {
                throw new NullPointerException("fromName == null");
            }
            if (toName == null) {
                throw new NullPointerException("toName == null");
            }
            if (ImageCollection.isSpecialCollection((String)fromName) || ImageCollection.isSpecialCollection((String)toName) || this.existsImageCollection(toName)) {
                return 0;
            }
            count = 0;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(true);
                stmt = con.prepareStatement("UPDATE collection_names SET name = ? WHERE name = ?");
                stmt.setString(1, toName);
                stmt.setString(2, fromName);
                LOGGER.log(Level.FINER, stmt.toString());
                count = stmt.executeUpdate();
                if (count <= 0) break block7;
                this.notifyCollectionRenamed(fromName, toName);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageCollectionsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageCollectionsDatabase.close(stmt);
                this.free(con);
            }
        }
        ImageCollectionsDatabase.close(stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> getImageFilesOfImageCollection(String collectionName) {
        if (collectionName == null) {
            throw new NullPointerException("collectionName == null");
        }
        ArrayList<File> imageFiles = new ArrayList<File>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement("SELECT files.filename FROM collections INNER JOIN collection_names ON collections.id_collectionnname = collection_names.id INNER JOIN files ON collections.id_file = files.id WHERE collection_names.name = ? ORDER BY collections.sequence_number ASC");
            stmt.setString(1, collectionName);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                imageFiles.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                imageFiles.clear();
            }
            catch (Throwable throwable) {
                ImageCollectionsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            ImageCollectionsDatabase.close(rs, stmt);
            this.free(con);
        }
        ImageCollectionsDatabase.close(rs, stmt);
        this.free(con);
        return imageFiles;
    }

    boolean insertImageCollection(ImageCollection collection) {
        if (collection == null) {
            throw new NullPointerException("collection == null");
        }
        return this.insertImageCollection(collection.getName(), collection.getFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean insertImageCollection(String collectionName, List<File> imageFiles) {
        boolean bl;
        PreparedStatement stmtColl;
        PreparedStatement stmtName;
        Connection con;
        block10: {
            if (collectionName == null) {
                throw new NullPointerException("collectionName == null");
            }
            if (imageFiles == null) {
                throw new NullPointerException("imageFiles == null");
            }
            boolean added = false;
            if (this.existsImageCollection(collectionName)) {
                this.deleteImageCollection(collectionName, true);
            }
            con = null;
            stmtName = null;
            stmtColl = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmtName = con.prepareStatement("INSERT INTO collection_names (name) VALUES (?)");
                stmtColl = con.prepareStatement("INSERT INTO collections (id_collectionnname, id_file, sequence_number) VALUES (?, ?, ?)");
                stmtName.setString(1, collectionName);
                LOGGER.log(Level.FINER, stmtName.toString());
                stmtName.executeUpdate();
                long idCollectionName = this.findId(con, collectionName);
                int sequence_number = 0;
                for (File imageFile : imageFiles) {
                    long idImageFile = this.repo.findIdImageFile(con, imageFile);
                    if (!this.repo.existsImageFile(imageFile)) {
                        LOGGER.log(Level.WARNING, "File ''{0}'' is not in the database! No photo album will be created!", imageFile);
                        ImageCollectionsDatabase.rollback(con);
                        bl = false;
                        break block10;
                    }
                    stmtColl.setLong(1, idCollectionName);
                    stmtColl.setLong(2, idImageFile);
                    stmtColl.setInt(3, sequence_number);
                    LOGGER.log(Level.FINER, stmtColl.toString());
                    stmtColl.executeUpdate();
                    ++sequence_number;
                }
                con.commit();
                added = true;
                this.notifyCollectionInserted(collectionName, imageFiles);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    ImageCollectionsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    ImageCollectionsDatabase.close(stmtColl);
                    ImageCollectionsDatabase.close(stmtName);
                    this.free(con);
                    throw throwable;
                }
                ImageCollectionsDatabase.close(stmtColl);
                ImageCollectionsDatabase.close(stmtName);
                this.free(con);
                return added;
            }
            ImageCollectionsDatabase.close(stmtColl);
            ImageCollectionsDatabase.close(stmtName);
            this.free(con);
            return added;
        }
        ImageCollectionsDatabase.close(stmtColl);
        ImageCollectionsDatabase.close(stmtName);
        this.free(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteImageCollection(String collectioNname, boolean force) {
        if (collectioNname == null) {
            throw new NullPointerException("collectioNname == null");
        }
        if (!force && ImageCollection.isSpecialCollection((String)collectioNname)) {
            return false;
        }
        boolean deleted = false;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            List<File> delFiles = this.getImageFilesOfImageCollection(collectioNname);
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.prepareStatement("DELETE FROM collection_names WHERE name = ?");
            stmt.setString(1, collectioNname);
            LOGGER.log(Level.FINER, stmt.toString());
            stmt.executeUpdate();
            deleted = true;
            this.notifyCollectionDeleted(collectioNname, delFiles);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ImageCollectionsDatabase.close(stmt);
                this.free(con);
            }
        }
        ImageCollectionsDatabase.close(stmt);
        this.free(con);
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteImagesFromImageCollection(String collectionName, List<File> imageFiles) {
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        int delCount = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            stmt = con.prepareStatement("DELETE FROM collections WHERE id_collectionnname = ? AND id_file = ?");
            ArrayList<File> deletedFiles = new ArrayList<File>(imageFiles.size());
            for (File imageFile : imageFiles) {
                int prevDelCount = delCount;
                long idCollectionName = this.findId(con, collectionName);
                long idFile = this.repo.findIdImageFile(con, imageFile);
                stmt.setLong(1, idCollectionName);
                stmt.setLong(2, idFile);
                LOGGER.log(Level.FINER, stmt.toString());
                if (prevDelCount < (delCount += stmt.executeUpdate())) {
                    deletedFiles.add(imageFile);
                }
                this.reorderSequenceNumber(con, collectionName);
            }
            con.commit();
            this.notifyImagesDeleted(collectionName, deletedFiles);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                ImageCollectionsDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                ImageCollectionsDatabase.close(stmt);
                this.free(con);
                throw throwable;
            }
            ImageCollectionsDatabase.close(stmt);
            this.free(con);
        }
        ImageCollectionsDatabase.close(stmt);
        this.free(con);
        return delCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertImagesIntoImageCollection(String collectionName, List<File> imageFiles) {
        boolean added;
        block11: {
            PreparedStatement stmt;
            Connection con;
            block10: {
                if (collectionName == null) {
                    throw new NullPointerException("collectionName == null");
                }
                if (imageFiles == null) {
                    throw new NullPointerException("imageFiles == null");
                }
                added = false;
                con = null;
                stmt = null;
                if (this.existsImageCollection(collectionName)) {
                    con = this.getConnection();
                    con.setAutoCommit(false);
                    stmt = con.prepareStatement("INSERT INTO collections (id_file, id_collectionnname, sequence_number) VALUES (?, ?, ?)");
                    long idCollectionNames = this.findId(con, collectionName);
                    int sequence_number = this.getMaxSequenceNumber(con, collectionName) + 1;
                    ArrayList<File> insertedFiles = new ArrayList<File>(imageFiles.size());
                    for (File imageFile : imageFiles) {
                        if (this.isImageIn(con, collectionName, imageFile)) continue;
                        long idFiles = this.repo.findIdImageFile(con, imageFile);
                        stmt.setLong(1, idFiles);
                        stmt.setLong(2, idCollectionNames);
                        stmt.setInt(3, sequence_number);
                        LOGGER.log(Level.FINER, stmt.toString());
                        stmt.executeUpdate();
                        insertedFiles.add(imageFile);
                        ++sequence_number;
                    }
                    this.reorderSequenceNumber(con, collectionName);
                    this.notifyImagesInserted(collectionName, insertedFiles);
                    break block10;
                }
                boolean idCollectionNames = this.insertImageCollection(collectionName, imageFiles);
                ImageCollectionsDatabase.close(stmt);
                this.free(con);
                return idCollectionNames;
            }
            try {
                con.commit();
                added = true;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    ImageCollectionsDatabase.rollback(con);
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ImageCollectionsDatabase.close(stmt);
                    this.free(con);
                }
            }
            ImageCollectionsDatabase.close(stmt);
            this.free(con);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxSequenceNumber(Connection con, String collectionName) throws SQLException {
        int max = -1;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT MAX(collections.sequence_number) FROM collections INNER JOIN collection_names ON collections.id_collectionnname = collection_names.id AND collection_names.name = ?");
            stmt.setString(1, collectionName);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                max = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            ImageCollectionsDatabase.close(rs, stmt);
            throw throwable;
        }
        ImageCollectionsDatabase.close(rs, stmt);
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorderSequenceNumber(Connection con, String collectionName) throws SQLException {
        long idCollectionName = this.findId(con, collectionName);
        PreparedStatement stmtIdFiles = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmtIdFiles = con.prepareStatement("SELECT id_file FROM collections WHERE id_collectionnname = ? ORDER BY collections.sequence_number ASC");
            stmtIdFiles.setLong(1, idCollectionName);
            rs = stmtIdFiles.executeQuery();
            ArrayList<Long> idFiles = new ArrayList<Long>();
            while (rs.next()) {
                idFiles.add(rs.getLong(1));
            }
            stmt = con.prepareStatement("UPDATE collections SET sequence_number = ? WHERE id_collectionnname = ? AND id_file = ?");
            LOGGER.log(Level.FINEST, stmt.toString());
            int sequenceNumer = 0;
            for (Long idFile : idFiles) {
                stmt.setInt(1, sequenceNumer);
                stmt.setLong(2, idCollectionName);
                stmt.setLong(3, idFile);
                LOGGER.log(Level.FINER, stmt.toString());
                stmt.executeUpdate();
                ++sequenceNumer;
            }
        }
        catch (Throwable throwable) {
            ImageCollectionsDatabase.close(rs, stmtIdFiles);
            ImageCollectionsDatabase.close(stmt);
            throw throwable;
        }
        ImageCollectionsDatabase.close(rs, stmtIdFiles);
        ImageCollectionsDatabase.close(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsImageCollection(String collectionName) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (collectionName == null) {
                throw new NullPointerException("collectionName == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM collection_names WHERE name = ?");
                stmt.setString(1, collectionName);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageCollectionsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageCollectionsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageCollectionsDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getImageCollectionCount() {
        ResultSet rs;
        Statement stmt;
        Connection con;
        int count;
        block4: {
            count = -1;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.createStatement();
                String sql = "SELECT COUNT(*) FROM collection_names";
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageCollectionsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageCollectionsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageCollectionsDatabase.close(rs, stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getImageCountOfAllImageCollections() {
        ResultSet rs;
        Statement stmt;
        Connection con;
        int count;
        block4: {
            count = -1;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.createStatement();
                String sql = "SELECT COUNT(*) FROM collections";
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    ImageCollectionsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                ImageCollectionsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        ImageCollectionsDatabase.close(rs, stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isImageIn(Connection con, String collectionName, File imageFile) throws SQLException {
        boolean isInCollection = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT COUNT(*) FROM collections INNER JOIN collection_names ON collections.id_collectionnname = collection_names.id INNER JOIN files on collections.id_file = files.id WHERE collection_names.name = ? AND files.filename = ?");
            stmt.setString(1, collectionName);
            stmt.setString(2, imageFile.getAbsolutePath());
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                isInCollection = rs.getInt(1) > 0;
            }
        }
        catch (Throwable throwable) {
            ImageCollectionsDatabase.close(rs, stmt);
            throw throwable;
        }
        ImageCollectionsDatabase.close(rs, stmt);
        return isInCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findId(Connection con, String collectionname) throws SQLException {
        long id = -1L;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM collection_names WHERE name = ?");
            stmt.setString(1, collectionname);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            ImageCollectionsDatabase.close(rs, stmt);
            throw throwable;
        }
        ImageCollectionsDatabase.close(rs, stmt);
        return id;
    }

    private void notifyImagesInserted(String collectionName, List<File> insertedImageFiles) {
        EventBus.publish((Object)new ImageCollectionImagesInsertedEvent((Object)this, collectionName, insertedImageFiles));
    }

    private void notifyImagesDeleted(String collectionName, List<File> deletedImageFiles) {
        EventBus.publish((Object)new ImageCollectionImagesDeletedEvent((Object)this, collectionName, deletedImageFiles));
    }

    private void notifyCollectionInserted(String collectionName, List<File> insertedImageFiles) {
        EventBus.publish((Object)new ImageCollectionInsertedEvent((Object)this, collectionName, insertedImageFiles));
    }

    private void notifyCollectionDeleted(String collectionName, List<File> deletedImageFiles) {
        EventBus.publish((Object)new ImageCollectionDeletedEvent((Object)this, collectionName, deletedImageFiles));
    }

    private void notifyCollectionRenamed(String fromName, String toName) {
        EventBus.publish((Object)new ImageCollectionRenamedEvent((Object)this, fromName, toName));
    }
}

