/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.search.Join;
import org.jphototagger.domain.metadata.search.ParamStatement;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.SynonymsRepository;
import org.jphototagger.repository.hsqldb.Database;
import org.openide.util.Lookup;

final class FindDatabase
extends Database {
    static final FindDatabase INSTANCE = new FindDatabase();
    private static final Logger LOGGER = Logger.getLogger(FindDatabase.class.getName());

    private FindDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> findImageFiles(ParamStatement paramStatement) {
        if (paramStatement == null) {
            throw new NullPointerException("paramStatement == null");
        }
        ArrayList<File> imageFiles = new ArrayList<File>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            String sql = paramStatement.getSql();
            stmt = con.prepareStatement(sql);
            List values = paramStatement.getValues();
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                stmt.setObject(i + 1, values.get(i));
            }
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                imageFiles.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                imageFiles.clear();
            }
            catch (Throwable throwable) {
                FindDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            FindDatabase.close(rs, stmt);
            this.free(con);
        }
        FindDatabase.close(rs, stmt);
        this.free(con);
        return imageFiles;
    }

    List<File> findImageFilesLikeOr(List<MetaDataValue> searchColumns, String searchString) {
        if (searchColumns == null) {
            throw new NullPointerException("searchColumns == null");
        }
        if (searchString == null) {
            throw new NullPointerException("searchString == null");
        }
        ArrayList<File> imageFiles = new ArrayList<File>();
        Map<String, List<MetaDataValue>> columnsOfTable = this.getColumnsSeparatedByTables(searchColumns);
        for (String tablename : columnsOfTable.keySet()) {
            this.addImageFilesSearchImageFilesLikeOr(columnsOfTable.get(tablename), searchString, imageFiles, tablename);
        }
        return imageFiles;
    }

    private Map<String, List<MetaDataValue>> getColumnsSeparatedByTables(Collection<? extends MetaDataValue> columns) {
        if (columns == null) {
            throw new NullPointerException("columns == null");
        }
        HashMap<String, List<MetaDataValue>> columnsOfTable = new HashMap<String, List<MetaDataValue>>();
        for (MetaDataValue metaDataValue : columns) {
            String tablename = metaDataValue.getCategory();
            ArrayList<MetaDataValue> cols = (ArrayList<MetaDataValue>)columnsOfTable.get(tablename);
            if (cols == null) {
                cols = new ArrayList<MetaDataValue>();
            }
            cols.add(metaDataValue);
            columnsOfTable.put(tablename, cols);
        }
        return columnsOfTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImageFilesSearchImageFilesLikeOr(List<MetaDataValue> searchColumns, String searchString, List<File> imageFiles, String tablename) {
        if (searchColumns.size() > 0) {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement(this.getSqlFindImageFilesLikeOr(searchColumns, tablename, searchString));
                for (int i = 0; i < searchColumns.size(); ++i) {
                    stmt.setString(i + 1, "%" + searchString + "%");
                }
                this.addSynonyms(searchColumns, searchString, stmt);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    File imageFile = new File(rs.getString(1));
                    if (imageFiles.contains(imageFile)) continue;
                    imageFiles.add(imageFile);
                }
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    imageFiles.clear();
                }
                catch (Throwable throwable) {
                    FindDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                FindDatabase.close(rs, stmt);
                this.free(con);
            }
            FindDatabase.close(rs, stmt);
            this.free(con);
        }
    }

    private void addSynonyms(List<MetaDataValue> searchColumns, String searchString, PreparedStatement stmt) throws SQLException {
        if (searchColumns.contains(XmpDcSubjectsSubjectMetaDataValue.INSTANCE)) {
            int paramIndex = searchColumns.size() + 1;
            SynonymsRepository synonymsRepo = (SynonymsRepository)Lookup.getDefault().lookup(SynonymsRepository.class);
            for (String synonym : synonymsRepo.findSynonymsOfWord(searchString)) {
                stmt.setString(paramIndex++, synonym);
            }
        }
    }

    private String getSqlFindImageFilesLikeOr(List<MetaDataValue> searchColumns, String tablename, String searchString) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT files.filename FROM ");
        sql.append("files").append(Join.getJoinToFiles((String)tablename, (Join.Type)Join.Type.INNER)).append(" WHERE ");
        boolean isFirstColumn = true;
        for (MetaDataValue column : searchColumns) {
            sql.append(!isFirstColumn ? " OR " : "").append(column.getCategory()).append(".").append(column.getValueName()).append(" LIKE ?");
            isFirstColumn = false;
        }
        if (searchColumns.contains(XmpDcSubjectsSubjectMetaDataValue.INSTANCE)) {
            this.addSynonyms(sql, searchString);
        }
        sql.append(" ORDER BY files.filename ASC");
        return sql.toString();
    }

    private void addSynonyms(StringBuilder sb, String searchString) {
        SynonymsRepository synonymsRepo = (SynonymsRepository)Lookup.getDefault().lookup(SynonymsRepository.class);
        int count = synonymsRepo.findSynonymsOfWord(searchString).size();
        String colName = XmpDcSubjectsSubjectMetaDataValue.INSTANCE.getCategory() + "." + XmpDcSubjectsSubjectMetaDataValue.INSTANCE.getValueName();
        for (int i = 0; i < count; ++i) {
            sb.append(" OR ");
            sb.append(colName);
            sb.append(" = ?");
        }
    }
}

