/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.repository.RepositoryStatistics;
import org.jphototagger.domain.repository.ThumbnailsRepository;
import org.jphototagger.domain.repository.event.fileexcludepattern.FileExcludePatternDeletedEvent;
import org.jphototagger.domain.repository.event.fileexcludepattern.FileExcludePatternInsertedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileDeletedEvent;
import org.jphototagger.repository.hsqldb.Database;
import org.openide.util.Lookup;

final class FileExcludePatternsDatabase
extends Database {
    static final FileExcludePatternsDatabase INSTANCE = new FileExcludePatternsDatabase();
    private static final Logger LOGGER = Logger.getLogger(FileExcludePatternsDatabase.class.getName());

    private FileExcludePatternsDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertFileExcludePattern(String pattern) {
        PreparedStatement stmt;
        Connection con;
        boolean inserted;
        block5: {
            if (pattern == null) {
                throw new NullPointerException("pattern == null");
            }
            inserted = false;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("INSERT INTO file_exclude_patterns (pattern) VALUES (?)");
                stmt.setString(1, pattern);
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = inserted = count > 0;
                if (!inserted) break block5;
                this.notifyInserted(pattern);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    FileExcludePatternsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    FileExcludePatternsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                FileExcludePatternsDatabase.close(stmt);
                this.free(con);
            }
        }
        FileExcludePatternsDatabase.close(stmt);
        this.free(con);
        return inserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteFileExcludePattern(String pattern) {
        PreparedStatement stmt;
        Connection con;
        boolean deleted;
        block5: {
            if (pattern == null) {
                throw new NullPointerException("pattern == null");
            }
            deleted = false;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("DELETE FROM file_exclude_patterns WHERE pattern = ?");
                stmt.setString(1, pattern);
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = deleted = count > 0;
                if (!deleted) break block5;
                this.notifyDeleted(pattern);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    FileExcludePatternsDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    FileExcludePatternsDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                FileExcludePatternsDatabase.close(stmt);
                this.free(con);
            }
        }
        FileExcludePatternsDatabase.close(stmt);
        this.free(con);
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsFileExcludePattern(String pattern) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (pattern == null) {
                throw new NullPointerException("pattern == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM file_exclude_patterns WHERE pattern = ?");
                stmt.setString(1, pattern);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    FileExcludePatternsDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                FileExcludePatternsDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        FileExcludePatternsDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getAllFileExcludePatterns() {
        LinkedList<String> patterns = new LinkedList<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            String sql = "SELECT pattern FROM file_exclude_patterns ORDER BY pattern ASC";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                patterns.add(rs.getString(1));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                FileExcludePatternsDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            FileExcludePatternsDatabase.close(rs, stmt);
            this.free(con);
        }
        FileExcludePatternsDatabase.close(rs, stmt);
        this.free(con);
        return patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteMatchingFiles(List<String> patterns, ProgressListener listener) {
        if (patterns == null) {
            throw new NullPointerException("patterns == null");
        }
        int count = 0;
        Connection con = null;
        PreparedStatement stmtUpdate = null;
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            LinkedList<String> deletedFiles = new LinkedList<String>();
            String sqlUpdate = "DELETE FROM files WHERE filename = ?";
            String sqlQuery = "SELECT filename FROM files";
            stmtQuery = con.createStatement();
            stmtUpdate = con.prepareStatement(sqlUpdate);
            LOGGER.log(Level.FINEST, sqlQuery);
            rs = stmtQuery.executeQuery(sqlQuery);
            int patternCount = patterns.size();
            int progress = 0;
            RepositoryStatistics repoStatistics = (RepositoryStatistics)Lookup.getDefault().lookup(RepositoryStatistics.class);
            ProgressEvent event = new ProgressEvent.Builder().source((Object)this).minimum(0).maximum(repoStatistics.getFileCount() * patternCount).value(0).build();
            ThumbnailsRepository tnRepo = (ThumbnailsRepository)Lookup.getDefault().lookup(ThumbnailsRepository.class);
            this.notifyProgressListenerStart(listener, event);
            boolean cancel = event.isCancel();
            while (!cancel && rs.next()) {
                String filepath = rs.getString(1);
                for (int i = 0; !cancel && i < patternCount; ++i) {
                    ++progress;
                    String pattern = patterns.get(i);
                    if (filepath.matches(pattern)) {
                        stmtUpdate.setString(1, filepath);
                        deletedFiles.add(filepath);
                        LOGGER.log(Level.FINER, stmtUpdate.toString());
                        int affectedRows = stmtUpdate.executeUpdate();
                        count += affectedRows;
                        if (affectedRows > 0) {
                            File imageFile = new File(filepath);
                            tnRepo.deleteThumbnail(imageFile);
                            EventBus.publish((Object)new ImageFileDeletedEvent((Object)this, imageFile));
                        }
                        cancel = event.isCancel();
                    }
                    event.setInfo((Object)filepath);
                    event.setValue(progress);
                    this.notifyProgressListenerPerformed(listener, event);
                }
            }
            con.commit();
            this.notifyProgressListenerEnd(listener, event);
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                FileExcludePatternsDatabase.rollback(con);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                FileExcludePatternsDatabase.close(rs, stmtQuery);
                FileExcludePatternsDatabase.close(stmtUpdate);
                this.free(con);
            }
        }
        FileExcludePatternsDatabase.close(rs, stmtQuery);
        FileExcludePatternsDatabase.close(stmtUpdate);
        this.free(con);
        return count;
    }

    private void notifyInserted(String pattern) {
        EventBus.publish((Object)new FileExcludePatternInsertedEvent((Object)this, pattern));
    }

    private void notifyDeleted(String pattern) {
        EventBus.publish((Object)new FileExcludePatternDeletedEvent((Object)this, pattern));
    }
}

