/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.favorites.Favorite;
import org.jphototagger.domain.repository.event.favorites.FavoriteDeletedEvent;
import org.jphototagger.domain.repository.event.favorites.FavoriteInsertedEvent;
import org.jphototagger.domain.repository.event.favorites.FavoriteUpdatedEvent;
import org.jphototagger.repository.hsqldb.Database;

final class FavoritesDatabase
extends Database {
    static final FavoritesDatabase INSTANCE = new FavoritesDatabase();
    private static final Logger LOGGER = Logger.getLogger(FavoritesDatabase.class.getName());

    private FavoritesDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertOrUpdateFavorite(Favorite favorite) {
        PreparedStatement stmt;
        Connection con;
        boolean inserted;
        block7: {
            block6: {
                if (favorite == null) {
                    throw new NullPointerException("favorite == null");
                }
                inserted = false;
                con = null;
                stmt = null;
                if (!this.existsFavorite(favorite.getName())) break block6;
                boolean bl = this.updateFavorite(favorite);
                FavoritesDatabase.close(stmt);
                this.free(con);
                return bl;
            }
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("INSERT INTO favorite_directories (favorite_name, directory_name, favorite_index) VALUES (?, ?, ?)");
                stmt.setString(1, favorite.getName());
                stmt.setString(2, favorite.getDirectory().getAbsolutePath());
                stmt.setInt(3, favorite.getIndex());
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = inserted = count > 0;
                if (!inserted) break block7;
                favorite.setId(this.findIdByFavoriteName(favorite.getName()));
                this.notifyInserted(favorite);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    FavoritesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    FavoritesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                FavoritesDatabase.close(stmt);
                this.free(con);
            }
        }
        FavoritesDatabase.close(stmt);
        this.free(con);
        return inserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteFavorite(String favoriteName) {
        PreparedStatement stmt;
        Connection con;
        boolean deleted;
        block6: {
            if (favoriteName == null) {
                throw new NullPointerException("favoriteName == null");
            }
            deleted = false;
            con = null;
            stmt = null;
            try {
                Favorite delFavorite = this.find(favoriteName);
                con = this.getConnection();
                con.setAutoCommit(false);
                stmt = con.prepareStatement("DELETE FROM favorite_directories WHERE favorite_name = ?");
                stmt.setString(1, favoriteName);
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = deleted = count > 0;
                if (!deleted || delFavorite == null) break block6;
                this.notifyDeleted(delFavorite);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    FavoritesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    FavoritesDatabase.close(stmt);
                    this.free(con);
                }
            }
        }
        FavoritesDatabase.close(stmt);
        this.free(con);
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateRenameFavorite(String fromFavoriteName, String toFavoriteName) {
        if (fromFavoriteName == null) {
            throw new NullPointerException("fromFavoriteName == null");
        }
        if (toFavoriteName == null) {
            throw new NullPointerException("toFavoriteName == null");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int count = 0;
        try {
            Favorite oldFavorite = this.find(fromFavoriteName);
            Connection con = this.getConnection();
            con.setAutoCommit(true);
            String sql = "UPDATE favorite_directories SET favorite_name = ? WHERE favorite_name = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, toFavoriteName);
            stmt.setString(2, fromFavoriteName);
            LOGGER.log(Level.FINER, stmt.toString());
            count = stmt.executeUpdate();
            if (count > 0) {
                this.notifyUpdated(oldFavorite, this.find(toFavoriteName));
            }
            FavoritesDatabase.close(rs, stmt);
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            FavoritesDatabase.close(rs, stmt);
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateFavorite(Favorite favorite) {
        PreparedStatement stmt;
        Connection con;
        boolean updated;
        block6: {
            if (favorite == null) {
                throw new NullPointerException("favorite == null");
            }
            updated = false;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                Favorite oldFavorite = this.find(favorite.getId());
                stmt = con.prepareStatement("UPDATE favorite_directories SET favorite_name = ?, directory_name = ?, favorite_index = ? WHERE id = ?");
                stmt.setString(1, favorite.getName());
                stmt.setString(2, favorite.getDirectory().getAbsolutePath());
                stmt.setInt(3, favorite.getIndex());
                stmt.setLong(4, favorite.getId());
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                con.commit();
                boolean bl = updated = count > 0;
                if (!updated) break block6;
                this.notifyUpdated(oldFavorite, favorite);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                    FavoritesDatabase.rollback(con);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    FavoritesDatabase.close(stmt);
                    this.free(con);
                }
            }
        }
        FavoritesDatabase.close(stmt);
        this.free(con);
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Favorite> getAllFavorites() {
        ArrayList<Favorite> favorites = new ArrayList<Favorite>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            String sql = "SELECT id, favorite_name, directory_name, favorite_index FROM favorite_directories ORDER BY favorite_index ASC";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Favorite favorite = new Favorite();
                favorite.setId(Long.valueOf(rs.getLong(1)));
                favorite.setName(rs.getString(2));
                favorite.setDirectory(new File(rs.getString(3)));
                favorite.setIndex(rs.getInt(4));
                favorites.add(favorite);
            }
        }
        catch (Throwable t) {
            try {
                favorites.clear();
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                FavoritesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            FavoritesDatabase.close(rs, stmt);
            this.free(con);
        }
        FavoritesDatabase.close(rs, stmt);
        this.free(con);
        return favorites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Favorite find(Long id) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        Favorite favorite;
        block4: {
            favorite = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT id, favorite_name, directory_name, favorite_index FROM favorite_directories WHERE id = ?");
                stmt.setLong(1, id);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                favorite = new Favorite();
                favorite.setId(Long.valueOf(rs.getLong(1)));
                favorite.setName(rs.getString(2));
                favorite.setDirectory(new File(rs.getString(3)));
                favorite.setIndex(rs.getInt(4));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    FavoritesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                FavoritesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        FavoritesDatabase.close(rs, stmt);
        this.free(con);
        return favorite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Favorite find(String favoriteName) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        Favorite favorite;
        block4: {
            favorite = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT id, favorite_name, directory_name, favorite_index FROM favorite_directories WHERE favorite_name = ?");
                stmt.setString(1, favoriteName);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                favorite = new Favorite();
                favorite.setId(Long.valueOf(rs.getLong(1)));
                favorite.setName(rs.getString(2));
                favorite.setDirectory(new File(rs.getString(3)));
                favorite.setIndex(rs.getInt(4));
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    FavoritesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                FavoritesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        FavoritesDatabase.close(rs, stmt);
        this.free(con);
        return favorite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long findIdByFavoriteName(String favoriteName) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        Long id;
        block4: {
            id = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT id FROM favorite_directories WHERE favorite_name = ?");
                stmt.setString(1, favoriteName);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                id = rs.getLong(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    FavoritesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                FavoritesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        FavoritesDatabase.close(rs, stmt);
        this.free(con);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsFavorite(String favoriteName) {
        if (favoriteName == null) {
            throw new NullPointerException("favoriteName == null");
        }
        boolean exists = false;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement("SELECT COUNT(*) FROM favorite_directories WHERE favorite_name = ?");
            stmt.setString(1, favoriteName);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            exists = count > 0;
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                FavoritesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            FavoritesDatabase.close(rs, stmt);
            this.free(con);
        }
        FavoritesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    private void notifyInserted(Favorite favorite) {
        EventBus.publish((Object)new FavoriteInsertedEvent((Object)this, favorite));
    }

    private void notifyDeleted(Favorite favorite) {
        EventBus.publish((Object)new FavoriteDeletedEvent((Object)this, favorite));
    }

    private void notifyUpdated(Favorite oldFavorite, Favorite updatedFavorite) {
        EventBus.publish((Object)new FavoriteUpdatedEvent((Object)this, oldFavorite, updatedFavorite));
    }
}

