/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.repository.hsqldb.Database;

final class DatabaseStatistics
extends Database {
    static final DatabaseStatistics INSTANCE = new DatabaseStatistics();
    private static final Logger LOGGER = Logger.getLogger(DatabaseStatistics.class.getName());

    private DatabaseStatistics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCountOfMetaDataValue(MetaDataValue metaDataValue) {
        ResultSet rs;
        Statement stmt;
        Connection con;
        int count;
        block5: {
            if (metaDataValue == null) {
                throw new NullPointerException("metaDataValue == null");
            }
            count = -1;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.createStatement();
                String sql = "SELECT COUNT(*) FROM " + metaDataValue.getCategory() + " WHERE " + metaDataValue.getValueName() + " IS NOT NULL";
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block5;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    DatabaseStatistics.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                DatabaseStatistics.close(rs, stmt);
                this.free(con);
            }
        }
        DatabaseStatistics.close(rs, stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFileCount() {
        ResultSet rs;
        Statement stmt;
        Connection con;
        int count;
        block4: {
            count = -1;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.createStatement();
                String sql = "SELECT COUNT(*) FROM files";
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    DatabaseStatistics.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                DatabaseStatistics.close(rs, stmt);
                this.free(con);
            }
        }
        DatabaseStatistics.close(rs, stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getXmpCount() {
        ResultSet rs;
        Statement stmt;
        Connection con;
        int count;
        block4: {
            count = -1;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.createStatement();
                String sql = "SELECT COUNT(*) FROM xmp LEFT JOIN files ON xmp.id_file = files.id";
                LOGGER.log(Level.FINEST, sql);
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block4;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    DatabaseStatistics.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                DatabaseStatistics.close(rs, stmt);
                this.free(con);
            }
        }
        DatabaseStatistics.close(rs, stmt);
        this.free(con);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsValueInMetaDataValues(String value, List<MetaDataValue> metaDataValues) {
        if (metaDataValues == null) {
            throw new NullPointerException("columns == null");
        }
        boolean exists = false;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            int size = metaDataValues.size();
            for (int i = 0; !exists && i < size; ++i) {
                MetaDataValue column = metaDataValues.get(i);
                stmt = con.prepareStatement("SELECT COUNT(*) FROM " + column.getCategory() + " WHERE " + column.getValueName() + " = ?");
                stmt.setString(1, value);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    exists = rs.getInt(1) > 0;
                }
                rs.close();
                stmt.close();
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
        finally {
            DatabaseStatistics.close(rs, stmt);
            this.free(con);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsMetaDataValue(MetaDataValue metaDataValue, String value) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        int count;
        block6: {
            if (metaDataValue == null) {
                throw new NullPointerException("metaDataValue == null");
            }
            count = 0;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM " + metaDataValue.getCategory() + " WHERE " + metaDataValue.getValueName() + " = ?");
                stmt.setString(1, value);
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                count = rs.getInt(1);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DatabaseStatistics.close(rs, stmt);
                    this.free(con);
                }
            }
        }
        DatabaseStatistics.close(rs, stmt);
        this.free(con);
        return count > 0;
    }
}

