/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.repository.hsqldb.ConnectionPool;
import org.jphototagger.repository.hsqldb.Database;

final class DatabaseMaintainance
extends Database {
    static final DatabaseMaintainance INSTANCE = new DatabaseMaintainance();
    private static final Logger LOGGER = Logger.getLogger(DatabaseMaintainance.class.getName());
    private static final List<Ref1nInfo> REF_1_N_INFOS = new ArrayList<Ref1nInfo>();

    private DatabaseMaintainance() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        if (!ConnectionPool.INSTANCE.isInit()) {
            return;
        }
        Connection con = null;
        Statement stmt = null;
        boolean shutdown = false;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.createStatement();
            LOGGER.log(Level.INFO, "Closing the database");
            stmt.executeUpdate("SHUTDOWN");
            shutdown = true;
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                String message = Bundle.getString(DatabaseMaintainance.class, (String)"DatabaseMaintainance.Error.Shutdown", (Object[])new Object[0]);
                MessageDisplayer.error(null, (String)message);
            }
            catch (Throwable throwable) {
                DatabaseMaintainance.close(stmt);
                this.free(con);
                if (shutdown) {
                    ConnectionPool.INSTANCE.closeAllConnections();
                    ConnectionPool.INSTANCE.setShutdown();
                }
                throw throwable;
            }
            DatabaseMaintainance.close(stmt);
            this.free(con);
            if (shutdown) {
                ConnectionPool.INSTANCE.closeAllConnections();
                ConnectionPool.INSTANCE.setShutdown();
            }
        }
        DatabaseMaintainance.close(stmt);
        this.free(con);
        if (shutdown) {
            ConnectionPool.INSTANCE.closeAllConnections();
            ConnectionPool.INSTANCE.setShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean compressDatabase() {
        boolean success = false;
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.createStatement();
            stmt.executeUpdate("CHECKPOINT DEFRAG");
            success = true;
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                DatabaseMaintainance.close(stmt);
                this.free(con);
                throw throwable;
            }
            DatabaseMaintainance.close(stmt);
            this.free(con);
        }
        DatabaseMaintainance.close(stmt);
        this.free(con);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteNotReferenced1n() {
        String sqlTemplate = "DELETE FROM {0} WHERE ID NOT IN (SELECT DISTINCT {1} from {2})";
        Connection con = null;
        Statement stmt = null;
        int deleted = 0;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.createStatement();
            for (Ref1nInfo info : REF_1_N_INFOS) {
                String sql = MessageFormat.format(sqlTemplate, info.getTable(), info.getRefColumn(), info.getRefTable());
                LOGGER.log(Level.FINER, sql);
                deleted += stmt.executeUpdate(sql);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
            }
            catch (Throwable throwable) {
                DatabaseMaintainance.close(stmt);
                this.free(con);
                throw throwable;
            }
            DatabaseMaintainance.close(stmt);
            this.free(con);
        }
        DatabaseMaintainance.close(stmt);
        this.free(con);
        return deleted;
    }

    static {
        REF_1_N_INFOS.add(new Ref1nInfo("dc_creators", "xmp", "id_dc_creator"));
        REF_1_N_INFOS.add(new Ref1nInfo("dc_rights", "xmp", "id_dc_rights"));
        REF_1_N_INFOS.add(new Ref1nInfo("iptc4xmpcore_locations", "xmp", "id_iptc4xmpcore_location"));
        REF_1_N_INFOS.add(new Ref1nInfo("photoshop_authorspositions", "xmp", "id_photoshop_authorsposition"));
        REF_1_N_INFOS.add(new Ref1nInfo("photoshop_captionwriters", "xmp", "id_photoshop_captionwriter"));
        REF_1_N_INFOS.add(new Ref1nInfo("photoshop_cities", "xmp", "id_photoshop_city"));
        REF_1_N_INFOS.add(new Ref1nInfo("photoshop_countries", "xmp", "id_photoshop_country"));
        REF_1_N_INFOS.add(new Ref1nInfo("photoshop_credits", "xmp", "id_photoshop_credit"));
        REF_1_N_INFOS.add(new Ref1nInfo("photoshop_sources", "xmp", "id_photoshop_source"));
        REF_1_N_INFOS.add(new Ref1nInfo("photoshop_states", "xmp", "id_photoshop_state"));
        REF_1_N_INFOS.add(new Ref1nInfo("exif_recording_equipment", "exif", "id_exif_recording_equipment"));
        REF_1_N_INFOS.add(new Ref1nInfo("exif_lenses", "exif", "id_exif_lens"));
    }

    private static class Ref1nInfo {
        private final String table;
        private final String refTable;
        private final String refColumn;

        Ref1nInfo(String table, String refTable, String refColumn) {
            this.table = table;
            this.refColumn = refColumn;
            this.refTable = refTable;
        }

        public String getRefColumn() {
            return this.refColumn;
        }

        public String getRefTable() {
            return this.refTable;
        }

        public String getTable() {
            return this.table;
        }
    }
}

