/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.repository.hsqldb.ConnectionPool;

public class Database {
    private static final Logger LOGGER = Logger.getLogger(Database.class.getName());

    protected Database() {
    }

    public static boolean execute(Connection con, String sql) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con == null");
        }
        if (sql == null) {
            throw new NullPointerException("sql == null");
        }
        boolean isResultSet = false;
        try (Statement stmt = null;){
            stmt = con.createStatement();
            LOGGER.log(Level.FINER, sql);
            isResultSet = stmt.execute(sql);
        }
        return isResultSet;
    }

    protected Connection getConnection() throws SQLException {
        return ConnectionPool.INSTANCE.getConnection();
    }

    protected void free(Connection con) {
        if (con == null) {
            return;
        }
        try {
            ConnectionPool.INSTANCE.free(con);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
    }

    public static void close(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public static void close(PreparedStatement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public static void close(ResultSet rs, Statement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public static void close(ResultSet rs, PreparedStatement stmt) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public static void rollback(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.rollback();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getId(Connection con, String tablename, String columnName, String value) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con == null");
        }
        if (tablename == null) {
            throw new NullPointerException("tablename == null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName == null");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Long id = null;
        if (value == null) {
            return null;
        }
        try {
            String sql = "SELECT id FROM " + tablename + " WHERE " + columnName + " = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, value);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            Database.close(rs, stmt);
            throw throwable;
        }
        Database.close(rs, stmt);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getId(String tablename, String columnName, String value) throws SQLException {
        if (tablename == null) {
            throw new NullPointerException("tablename == null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName == null");
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Long id = null;
        if (value == null) {
            return null;
        }
        try {
            String sql = "SELECT id FROM " + tablename + " WHERE " + columnName + " = ?";
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, value);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            Database.close(rs, stmt);
            this.free(con);
            throw throwable;
        }
        Database.close(rs, stmt);
        this.free(con);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long ensureValueExists(String tablename, String columnName, String value) throws SQLException {
        if (tablename == null) {
            throw new NullPointerException("tablename == null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName == null");
        }
        if (value == null) {
            return null;
        }
        Long id = this.getId(tablename, columnName, value);
        if (id == null) {
            PreparedStatement stmt = null;
            Connection con = null;
            try {
                String sql = "INSERT INTO " + tablename + " (" + columnName + ") VALUES (?)";
                con = this.getConnection();
                con.setAutoCommit(true);
                stmt = con.prepareStatement(sql);
                stmt.setString(1, value);
                LOGGER.log(Level.FINER, stmt.toString());
                stmt.executeUpdate();
                id = this.getId(tablename, columnName, value);
            }
            catch (Throwable throwable) {
                Database.close(stmt);
                this.free(con);
                throw throwable;
            }
            Database.close(stmt);
            this.free(con);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCount(Connection con, String tablename, String columnName, String value) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con == null");
        }
        if (tablename == null) {
            throw new NullPointerException("tablename == null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName == null");
        }
        long count = 0L;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT COUNT(*) FROM " + tablename + " WHERE " + columnName + " = ?");
            stmt.setString(1, value);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                count = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            Database.close(rs, stmt);
            throw throwable;
        }
        Database.close(rs, stmt);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCount(Connection con, String tablename, String columnName, long value) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con == null");
        }
        if (tablename == null) {
            throw new NullPointerException("tablename == null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName == null");
        }
        long count = 0L;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT COUNT(*) FROM " + tablename + " WHERE " + columnName + " = ?");
            stmt.setLong(1, value);
            LOGGER.log(Level.FINEST, stmt.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                count = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            Database.close(rs, stmt);
            throw throwable;
        }
        Database.close(rs, stmt);
        return count;
    }

    public static boolean exists(Connection con, String tablename, String columnName, String value) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con == null");
        }
        if (tablename == null) {
            throw new NullPointerException("tablename == null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName == null");
        }
        return Database.getCount(con, tablename, columnName, value) > 0L;
    }

    protected Double getDouble(ResultSet rs, int colIndex) throws SQLException {
        if (rs == null) {
            throw new NullPointerException("rs == null");
        }
        double d = rs.getDouble(colIndex);
        if (rs.wasNull()) {
            return null;
        }
        return d;
    }

    protected Short getShort(ResultSet rs, int colIndex) throws SQLException {
        if (rs == null) {
            throw new NullPointerException("rs == null");
        }
        short s = rs.getShort(colIndex);
        if (rs.wasNull()) {
            return null;
        }
        return s;
    }

    protected Integer getInt(ResultSet rs, int colIndex) throws SQLException {
        if (rs == null) {
            throw new NullPointerException("rs == null");
        }
        int i = rs.getInt(colIndex);
        if (rs.wasNull()) {
            return null;
        }
        return i;
    }

    protected Long getLong(ResultSet rs, int colIndex) throws SQLException {
        if (rs == null) {
            throw new NullPointerException("rs == null");
        }
        long l = rs.getLong(colIndex);
        if (rs.wasNull()) {
            return null;
        }
        return l;
    }

    protected Long getLongMinMax(ResultSet rs, int colIndex, long min, long max) throws SQLException {
        if (rs == null) {
            throw new NullPointerException("rs == null");
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max!");
        }
        long l = rs.getLong(colIndex);
        if (rs.wasNull()) {
            return null;
        }
        return l < min ? min : (l > max ? max : l);
    }

    protected String getString(ResultSet rs, int colIndex) throws SQLException {
        if (rs == null) {
            throw new NullPointerException("rs == null");
        }
        String s = rs.getString(colIndex);
        if (rs.wasNull()) {
            return null;
        }
        return s;
    }

    protected Class<?> getClassFromName(ResultSet rs, int colIndex) throws SQLException {
        if (rs == null) {
            throw new NullPointerException("rs == null");
        }
        String classname = rs.getString(colIndex);
        if (classname == null) {
            return null;
        }
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    protected Date getDate(ResultSet rs, int colIndex) throws SQLException {
        if (rs == null) {
            throw new NullPointerException("rs == null");
        }
        Date d = rs.getDate(colIndex);
        if (rs.wasNull()) {
            return null;
        }
        return d;
    }

    protected void setBoolean(Boolean value, PreparedStatement stmt, int paramIndex) throws SQLException {
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        if (value == null) {
            stmt.setNull(paramIndex, 16);
        } else {
            stmt.setBoolean(paramIndex, value);
        }
    }

    protected void setDouble(Double value, PreparedStatement stmt, int paramIndex) throws SQLException {
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        if (value == null) {
            stmt.setNull(paramIndex, 8);
        } else {
            stmt.setDouble(paramIndex, value);
        }
    }

    protected void setShort(Short value, PreparedStatement stmt, int paramIndex) throws SQLException {
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        if (value == null) {
            stmt.setNull(paramIndex, 5);
        } else {
            stmt.setShort(paramIndex, value);
        }
    }

    protected void setInt(Integer value, PreparedStatement stmt, int paramIndex) throws SQLException {
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        if (value == null) {
            stmt.setNull(paramIndex, 4);
        } else {
            stmt.setInt(paramIndex, value);
        }
    }

    protected void setLong(Long value, PreparedStatement stmt, int paramIndex) throws SQLException {
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        if (value == null) {
            stmt.setNull(paramIndex, -5);
        } else {
            stmt.setLong(paramIndex, value);
        }
    }

    protected void setString(String value, PreparedStatement stmt, int paramIndex) throws SQLException {
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        if (value == null) {
            stmt.setNull(paramIndex, 12);
        } else {
            stmt.setString(paramIndex, value);
        }
    }

    protected void setClassname(Class<?> clazz, PreparedStatement stmt, int paramIndex) throws SQLException {
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        if (clazz == null) {
            stmt.setNull(paramIndex, 12);
        } else {
            stmt.setString(paramIndex, clazz.getName());
        }
    }

    protected void setDate(Date value, PreparedStatement stmt, int paramIndex) throws SQLException {
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        if (value == null) {
            stmt.setNull(paramIndex, 91);
        } else {
            stmt.setDate(paramIndex, value);
        }
    }

    protected void setBoolean(Object value, PreparedStatement stmt, int paramIndex) throws SQLException {
        boolean isBoolean;
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        boolean bl = isBoolean = value == null || value instanceof Boolean;
        if (!isBoolean) {
            throw new IllegalArgumentException("Not a Boolean: " + value);
        }
        if (value == null) {
            stmt.setNull(paramIndex, 16);
        } else {
            stmt.setBoolean(paramIndex, (Boolean)value);
        }
    }

    protected void setDouble(Object value, PreparedStatement stmt, int paramIndex) throws SQLException {
        boolean isDouble;
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        boolean bl = isDouble = value == null || value instanceof Double;
        if (!isDouble) {
            throw new IllegalArgumentException("Not a Double: " + value);
        }
        if (value == null) {
            stmt.setNull(paramIndex, 8);
        } else {
            stmt.setDouble(paramIndex, (Double)value);
        }
    }

    protected void setShort(Object value, PreparedStatement stmt, int paramIndex) throws SQLException {
        boolean isShort;
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        boolean bl = isShort = value == null || value instanceof Short;
        if (!isShort) {
            throw new IllegalArgumentException("Not a Short: " + value);
        }
        if (value == null) {
            stmt.setNull(paramIndex, 5);
        } else {
            stmt.setShort(paramIndex, (Short)value);
        }
    }

    protected void setInt(Object value, PreparedStatement stmt, int paramIndex) throws SQLException {
        boolean isInteger;
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        boolean bl = isInteger = value == null || value instanceof Integer;
        if (!isInteger) {
            throw new IllegalArgumentException("Not an Integer: " + value);
        }
        if (value == null) {
            stmt.setNull(paramIndex, 4);
        } else {
            stmt.setInt(paramIndex, (Integer)value);
        }
    }

    protected void setLong(Object value, PreparedStatement stmt, int paramIndex) throws SQLException {
        boolean isLong;
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        boolean bl = isLong = value == null || value instanceof Long;
        if (!isLong) {
            throw new IllegalArgumentException("Not a Long: " + value);
        }
        if (value == null) {
            stmt.setNull(paramIndex, -5);
        } else {
            stmt.setLong(paramIndex, (Long)value);
        }
    }

    protected void setLongMinMax(Object value, long min, long max, PreparedStatement stmt, int paramIndex) throws SQLException {
        boolean isLong;
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        boolean bl = isLong = value == null || value instanceof Long;
        if (!isLong) {
            throw new IllegalArgumentException("Not a Long: " + value);
        }
        if (value == null) {
            stmt.setNull(paramIndex, -5);
        } else {
            Long v = (Long)value;
            stmt.setLong(paramIndex, v < min ? min : (v > max ? max : v));
        }
    }

    protected void setString(Object value, PreparedStatement stmt, int paramIndex) throws SQLException {
        boolean isString;
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        boolean bl = isString = value == null || value instanceof String;
        if (!isString) {
            throw new IllegalArgumentException("Not a string: " + value);
        }
        if (value == null) {
            stmt.setNull(paramIndex, 12);
        } else {
            stmt.setString(paramIndex, (String)value);
        }
    }

    protected void setDate(Object value, PreparedStatement stmt, int paramIndex) throws SQLException {
        boolean isDate;
        if (stmt == null) {
            throw new NullPointerException("stmt == null");
        }
        boolean bl = isDate = value == null || value instanceof Date;
        if (!isDate) {
            throw new IllegalArgumentException("Not a Date: " + value);
        }
        if (value == null) {
            stmt.setNull(paramIndex, 91);
        } else {
            stmt.setDate(paramIndex, (Date)value);
        }
    }

    protected boolean notifyProgressListenerStart(ProgressListener listener, ProgressEvent event) {
        if (listener != null) {
            listener.progressStarted(event);
            return event.isCancel();
        }
        return false;
    }

    protected boolean notifyProgressListenerPerformed(ProgressListener listener, ProgressEvent event) {
        if (listener != null) {
            listener.progressPerformed(event);
            return event.isCancel();
        }
        return false;
    }

    protected void notifyProgressListenerEnd(ProgressListener listener, ProgressEvent event) {
        if (listener != null) {
            listener.progressEnded(event);
        }
    }

    static String createParametersString(int parameterCount) {
        if (parameterCount < 1) {
            throw new IllegalArgumentException("Parameter count less than 1: " + parameterCount);
        }
        StringBuilder sb = new StringBuilder();
        for (int parameterIndex = 0; parameterIndex < parameterCount; ++parameterIndex) {
            sb.append(parameterIndex == 0 ? "" : ", ");
            sb.append("?");
        }
        return sb.toString();
    }
}

