/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.file.FilenameTokens;
import org.jphototagger.domain.repository.FileRepositoryProvider;
import org.openide.util.Lookup;

public final class ConnectionPool
implements Runnable {
    public static final ConnectionPool INSTANCE = new ConnectionPool();
    private static final Logger LOGGER = Logger.getLogger(ConnectionPool.class.getName());
    private static final int INITIAL_CONNECTIONS = 3;
    private static final int MAX_CONNECTIONS = 15;
    private final LinkedList<Connection> availableConnections = new LinkedList();
    private final LinkedList<Connection> busyConnections = new LinkedList();
    private final boolean waitForFreeConnectionIfBusy = true;
    private boolean connectionPending = false;
    private volatile boolean init;
    private String driver;
    private String url;
    private String password;
    private String username;

    synchronized boolean isInit() {
        return this.init;
    }

    synchronized void init() throws SQLException {
        if (this.init) {
            return;
        }
        this.setConnectionUrlTokens();
        try {
            for (int i = 0; i < 3; ++i) {
                this.availableConnections.add(this.makeNewConnection());
            }
        }
        catch (SQLException e) {
            this.closeAllConnections();
            throw e;
        }
        this.init = true;
    }

    private void setConnectionUrlTokens() {
        this.driver = "org.hsqldb.jdbcDriver";
        this.url = this.createUrl();
        this.username = "sa";
        this.password = "";
    }

    private String createUrl() {
        FileRepositoryProvider provider = (FileRepositoryProvider)Lookup.getDefault().lookup(FileRepositoryProvider.class);
        String file = provider.getFileRepositoryFileName(FilenameTokens.FULL_PATH_NO_SUFFIX);
        return "jdbc:hsqldb:file:" + file + ";shutdown=true";
    }

    synchronized Connection getConnection() throws SQLException {
        this.ensureInit();
        if (!this.availableConnections.isEmpty()) {
            Connection existingConnection = this.availableConnections.pollLast();
            if (existingConnection.isClosed()) {
                this.notifyAll();
                return this.getConnection();
            }
            this.busyConnections.add(existingConnection);
            return existingConnection;
        }
        if (this.totalConnections() < 15 && !this.connectionPending) {
            this.makeBackgroundConnection();
        }
        while (this.availableConnections.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        return this.getConnection();
    }

    private void ensureInit() {
        if (!this.init) {
            throw new IllegalStateException("Connection is not established (init == false)!");
        }
    }

    private void makeBackgroundConnection() {
        this.connectionPending = true;
        try {
            Thread connectThread = new Thread((Runnable)this, "JPhotoTagger: Making background JDBC connection");
            connectThread.start();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Connection con = this.makeNewConnection();
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                this.availableConnections.add(con);
                this.connectionPending = false;
                this.notifyAll();
            }
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private Connection makeNewConnection() throws SQLException {
        try {
            Class.forName(this.driver);
            Connection con = DriverManager.getConnection(this.url, this.username, this.password);
            return con;
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Can't find class for driver: " + this.driver);
        }
        catch (Throwable t) {
            throw new SQLException("Can't connect to server " + this.url + "! " + t);
        }
    }

    synchronized void free(Connection con) {
        this.ensureInit();
        if (con == null) {
            throw new NullPointerException("con == null");
        }
        this.busyConnections.remove(con);
        this.availableConnections.add(con);
        this.notifyAll();
    }

    private synchronized int totalConnections() {
        return this.availableConnections.size() + this.busyConnections.size();
    }

    synchronized void closeAllConnections() {
        this.closeConnections(this.availableConnections);
        this.availableConnections.clear();
        this.closeConnections(this.busyConnections);
        this.busyConnections.clear();
    }

    private void closeConnections(List<Connection> connections) {
        try {
            for (int i = 0; i < connections.size(); ++i) {
                Connection con = connections.get(i);
                if (con.isClosed()) continue;
                con.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        StringBuilder info = new StringBuilder();
        info.append("ConnectionPool(").append(this.url).append(",").append(this.username).append(")").append(", available=").append(this.availableConnections.size()).append(", busy=").append(this.busyConnections.size()).append(", max=").append(15);
        return info.toString();
    }

    void setShutdown() {
        this.init = false;
    }

    private ConnectionPool() {
    }
}

