/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.repository.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventBus;
import org.jphototagger.domain.repository.event.autoscandirectories.AutoscanDirectoryDeletedEvent;
import org.jphototagger.domain.repository.event.autoscandirectories.AutoscanDirectoryInsertedEvent;
import org.jphototagger.repository.hsqldb.Database;

final class AutoscanDirectoriesDatabase
extends Database {
    static final AutoscanDirectoriesDatabase INSTANCE = new AutoscanDirectoriesDatabase();
    private static final Logger LOGGER = Logger.getLogger(AutoscanDirectoriesDatabase.class.getName());

    private AutoscanDirectoriesDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean insertDirectory(File directory) {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        boolean inserted = false;
        if (!this.existsDirectory(directory)) {
            PreparedStatement stmt;
            Connection con;
            block6: {
                con = null;
                stmt = null;
                try {
                    con = this.getConnection();
                    con.setAutoCommit(true);
                    stmt = con.prepareStatement("INSERT INTO autoscan_directories (directory) VALUES (?)");
                    stmt.setString(1, directory.getAbsolutePath());
                    LOGGER.log(Level.FINER, stmt.toString());
                    int count = stmt.executeUpdate();
                    boolean bl = inserted = count > 0;
                    if (!inserted) break block6;
                    this.notifyInserted(directory);
                }
                catch (Throwable t) {
                    try {
                        LOGGER.log(Level.SEVERE, null, t);
                    }
                    catch (Throwable throwable) {
                        AutoscanDirectoriesDatabase.close(stmt);
                        this.free(con);
                        throw throwable;
                    }
                    AutoscanDirectoriesDatabase.close(stmt);
                    this.free(con);
                }
            }
            AutoscanDirectoriesDatabase.close(stmt);
            this.free(con);
        }
        return inserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteDirectory(File directory) {
        PreparedStatement stmt;
        Connection con;
        boolean deleted;
        block5: {
            if (directory == null) {
                throw new NullPointerException("directory == null");
            }
            deleted = false;
            con = null;
            stmt = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(true);
                stmt = con.prepareStatement("DELETE FROM autoscan_directories WHERE directory = ?");
                stmt.setString(1, directory.getAbsolutePath());
                LOGGER.log(Level.FINER, stmt.toString());
                int count = stmt.executeUpdate();
                boolean bl = deleted = count > 0;
                if (!deleted) break block5;
                this.notifyDeleted(directory);
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    AutoscanDirectoriesDatabase.close(stmt);
                    this.free(con);
                    throw throwable;
                }
                AutoscanDirectoriesDatabase.close(stmt);
                this.free(con);
            }
        }
        AutoscanDirectoriesDatabase.close(stmt);
        this.free(con);
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean existsDirectory(File directory) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean exists;
        block5: {
            if (directory == null) {
                throw new NullPointerException("directory == null");
            }
            exists = false;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT COUNT(*) FROM autoscan_directories WHERE directory = ?");
                stmt.setString(1, directory.getAbsolutePath());
                LOGGER.log(Level.FINEST, stmt.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block5;
                exists = rs.getInt(1) > 0;
            }
            catch (Throwable t) {
                try {
                    LOGGER.log(Level.SEVERE, null, t);
                }
                catch (Throwable throwable) {
                    AutoscanDirectoriesDatabase.close(rs, stmt);
                    this.free(con);
                    throw throwable;
                }
                AutoscanDirectoriesDatabase.close(rs, stmt);
                this.free(con);
            }
        }
        AutoscanDirectoriesDatabase.close(rs, stmt);
        this.free(con);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> getAllDirectories() {
        ArrayList<File> directories = new ArrayList<File>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            String sql = "SELECT directory FROM autoscan_directories ORDER BY directory ASC";
            LOGGER.log(Level.FINEST, sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                directories.add(new File(rs.getString(1)));
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.log(Level.SEVERE, null, t);
                directories.clear();
            }
            catch (Throwable throwable) {
                AutoscanDirectoriesDatabase.close(rs, stmt);
                this.free(con);
                throw throwable;
            }
            AutoscanDirectoriesDatabase.close(rs, stmt);
            this.free(con);
        }
        AutoscanDirectoriesDatabase.close(rs, stmt);
        this.free(con);
        return directories;
    }

    private void notifyInserted(File dir) {
        EventBus.publish((Object)new AutoscanDirectoryInsertedEvent((Object)this, dir));
    }

    private void notifyDeleted(File dir) {
        EventBus.publish((Object)new AutoscanDirectoryDeletedEvent((Object)this, dir));
    }
}

